package com.zurrtum.create.foundation.utility;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class FluidFormatter {
    public static String asString(long amount, boolean shorten) {
        Couple<class_5250> couple = asComponents(amount, shorten);
        return couple.getFirst().getString() + " " + couple.getSecond().getString();
    }

    public static Couple<class_5250> asComponents(long amount, boolean shorten) {
        if (shorten && amount >= BucketFluidInventory.CAPACITY) {
            return Couple.create(
                class_2561.method_43470(String.format("%.1f", (float) (amount / BucketFluidInventory.CAPACITY))),
                class_2561.method_43471("create.generic.unit.buckets")
            );
        }

        return Couple.create(class_2561.method_43470(String.valueOf(amount)), class_2561.method_43471("create.generic.unit.millibuckets"));
    }
}
