package com.zurrtum.create.impl.contraption;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.api.contraption.BlockMovementChecks.*;
import com.zurrtum.create.api.contraption.ContraptionMovementSetting;
import com.zurrtum.create.content.contraptions.actors.AttachedActorBlock;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.zurrtum.create.content.contraptions.bearing.*;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlock;
import com.zurrtum.create.content.kinetics.fan.NozzleBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.vault.ItemVaultBlock;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlock;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import net.minecraft.class_1937;
import net.minecraft.class_2231;
import net.minecraft.class_2241;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2383;
import net.minecraft.class_2399;
import net.minecraft.class_2457;
import net.minecraft.class_2458;
import net.minecraft.class_2478;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2555;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_3619;
import net.minecraft.class_3709;
import net.minecraft.class_3713;
import net.minecraft.class_3867;
import net.minecraft.class_5815;
import net.minecraft.class_8810;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.state.properties.*;
import java.util.ArrayList;
import java.util.List;

public class BlockMovementChecksImpl {
    private static final List<MovementNecessaryCheck> MOVEMENT_NECESSARY_CHECKS = new ArrayList<>();
    private static final List<MovementAllowedCheck> MOVEMENT_ALLOWED_CHECKS = new ArrayList<>();
    private static final List<BrittleCheck> BRITTLE_CHECKS = new ArrayList<>();
    private static final List<AttachedCheck> ATTACHED_CHECKS = new ArrayList<>();
    private static final List<NotSupportiveCheck> NOT_SUPPORTIVE_CHECKS = new ArrayList<>();

    // registration adds to the start so newer ones are queried first
    // synchronize these so they're safe to call in async mod init

    public static synchronized void registerMovementNecessaryCheck(MovementNecessaryCheck check) {
        MOVEMENT_NECESSARY_CHECKS.addFirst(check);
    }

    public static synchronized void registerMovementAllowedCheck(MovementAllowedCheck check) {
        MOVEMENT_ALLOWED_CHECKS.addFirst(check);
    }

    public static synchronized void registerBrittleCheck(BrittleCheck check) {
        BRITTLE_CHECKS.addFirst(check);
    }

    public static synchronized void registerAttachedCheck(AttachedCheck check) {
        ATTACHED_CHECKS.addFirst(check);
    }

    public static synchronized void registerNotSupportiveCheck(NotSupportiveCheck check) {
        NOT_SUPPORTIVE_CHECKS.addFirst(check);
    }

    // queries

    public static boolean isMovementNecessary(class_2680 state, class_1937 world, class_2338 pos) {
        for (MovementNecessaryCheck check : MOVEMENT_NECESSARY_CHECKS) {
            CheckResult result = check.isMovementNecessary(state, world, pos);
            if (result != CheckResult.PASS) {
                return result.toBoolean();
            }
        }
        return BlockMovementChecksImpl.isMovementNecessaryFallback(state, world, pos);
    }

    public static boolean isMovementAllowed(class_2680 state, class_1937 world, class_2338 pos) {
        for (MovementAllowedCheck check : MOVEMENT_ALLOWED_CHECKS) {
            CheckResult result = check.isMovementAllowed(state, world, pos);
            if (result != CheckResult.PASS) {
                return result.toBoolean();
            }
        }
        return BlockMovementChecksImpl.isMovementAllowedFallback(state, world, pos);
    }

    public static boolean isBrittle(class_2680 state) {
        for (BrittleCheck check : BRITTLE_CHECKS) {
            CheckResult result = check.isBrittle(state);
            if (result != CheckResult.PASS) {
                return result.toBoolean();
            }
        }
        return BlockMovementChecksImpl.isBrittleFallback(state);
    }

    public static boolean isBlockAttachedTowards(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        for (AttachedCheck check : ATTACHED_CHECKS) {
            CheckResult result = check.isBlockAttachedTowards(state, world, pos, direction);
            if (result != CheckResult.PASS) {
                return result.toBoolean();
            }
        }
        return BlockMovementChecksImpl.isBlockAttachedTowardsFallback(state, world, pos, direction);
    }

    public static boolean isNotSupportive(class_2680 state, class_2350 facing) {
        for (NotSupportiveCheck check : NOT_SUPPORTIVE_CHECKS) {
            CheckResult result = check.isNotSupportive(state, facing);
            if (result != CheckResult.PASS) {
                return result.toBoolean();
            }
        }
        return BlockMovementChecksImpl.isNotSupportiveFallback(state, facing);
    }

    // fallbacks

    private static boolean isMovementNecessaryFallback(class_2680 state, class_1937 world, class_2338 pos) {
        if (BlockMovementChecks.isBrittle(state))
            return true;
        if (state.method_26164(AllBlockTags.MOVABLE_EMPTY_COLLIDER))
            return true;
        if (state.method_26220(world, pos).method_1110())
            return false;

        return !state.method_45474();
    }

    private static boolean isMovementAllowedFallback(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (block instanceof AbstractChassisBlock)
            return true;
        if (state.method_26214(world, pos) == -1)
            return false;
        if (state.method_26164(AllBlockTags.RELOCATION_NOT_SUPPORTED))
            return false;
        if (state.method_26164(AllBlockTags.NON_MOVABLE))
            return false;
        if (ContraptionMovementSetting.get(state) == ContraptionMovementSetting.UNMOVABLE)
            return false;

        // Move controllers only when they aren't moving
        if (block instanceof MechanicalPistonBlock && state.method_11654(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.MOVING)
            return true;
        if (block instanceof MechanicalBearingBlock) {
            class_2586 be = world.method_8321(pos);
            if (be instanceof MechanicalBearingBlockEntity)
                return !((MechanicalBearingBlockEntity) be).isRunning();
        }
        if (block instanceof ClockworkBearingBlock) {
            class_2586 be = world.method_8321(pos);
            if (be instanceof ClockworkBearingBlockEntity cbe)
                return !cbe.isRunning();
        }
        if (block instanceof PulleyBlock) {
            class_2586 be = world.method_8321(pos);
            if (be instanceof PulleyBlockEntity pulley)
                return !pulley.running;
        }

        if (state.method_27852(AllBlocks.BELT))
            return true;
        if (state.method_26204() instanceof class_3713)
            return true;
        if (state.method_26204() instanceof ITrackBlock)
            return false;
        if (state.method_26204() instanceof StationBlock)
            return false;
        return state.method_26223() != class_3619.field_15972;
    }

    private static boolean isBrittleFallback(class_2680 state) {
        class_2248 block = state.method_26204();
        if (state.method_28498(class_2741.field_16561))
            return true;

        if (block instanceof class_2399)
            return true;
        if (block instanceof class_8810)
            return true;
        if (block instanceof class_2478)
            return true;
        if (block instanceof class_2231)
            return true;
        if (block instanceof class_2341 && !(block instanceof class_3713)/* && !(block instanceof PackagerLinkBlock)*/)
            return true;
        if (block instanceof CartAssemblerBlock)
            return false;
        if (block instanceof class_2241)
            return true;
        if (block instanceof class_2312)
            return true;
        if (block instanceof class_2457)
            return true;
        if (block instanceof class_5815)
            return true;
        if (block instanceof WhistleBlock)
            return true;
        if (block instanceof WhistleExtenderBlock)
            return true;
        if (block instanceof BeltFunnelBlock)
            return true;
        return state.method_26164(AllBlockTags.BRITTLE);
    }

    private static boolean isBlockAttachedTowardsFallback(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2399)
            return state.method_11654(class_2399.field_11253) == direction.method_10153();
        if (block instanceof class_2555)
            return state.method_11654(class_2555.field_11731) == direction.method_10153();
        if (block instanceof class_2551)
            return state.method_11654(class_2551.field_11726) == direction.method_10153();
        if (block instanceof class_2508)
            return direction == class_2350.field_11033;
        if (block instanceof class_2231)
            return direction == class_2350.field_11033;
        if (block instanceof class_2323) {
            if (state.method_11654(class_2323.field_10946) == class_2756.field_12607 && direction == class_2350.field_11036)
                return true;
            return direction == class_2350.field_11033;
        }
        if (block instanceof class_2244) {
            class_2350 facing = state.method_11654(class_2244.field_11177);
            if (state.method_11654(class_2244.field_9967) == class_2742.field_12560)
                facing = facing.method_10153();
            return direction == facing;
        }
        if (block instanceof RedstoneLinkBlock)
            return direction.method_10153() == state.method_11654(RedstoneLinkBlock.field_10927);
        if (block instanceof class_2362)
            return direction == class_2350.field_11033;
        if (block instanceof class_2312)
            return direction == class_2350.field_11033;
        if (block instanceof class_2457)
            return direction == class_2350.field_11033;
        if (block instanceof class_5815)
            return direction == class_2350.field_11033;
        if (block instanceof class_2458)
            return state.method_11654(class_2458.field_11443) == direction.method_10153();
        if (block instanceof class_8810)
            return direction == class_2350.field_11033;
        if (block instanceof class_2341) {
            class_2738 attachFace = state.method_11654(class_2341.field_11007);
            if (attachFace == class_2738.field_12473)
                return direction == class_2350.field_11036;
            if (attachFace == class_2738.field_12475)
                return direction == class_2350.field_11033;
            if (attachFace == class_2738.field_12471)
                return direction.method_10153() == state.method_11654(class_2341.field_11177);
        }
        if (state.method_28498(class_2741.field_16561))
            return direction == (state.method_11654(class_2741.field_16561) ? class_2350.field_11036 : class_2350.field_11033);
        if (block instanceof class_2241)
            return direction == class_2350.field_11033;
        if (block instanceof AttachedActorBlock)
            return direction == state.method_11654(class_2383.field_11177).method_10153();
        if (block instanceof HandCrankBlock)
            return direction == state.method_11654(HandCrankBlock.FACING).method_10153();
        if (block instanceof NozzleBlock)
            return direction == state.method_11654(NozzleBlock.field_10927).method_10153();
        if (block instanceof class_3709) {
            class_3867 attachment = state.method_11654(class_2741.field_17104);
            if (attachment == class_3867.field_17098)
                return direction == class_2350.field_11033;
            if (attachment == class_3867.field_17099)
                return direction == class_2350.field_11036;
            return direction == state.method_11654(class_2383.field_11177);
        }
        if (state.method_26204() instanceof SailBlock)
            return direction.method_10166() != state.method_11654(SailBlock.field_10927).method_10166();
        if (state.method_26204() instanceof FluidTankBlock)
            return ConnectivityHandler.isConnected(world, pos, pos.method_10093(direction));
        if (state.method_26204() instanceof ItemVaultBlock)
            return ConnectivityHandler.isConnected(world, pos, pos.method_10093(direction));
        if (state.method_27852(AllBlocks.STICKER) && state.method_11654(StickerBlock.EXTENDED)) {
            return direction == state.method_11654(StickerBlock.field_10927) && !BlockMovementChecks.isNotSupportive(
                world.method_8320(pos.method_10093(direction)),
                direction.method_10153()
            );
        }
        //        if (block instanceof AbstractBogeyBlock<?> bogey)
        //            return bogey.getStickySurfaces(world, pos, state).contains(direction);
        if (block instanceof WhistleBlock)
            return direction == (state.method_11654(WhistleBlock.WALL) ? state.method_11654(WhistleBlock.FACING) : class_2350.field_11033);
        if (block instanceof WhistleExtenderBlock)
            return direction == class_2350.field_11033;
        return false;
    }

    private static boolean isNotSupportiveFallback(class_2680 state, class_2350 facing) {
        if (state.method_27852(AllBlocks.MECHANICAL_DRILL))
            return state.method_11654(class_2741.field_12525) == facing;
        if (state.method_27852(AllBlocks.MECHANICAL_BEARING))
            return state.method_11654(class_2741.field_12525) == facing;

        if (state.method_27852(AllBlocks.CART_ASSEMBLER))
            return facing == class_2350.field_11033;
        if (state.method_27852(AllBlocks.MECHANICAL_SAW))
            return state.method_11654(class_2741.field_12525) == facing;
        if (state.method_27852(AllBlocks.PORTABLE_STORAGE_INTERFACE))
            return state.method_11654(PortableStorageInterfaceBlock.field_10927) == facing;
        if (state.method_26204() instanceof AttachedActorBlock/* && !state.isOf(AllBlocks.MECHANICAL_ROLLER)*/)
            return state.method_11654(class_2741.field_12481) == facing;
        if (state.method_27852(AllBlocks.ROPE_PULLEY))
            return facing == class_2350.field_11033;
        if (state.method_26204() instanceof class_5815)
            return facing == class_2350.field_11036;
        if (state.method_26204() instanceof SailBlock)
            return facing.method_10166() == state.method_11654(SailBlock.field_10927).method_10166();
        if (state.method_27852(AllBlocks.PISTON_EXTENSION_POLE))
            return facing.method_10166() != state.method_11654(class_2741.field_12525).method_10166();
        if (state.method_27852(AllBlocks.MECHANICAL_PISTON_HEAD))
            return facing.method_10166() != state.method_11654(class_2741.field_12525).method_10166();
        if (state.method_27852(AllBlocks.STICKER) && !state.method_11654(StickerBlock.EXTENDED))
            return facing == state.method_11654(StickerBlock.field_10927);
        if (state.method_26204() instanceof SlidingDoorBlock)
            return false;
        return BlockMovementChecks.isBrittle(state);
    }
}