package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ClipboardContent(
    ClipboardType type, List<List<ClipboardEntry>> pages, boolean readOnly, int previouslyOpenedPage, Optional<class_2487> copiedValues
) {
    public static final ClipboardContent EMPTY = new ClipboardContent(ClipboardType.EMPTY, List.of(), false, 0, Optional.empty());

    public static final Codec<List<List<ClipboardEntry>>> PAGES_CODEC = ClipboardEntry.CODEC.listOf().listOf();
    public static final class_9139<class_9129, List<List<ClipboardEntry>>> PAGES_STREAM_CODEC = ClipboardEntry.STREAM_CODEC.method_56433(
        class_9135.method_56363()).method_56433(class_9135.method_56363());

    public static final Codec<ClipboardContent> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        ClipboardType.CODEC.fieldOf("type").forGetter(ClipboardContent::type),
        PAGES_CODEC.fieldOf("pages").forGetter(ClipboardContent::pages),
        Codec.BOOL.fieldOf("read_only").forGetter(ClipboardContent::readOnly),
        Codec.INT.fieldOf("previously_opened_page").forGetter(ClipboardContent::previouslyOpenedPage),
        class_2487.field_25128.optionalFieldOf("copied_values").forGetter(ClipboardContent::copiedValues)
    ).apply(instance, ClipboardContent::new));

    public static final class_9139<class_9129, ClipboardContent> STREAM_CODEC = class_9139.method_56906(
        ClipboardType.STREAM_CODEC,
        ClipboardContent::type,
        PAGES_STREAM_CODEC,
        ClipboardContent::pages,
        class_9135.field_48547,
        ClipboardContent::readOnly,
        class_9135.field_48550,
        ClipboardContent::previouslyOpenedPage,
        class_9135.method_56382(class_9135.field_48556),
        ClipboardContent::copiedValues,
        ClipboardContent::new
    );

    public ClipboardContent(ClipboardType type, List<List<ClipboardEntry>> pages, boolean readOnly) {
        this(type, pages, readOnly, 0, Optional.empty());
    }

    public ClipboardContent setType(ClipboardType type) {
        return new ClipboardContent(type, this.pages, this.readOnly, this.previouslyOpenedPage, this.copiedValues);
    }

    public ClipboardContent setPages(List<List<ClipboardEntry>> pages) {
        return new ClipboardContent(this.type, pages, this.readOnly, this.previouslyOpenedPage, this.copiedValues);
    }

    public ClipboardContent setReadOnly(boolean readOnly) {
        return new ClipboardContent(this.type, this.pages, readOnly, this.previouslyOpenedPage, this.copiedValues);
    }

    public ClipboardContent setPreviouslyOpenedPage(int previouslyOpenedPage) {
        return new ClipboardContent(this.type, this.pages, this.readOnly, previouslyOpenedPage, this.copiedValues);
    }

    public ClipboardContent setCopiedValues(class_2487 copiedValues) {
        return new ClipboardContent(this.type, this.pages, this.readOnly, this.previouslyOpenedPage, Optional.of(copiedValues));
    }
}
