package com.zurrtum.create.infrastructure.items;

import com.google.common.collect.MapMaker;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3954;

public interface ItemInventoryProvider<T extends SmartBlockEntity> extends class_3954 {
    Map<class_1263, class_1278> WRAPPERS = new MapMaker().weakValues().makeMap();

    @Override
    default class_1278 method_17680(class_2680 state, class_1936 world, class_2338 pos) {
        class_1263 inventory = getInventory(state, world, pos, null, null);
        if (inventory == null) {
            return null;
        }
        if (inventory instanceof class_1278 sidedInventory) {
            return sidedInventory;
        }
        return WRAPPERS.computeIfAbsent(inventory, SidedInventoryWrapper::new);
    }

    @SuppressWarnings("unchecked")
    default class_1263 getInventory(
        @Nullable class_2680 state,
        class_1936 world,
        class_2338 pos,
        @Nullable class_2586 blockEntity,
        class_2350 context
    ) {
        if (blockEntity == null) {
            if (state == null) {
                state = world.method_8320(pos);
            }
            if (state.method_31709()) {
                blockEntity = world.method_8321(pos);
            }
            if (blockEntity == null) {
                return null;
            }
        } else {
            if (state == null) {
                state = blockEntity.method_11010();
            }
        }
        Class<T> expectedClass = getBlockEntityClass();
        if (!expectedClass.isInstance(blockEntity))
            return null;
        return getInventory(world, pos, state, (T) blockEntity, context);
    }

    Class<T> getBlockEntityClass();

    class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, T blockEntity, class_2350 context);
}
