package com.zurrtum.create.infrastructure.packet.c2s;

import com.zurrtum.create.AllHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.catnip.codecs.stream.CatnipLargerStreamCodecs;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1799;
import net.minecraft.class_3244;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public record FactoryPanelConfigurationPacket(
    FactoryPanelPosition position, String address, Map<FactoryPanelPosition, Integer> inputAmounts, List<class_1799> craftingArrangement,
    int outputAmount, int promiseClearingInterval, FactoryPanelPosition removeConnection, boolean clearPromises, boolean reset, boolean redstoneReset
) implements C2SPacket {
    public static final class_9139<class_9129, FactoryPanelConfigurationPacket> CODEC = CatnipLargerStreamCodecs.composite(
        FactoryPanelPosition.PACKET_CODEC,
        FactoryPanelConfigurationPacket::position,
        class_9135.field_48554,
        FactoryPanelConfigurationPacket::address,
        class_9135.method_56377(HashMap::new, FactoryPanelPosition.PACKET_CODEC, class_9135.field_49675),
        FactoryPanelConfigurationPacket::inputAmounts,
        class_1799.field_49269,
        FactoryPanelConfigurationPacket::craftingArrangement,
        class_9135.field_48550,
        FactoryPanelConfigurationPacket::outputAmount,
        class_9135.field_48550,
        FactoryPanelConfigurationPacket::promiseClearingInterval,
        CatnipStreamCodecBuilders.nullable(FactoryPanelPosition.PACKET_CODEC),
        FactoryPanelConfigurationPacket::removeConnection,
        class_9135.field_48547,
        FactoryPanelConfigurationPacket::clearPromises,
        class_9135.field_48547,
        FactoryPanelConfigurationPacket::reset,
        class_9135.field_48547,
        FactoryPanelConfigurationPacket::redstoneReset,
        FactoryPanelConfigurationPacket::new
    );

    @Override
    public boolean runInMain() {
        return true;
    }

    @Override
    public class_9145<FactoryPanelConfigurationPacket> method_65080() {
        return AllPackets.CONFIGURE_FACTORY_PANEL;
    }

    @Override
    public BiConsumer<class_3244, FactoryPanelConfigurationPacket> callback() {
        return AllHandle::onFactoryPanelConfiguration;
    }
}
