package com.zurrtum.create.mixin;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingTypeRegistry;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_7923.class)
public class BuiltInRegistriesMixin {
    @Inject(method = "freeze()V", at = @At("HEAD"))
    private static void onInitialize(CallbackInfo ci) {
        if (!FabricLoader.getInstance().isModLoaded("fabric-api")) {
            Create.register();
            AllBlocks.ALL.forEach(block -> block.method_9595().method_11662().forEach(state -> {
                class_2248.field_10651.method_10205(state);
                state.method_26200();
            }));
            AllFluids.ALL.forEach(fluid -> fluid.method_15783().method_11662().forEach(class_3611.field_15904::method_10205));
        }
    }

    @Inject(method = "freeze()V", at = @At("TAIL"))
    private static void afterFreeze(CallbackInfo ci) {
        ArmInteractionPointType.register();
        FanProcessingTypeRegistry.register();
    }
}
