package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.content.contraptions.actors.seat.SeatBlock;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.equipment.armor.CardboardArmorHandler;
import com.zurrtum.create.content.equipment.armor.DivingBootsItem;
import com.zurrtum.create.content.equipment.toolbox.ToolboxHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.foundation.block.RunningEffectControlBlock;
import com.zurrtum.create.foundation.block.SoundControlBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_9221;

@Mixin(class_1297.class)
public abstract class EntityMixin implements class_9221 {
    @Shadow
    private class_4048 dimensions;

    @Shadow
    private class_1937 level;

    @Shadow
    public abstract class_2680 getBlockStateOn();

    @Shadow
    public abstract class_2338 getOnPos();

    @WrapOperation(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/EntityDimensions;eyeHeight()F"))
    private float setEyeHeight(class_4048 dimensions, Operation<Float> original) {
        if (this instanceof DeployerPlayer) {
            this.dimensions = dimensions.method_55685(0);
            return 0;
        }
        return original.call(dimensions);
    }

    @Inject(method = "rideTick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;tick()V"))
    private void tickRiding(CallbackInfo ci) {
        class_1297 entity = (class_1297) (Object) this;
        CapabilityMinecartController.entityTick(entity);
        DivingBootsItem.accelerateDescentUnderwater(entity);
        CardboardArmorHandler.mobsMayLoseTargetWhenItIsWearingCardboard(entity);
        ToolboxHandler.entityTick(entity, level);
    }

    @Inject(method = "startRiding(Lnet/minecraft/world/entity/Entity;ZZ)Z", at = @At(value = "HEAD"), cancellable = true)
    private void startRiding(class_1297 entity, boolean force, boolean emitEvent, CallbackInfoReturnable<Boolean> cir) {
        if (CouplingHandler.preventEntitiesFromMoutingOccupiedCart((class_1297) (Object) this, entity)) {
            cir.setReturnValue(false);
        }
    }

    @ModifyReturnValue(method = "fireImmune()Z", at = @At("RETURN"))
    private boolean isFireImmune(boolean original) {
        if (original) {
            return true;
        }
        return ((class_1297) (Object) this) instanceof class_1657 player && AllSynchedDatas.FIRE_IMMUNE.get(player);
    }

    @Inject(method = "isUnderWater()Z", at = @At("HEAD"), cancellable = true)
    private void isSubmergedInWater(CallbackInfoReturnable<Boolean> cir) {
        if (((class_1297) (Object) this) instanceof class_1657 player && AllSynchedDatas.HEAVY_BOOTS.get(player)) {
            cir.setReturnValue(false);
        }
    }

    @WrapOperation(method = "spawnAtLocation(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/entity/item/ItemEntity;", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/level/ServerLevel;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean captureDrops(class_3218 world, class_1297 item, Operation<Boolean> original) {
        class_1297 entity = (class_1297) (Object) this;
        if (AllSynchedDatas.CRUSH_DROP.get(entity)) {
            item.method_18799(class_243.field_1353);
        } else {
            Optional<List<class_1799>> value = AllSynchedDatas.CAPTURE_DROPS.get(entity);
            if (value.isPresent()) {
                value.get().add(((class_1542) item).method_6983());
                return true;
            }
        }
        return original.call(world, item);
    }

    @Inject(method = "spawnSprintParticle()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;"), cancellable = true)
    private void onRunningEffect(CallbackInfo ci, @Local class_2680 state, @Local class_2338 pos) {
        if (state.method_26204() instanceof RunningEffectControlBlock block) {
            if (block.addRunningEffects(state, level, pos, (class_1297) (Object) this)) {
                ci.cancel();
            }
        }
    }

    @WrapOperation(method = "refreshDimensions()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;getDimensions(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/entity/EntityDimensions;"))
    private class_4048 calculateDimensions(class_1297 entity, class_4050 pose, Operation<class_4048> original) {
        class_4048 dimensions = CardboardArmorHandler.playerHitboxChangesWhenHidingAsBox(entity);
        if (dimensions != null) {
            return dimensions;
        }
        return original.call(entity, pose);
    }

    @WrapOperation(method = "playStepSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;getSoundType()Lnet/minecraft/world/level/block/SoundType;"))
    private class_2498 getStepSound(class_2680 state, Operation<class_2498> original, @Local(argsOnly = true) class_2338 pos) {
        if (state.method_26204() instanceof SoundControlBlock block) {
            return block.getSoundGroup(level, pos);
        }
        return original.call(state);
    }

    @WrapOperation(method = "move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;getOnPosLegacy()Lnet/minecraft/core/BlockPos;"))
    private class_2338 fixSeatBouncing(class_1297 instance, Operation<class_2338> original) {
        return getBlockStateOn().method_26204() instanceof SeatBlock ? getOnPos() : original.call(instance);
    }
}
