package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.zurrtum.create.AllDamageTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.content.equipment.armor.CardboardArmorHandler;
import com.zurrtum.create.content.equipment.armor.DivingBootsItem;
import com.zurrtum.create.content.equipment.armor.DivingHelmetItem;
import com.zurrtum.create.content.equipment.armor.NetheriteDivingHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.foundation.block.LandingEffectControlBlock;
import com.zurrtum.create.foundation.block.ScaffoldingControlBlock;
import com.zurrtum.create.foundation.block.SlipperinessControlBlock;
import com.zurrtum.create.foundation.block.SoundControlBlock;
import com.zurrtum.create.foundation.item.SwingControlItem;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_6862;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    @Shadow
    public abstract @Nullable class_1657 getLastHurtByPlayer();

    @Shadow
    public abstract class_1799 getItemInHand(class_1268 hand);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @WrapOperation(method = "travelInAir(Lnet/minecraft/world/phys/Vec3;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/Block;getFriction()F"))
    private float getSlipperiness(class_2248 block, Operation<Float> original, @Local class_2338 pos) {
        if (block instanceof SlipperinessControlBlock controlBlock) {
            return controlBlock.getSlipperiness(method_73183(), pos);
        }
        return original.call(block);
    }

    @WrapOperation(method = "baseTick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;isEyeInFluid(Lnet/minecraft/tags/TagKey;)Z"))
    private boolean breatheInLava(class_1309 entity, class_6862<class_3611> tagKey, Operation<Boolean> original, @Local class_3218 serverWorld) {
        if (original.call(entity, tagKey)) {
            return true;
        }
        if (entity instanceof class_3222 serverPlayer && !serverPlayer.method_31549().field_7480 && entity.method_5771()) {
            DivingHelmetItem.breatheInLava(serverPlayer, serverWorld);
        }
        return false;
    }

    @WrapOperation(method = "baseTick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/effect/MobEffectUtil;hasWaterBreathing(Lnet/minecraft/world/entity/LivingEntity;)Z"))
    private boolean canBreatheInWater(class_1309 entity, Operation<Boolean> original, @Local class_3218 serverWorld) {
        if (original.call(entity)) {
            return true;
        }
        if (entity instanceof class_3222 serverPlayer && !serverPlayer.method_31549().field_7480) {
            return DivingHelmetItem.breatheUnderwater(serverPlayer, serverWorld);
        }
        return false;
    }

    @Inject(method = "collectEquipmentChanges()Ljava/util/Map;", at = @At(value = "INVOKE", target = "Ljava/util/Map;entrySet()Ljava/util/Set;"))
    private void onLivingEquipmentChange(CallbackInfoReturnable<Map<class_1304, class_1799>> cir) {
        if (((Object) this) instanceof class_1657 player) {
            CardboardArmorHandler.playerChangesEquipment(player);
            NetheriteDivingHandler.onEquipmentChange(player);
        }
    }

    @Inject(method = "travelInLava(Lnet/minecraft/world/phys/Vec3;DZD)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"))
    private void setOnGround(
        class_243 input,
        double baseGravity,
        boolean isFalling,
        double oldY,
        CallbackInfo ci,
        @Share("onGround") LocalBooleanRef onGround
    ) {
        if (((Object) this) instanceof class_1657 player) {
            onGround.set(player.method_24828());
        }
    }

    @Inject(method = "travelInLava(Lnet/minecraft/world/phys/Vec3;DZD)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;getFluidHeight(Lnet/minecraft/tags/TagKey;)D"))
    private void onTravelInFluid(
        class_243 input,
        double baseGravity,
        boolean isFalling,
        double oldY,
        CallbackInfo ci,
        @Share("onGround") LocalBooleanRef onGround
    ) {
        if (((Object) this) instanceof class_1657 player) {
            DivingBootsItem.onLavaTravel(player, onGround.get());
        }
    }

    @WrapOperation(method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean captureDrops(class_1937 world, class_1297 entity, Operation<Boolean> original) {
        if (AllSynchedDatas.CRUSH_DROP.get(this)) {
            entity.method_18799(class_243.field_1353);
        } else if (world instanceof class_3218) {
            Optional<List<class_1799>> value = AllSynchedDatas.CAPTURE_DROPS.get(this);
            if (value.isPresent()) {
                value.get().add(((class_1542) entity).method_6983());
                return true;
            }
        }
        return original.call(world, entity);
    }

    @Inject(method = "dropExperience(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"), cancellable = true)
    private void onDropExperience(class_3218 world, class_1297 attacker, CallbackInfo ci) {
        if (getLastHurtByPlayer() instanceof DeployerPlayer) {
            ci.cancel();
        }
    }

    @Inject(method = "dropAllDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)V", at = @At(value = "HEAD"))
    private void onDropPre(class_3218 world, class_1282 damageSource, CallbackInfo ci, @Share("handler") LocalIntRef handler) {
        if (damageSource.method_49708(AllDamageTypes.CRUSH)) {
            AllSynchedDatas.CRUSH_DROP.set(this, true);
            handler.set(1);
        } else if (damageSource.method_5529() instanceof DeployerPlayer) {
            AllSynchedDatas.CAPTURE_DROPS.set(this, Optional.of(new ArrayList<>()));
            handler.set(2);
        }
    }

    @Inject(method = "dropAllDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)V", at = @At(value = "TAIL"))
    private void onDropPost(class_3218 world, class_1282 damageSource, CallbackInfo ci, @Share("handler") LocalIntRef handler) {
        switch (handler.get()) {
            case 1 -> AllSynchedDatas.CRUSH_DROP.set(this, false);
            case 2 -> AllSynchedDatas.CAPTURE_DROPS.get(this).ifPresent(drops -> {
                class_1661 inventory = ((DeployerPlayer) damageSource.method_5529()).cast().method_31548();
                drops.forEach(inventory::method_7398);
                AllSynchedDatas.CAPTURE_DROPS.set(this, Optional.empty());
            });
        }
    }

    @WrapOperation(method = "checkFallDamage(DZLnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;isAir()Z"))
    private boolean onLandingEffect(
        class_2680 state,
        Operation<Boolean> original,
        @Local(argsOnly = true) class_2338 pos,
        @Local class_3218 world,
        @Local(ordinal = 1) double distance
    ) {
        if (original.call(state)) {
            return true;
        }
        if (state.method_26204() instanceof LandingEffectControlBlock block) {
            return block.addLandingEffects(state, world, pos, (class_1309) (Object) this, distance);
        }
        return false;
    }

    @Inject(method = "swing(Lnet/minecraft/world/InteractionHand;Z)V", at = @At("HEAD"), cancellable = true)
    private void swingHand(class_1268 hand, boolean fromServerPlayer, CallbackInfo ci) {
        class_1799 stack = getItemInHand(hand);
        if (stack.method_7909() instanceof SwingControlItem item) {
            if (item.onEntitySwing(stack, (class_1309) (Object) this, hand)) {
                ci.cancel();
            }
        }
    }

    @Inject(method = "getVisibilityPercent(Lnet/minecraft/world/entity/Entity;)D", at = @At("HEAD"), cancellable = true)
    private void getAttackDistanceScalingFactor(class_1297 entity, CallbackInfoReturnable<Double> cir) {
        if (CardboardArmorHandler.testForStealth(entity)) {
            cir.setReturnValue(0d);
        }
    }

    @WrapOperation(method = "handleOnClimbable(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z"))
    private boolean isScaffolding(class_2680 state, class_2248 block, Operation<Boolean> original) {
        return original.call(state, block) || state.method_26204() instanceof ScaffoldingControlBlock;
    }

    @WrapOperation(method = "playBlockFallSound()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;getSoundType()Lnet/minecraft/world/level/block/SoundType;"))
    private class_2498 getBlockFallSound(
        class_2680 state,
        Operation<class_2498> original,
        @Local(ordinal = 0) int x,
        @Local(ordinal = 1) int y,
        @Local(ordinal = 2) int z
    ) {
        if (state.method_26204() instanceof SoundControlBlock block) {
            return block.getSoundGroup(method_73183(), new class_2338(x, y, z));
        }
        return original.call(state);
    }
}
