package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.content.contraptions.minecart.MinecartCouplingItem;
import com.zurrtum.create.content.contraptions.mounted.MinecartContraptionItem;
import com.zurrtum.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.zurrtum.create.foundation.item.CustomAttackSoundItem;
import com.zurrtum.create.foundation.item.DamageControlItem;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public abstract class PlayerMixin {
    @Inject(method = "interactOn(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;", ordinal = 0), cancellable = true)
    private void interact(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1657 player = (class_1657) (Object) this;
        class_1269 result = MinecartCouplingItem.handleInteractionWithMinecart(player, hand, entity);
        if (result != null) {
            cir.setReturnValue(result);
        }
        result = MinecartContraptionItem.wrenchCanBeUsedToPickUpMinecartContraptions(player, hand, entity);
        if (result != null) {
            cir.setReturnValue(result);
        }
    }

    @Inject(method = "itemAttackInteraction(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/damagesource/DamageSource;Z)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;hurtEnemy(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)Z"))
    private void attack(class_1297 entity, class_1799 attackingItemStack, class_1282 damageSource, boolean applyToTarget, CallbackInfo ci) {
        ExtendoGripItem.postDamageEntity((class_1657) (Object) this);
    }

    @WrapOperation(method = "attack(Lnet/minecraft/world/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;hurtOrSimulate(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean damage(class_1297 entity, class_1282 source, float amount, Operation<Boolean> original, @Local class_1799 stack) {
        if (stack.method_7909() instanceof DamageControlItem item && !item.damage(entity)) {
            return true;
        }
        return original.call(entity, source, amount);
    }

    @WrapOperation(method = "itemAttackInteraction(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/damagesource/DamageSource;Z)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;postHurtEnemy(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)V"))
    private void postDamageEntity(class_1799 stack, class_1309 target, class_1309 user, Operation<Void> original) {
        if (stack.method_7909() instanceof DamageControlItem item && !item.damage(target)) {
            return;
        }
        original.call(stack, target, user);
    }

    @WrapOperation(method = "attack(Lnet/minecraft/world/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;playServerSideSound(Lnet/minecraft/sounds/SoundEvent;)V"))
    private void playSound(class_1657 player, class_3414 sound, Operation<Void> original, @Local class_1799 attackingItemStack) {
        if (attackingItemStack.method_7909() instanceof CustomAttackSoundItem item) {
            item.playSound(player.method_73183(), player, player.method_23317(), player.method_23318(), player.method_23321(), sound, player.method_5634(), 1f, 1f);
        } else {
            original.call(player, sound);
        }
    }

    @WrapOperation(method = "attack(Lnet/minecraft/world/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;attackVisualEffects(Lnet/minecraft/world/entity/Entity;ZZZF)V"))
    private void playSound(
        class_1657 player,
        class_1297 entity,
        boolean criticalAttack,
        boolean sweepAttack,
        boolean fullStrengthAttack,
        float magicBoost,
        Operation<Void> original,
        @Local class_1799 attackingItemStack
    ) {
        if (attackingItemStack.method_7909() instanceof CustomAttackSoundItem item) {
            class_3414 sound;
            if (criticalAttack) {
                sound = class_3417.field_15016;
                player.method_7277(entity);
            } else if (!sweepAttack) {
                sound = fullStrengthAttack ? class_3417.field_14840 : class_3417.field_14625;
            } else {
                sound = null;
            }
            if (sound != null) {
                item.playSound(player.method_73183(), player, player.method_23317(), player.method_23318(), player.method_23321(), sound, player.method_5634(), 1f, 1f);
                original.call(player, entity, false, true, fullStrengthAttack, magicBoost);
                return;
            }
        }
        original.call(player, entity, criticalAttack, sweepAttack, fullStrengthAttack, magicBoost);
    }

    @Inject(method = "addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V", at = @At("TAIL"))
    private void writeCustomData(class_11372 view, CallbackInfo ci) {
        class_2487 compound = AllSynchedDatas.TOOLBOX.get((class_1657) (Object) this);
        if (!compound.method_33133()) {
            view.method_71468("CreateToolboxData", class_2487.field_25128, compound);
        }
    }

    @Inject(method = "readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V", at = @At("TAIL"))
    private void readCustomData(class_11368 view, CallbackInfo ci) {
        view.method_71426("CreateToolboxData", class_2487.field_25128).ifPresent(compound -> AllSynchedDatas.TOOLBOX.set((class_1657) (Object) this, compound));
    }
}
