package com.zurrtum.create.mixin;

import com.zurrtum.create.api.behaviour.display.DisplayHolder;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2487;
import net.minecraft.class_2625;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2625.class)
public class SignBlockEntityMixin implements DisplayHolder {
    @Unique
    private class_2487 displayLink;

    @Override
    public class_2487 getDisplayLinkData() {
        return displayLink;
    }

    @Override
    public void setDisplayLinkData(class_2487 data) {
        displayLink = data;
    }

    @Inject(method = "saveAdditional(Lnet/minecraft/world/level/storage/ValueOutput;)V", at = @At("TAIL"))
    private void writeData(class_11372 view, CallbackInfo ci) {
        writeDisplayLink(view);
    }

    @Inject(method = "loadAdditional(Lnet/minecraft/world/level/storage/ValueInput;)V", at = @At("TAIL"))
    private void readData(class_11368 view, CallbackInfo ci) {
        readDisplayLink(view);
    }
}
