/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.TextureSheetSegment;
import com.zurrtum.create.client.catnip.gui.render.BreadcrumbArrowRenderState;
import com.zurrtum.create.client.catnip.gui.render.GradientRectRenderState;
import com.zurrtum.create.client.catnip.gui.render.RadialSectorRenderState;
import com.zurrtum.create.client.catnip.gui.render.TexturedQuadRenderState;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_241;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class UIRenderHelper {
    public static final Couple<Color> COLOR_TEXT = Couple.create(new Color(-1118482), new Color(-6052957)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_DARKER = Couple.create(new Color(-6052957), new Color(-8355712)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_ACCENT = Couple.create(new Color(-2232577), new Color(-6246208)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_STRONG_ACCENT = Couple.create(new Color(-7686442), new Color(-9530709)).map(Color::setImmutable);
    public static final Color COLOR_STREAK = new Color(0x101010, false).setImmutable();

    public static void streak(class_332 graphics, float angle, int x, int y, int breadth, int length) {
        UIRenderHelper.streak(graphics, angle, x, y, breadth, length, COLOR_STREAK);
    }

    public static void streak(class_332 graphics, float angle, int x, int y, int breadth, int length, Color c) {
        Color color = c.copy().setImmutable();
        Color c1 = color.scaleAlpha(0.625f);
        Color c2 = color.scaleAlpha(0.5f);
        Color c3 = color.scaleAlpha(0.0625f);
        Color c4 = color.scaleAlpha(0.0f);
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)x, (float)y);
        poseStack.rotate((float)((double)(angle - 90.0f) * (Math.PI / 180)));
        UIRenderHelper.streak(graphics, breadth / 2, length, c1, c2, c3, c4);
        poseStack.popMatrix();
    }

    private static void streak(class_332 graphics, int width, int height, Color c1, Color c2, Color c3, Color c4) {
        if (NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen()) {
            return;
        }
        double split1 = 0.5;
        double split2 = 0.75;
        graphics.method_25296(-width, 0, width, (int)(split1 * (double)height), c1.getRGB(), c2.getRGB());
        graphics.method_25296(-width, (int)(split1 * (double)height), width, (int)(split2 * (double)height), c2.getRGB(), c3.getRGB());
        graphics.method_25296(-width, (int)(split2 * (double)height), width, height, c3.getRGB(), c4.getRGB());
    }

    public static void angledGradient(class_332 graphics, float angle, int x, int y, float breadth, float length, Couple<Color> c) {
        UIRenderHelper.angledGradient(graphics, angle, x, y, breadth, length, (Color)c.getFirst(), (Color)c.getSecond());
    }

    public static void angledGradient(class_332 graphics, float angle, int x, int y, float breadth, float length, Color startColor, Color endColor) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)x, (float)y);
        poseStack.rotate((float)((double)(angle - 90.0f) * (Math.PI / 180)));
        float w = breadth / 2.0f;
        UIRenderHelper.drawGradientRect(graphics, -w, 0.0f, w, length, startColor, endColor);
        poseStack.popMatrix();
    }

    public static void drawGradientRect(class_332 graphics, float left, float top, float right, float bottom, Color startColor, Color endColor) {
        graphics.field_59826.method_70919((class_11244)new GradientRectRenderState(new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), left, top, right, bottom, startColor, endColor));
    }

    public static void breadcrumbArrow(class_332 graphics, int x, int y, int width, int height, int indent, Couple<Color> colors) {
        UIRenderHelper.breadcrumbArrow(graphics, x, y, width, height, indent, (Color)colors.getFirst(), (Color)colors.getSecond());
    }

    public static void breadcrumbArrow(class_332 graphics, int x, int y, int width, int height, int indent, Color startColor, Color endColor) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)(x - indent), (float)y);
        UIRenderHelper.breadcrumbArrow(graphics, width, height, indent, startColor, endColor);
        poseStack.popMatrix();
    }

    private static void breadcrumbArrow(class_332 graphics, int width, int height, int indent, Color c1, Color c2) {
        float x0 = 0.0f;
        float x1 = indent;
        float x2 = width;
        float x3 = indent + width;
        float y0 = 0.0f;
        float y1 = (float)height / 2.0f;
        float y2 = height;
        indent = Math.abs(indent);
        width = Math.abs(width);
        Color fc1 = Color.mixColors(c1, c2, 0.0f);
        Color fc2 = Color.mixColors(c1, c2, (float)indent / ((float)width + 2.0f * (float)indent));
        Color fc3 = Color.mixColors(c1, c2, (float)(indent + width) / ((float)width + 2.0f * (float)indent));
        Color fc4 = Color.mixColors(c1, c2, 1.0f);
        graphics.field_59826.method_70919((class_11244)new BreadcrumbArrowRenderState(new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), x0, x1, x2, x3, y0, y1, y2, fc1, fc2, fc3, fc4, indent + width, height));
    }

    public static void drawRadialSector(class_332 graphics, float innerRadius, float outerRadius, float startAngle, float arcAngle, Color innerColor, Color outerColor) {
        List<class_241> innerPoints = UIRenderHelper.getPointsForCircleArc(innerRadius, startAngle, arcAngle);
        List<class_241> outerPoints = UIRenderHelper.getPointsForCircleArc(outerRadius, startAngle, arcAngle);
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (class_241 point : innerPoints) {
            minX = Math.min(minX, (double)point.field_1343);
            maxX = Math.max(maxX, (double)point.field_1343);
            minY = Math.min(minY, (double)point.field_1342);
            maxY = Math.max(maxY, (double)point.field_1342);
        }
        for (class_241 point : outerPoints) {
            minX = Math.min(minX, (double)point.field_1343);
            maxX = Math.max(maxX, (double)point.field_1343);
            minY = Math.min(minY, (double)point.field_1342);
            maxY = Math.max(maxY, (double)point.field_1342);
        }
        graphics.field_59826.method_70919((class_11244)new RadialSectorRenderState(new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), minX, maxX, minY, maxY, innerPoints, outerPoints, innerColor, outerColor));
    }

    private static List<class_241> getPointsForCircleArc(float radius, float startAngle, float arcAngle) {
        int segmentCount = Math.abs(arcAngle) <= 90.0f ? 16 : 32;
        ArrayList<class_241> points = new ArrayList<class_241>(segmentCount);
        float theta = (float)Math.PI / 180 * arcAngle / (float)(segmentCount - 1);
        float t = (float)Math.PI / 180 * startAngle;
        for (int i = 0; i < segmentCount; ++i) {
            points.add(new class_241((float)((double)radius * Math.cos(t)), (float)((double)radius * Math.sin(t))));
            t += theta;
        }
        return points;
    }

    public static void drawColoredTexture(class_332 graphics, class_11231 texture, Color c, int x, int y, int tex_left, int tex_top, int width, int height) {
        UIRenderHelper.drawColoredTexture(graphics, texture, c, x, y, tex_left, tex_top, width, height, 256, 256);
    }

    public static void drawColoredTexture(class_332 graphics, class_11231 texture, Color c, int x, int y, float tex_left, float tex_top, int width, int height, int sheet_width, int sheet_height) {
        UIRenderHelper.drawColoredTexture(graphics, texture, c, x, x + width, y, y + height, width, height, tex_left, tex_top, sheet_width, sheet_height);
    }

    public static void drawStretched(class_332 graphics, int left, int top, int w, int h, TextureSheetSegment tex) {
        UIRenderHelper.drawTexturedQuad(graphics, tex.bind(), Color.WHITE, left, left + w, top, top + h, (float)tex.getStartX() / 256.0f, (float)(tex.getStartX() + tex.getWidth()) / 256.0f, (float)tex.getStartY() / 256.0f, (float)(tex.getStartY() + tex.getHeight()) / 256.0f);
    }

    public static void drawCropped(class_332 graphics, int left, int top, int w, int h, TextureSheetSegment tex) {
        UIRenderHelper.drawTexturedQuad(graphics, tex.bind(), Color.WHITE, left, left + w, top, top + h, (float)tex.getStartX() / 256.0f, (float)(tex.getStartX() + w) / 256.0f, (float)tex.getStartY() / 256.0f, (float)(tex.getStartY() + h) / 256.0f);
    }

    private static void drawColoredTexture(class_332 graphics, class_11231 texture, Color c, int left, int right, int top, int bot, int tex_width, int tex_height, float tex_left, float tex_top, int sheet_width, int sheet_height) {
        UIRenderHelper.drawTexturedQuad(graphics, texture, c, left, right, top, bot, (tex_left + 0.0f) / (float)sheet_width, (tex_left + (float)tex_width) / (float)sheet_width, (tex_top + 0.0f) / (float)sheet_height, (tex_top + (float)tex_height) / (float)sheet_height);
    }

    private static void drawTexturedQuad(class_332 graphics, class_11231 texture, Color c, int left, int right, int top, int bot, float u1, float u2, float v1, float v2) {
        graphics.field_59826.method_70919((class_11244)new TexturedQuadRenderState(new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), texture, left, right, top, bot, c, u1, u2, v1, v2, graphics.field_44659.method_70863()));
    }

    public static void flipForGuiRender(class_4587 poseStack) {
        poseStack.method_34425((Matrix4fc)new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
    }
}

