/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.catnip.gui.render.EntityBlockRenderState;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11515;
import net.minecraft.class_11659;
import net.minecraft.class_11684;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12137;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class EntityBlockRenderer
extends class_11239<EntityBlockRenderState> {
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap();
    private static final class_12075 CAMERA = new class_12075();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public EntityBlockRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(int key) {
        GpuTexture texture = (GpuTexture)TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    public void prepare(EntityBlockRenderState block, class_11246 state, int windowScaleFactor) {
        class_827 renderer;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        float size = block.size() * (float)windowScaleFactor;
        GpuTexture texture = (GpuTexture)TEXTURES.get(block.id());
        if (texture == null) {
            texture = GpuTexture.create((int)size);
            TEXTURES.put(block.id(), (Object)texture);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.field_60042.method_71092(size, size), (class_10366)class_10366.field_54954);
        texture.prepare();
        this.matrices.method_22903();
        this.matrices.method_46416(size / 2.0f, size / 2.0f, 0.0f);
        float scale = block.comp_4133() * (float)windowScaleFactor;
        this.matrices.method_22905(scale, -scale, scale);
        class_310 mc = class_310.method_1551();
        class_757 gameRenderer = mc.field_1773;
        gameRenderer.method_71114().method_71034(class_308.class_11274.field_60028);
        if (block.zRot() != 0.0f) {
            this.matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(block.zRot()));
        }
        if (block.xRot() != 0.0f) {
            this.matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(block.xRot()));
        }
        if (block.yRot() != 0.0f) {
            this.matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(block.yRot()));
        }
        this.matrices.method_46416(-0.5f, -0.5f, -0.5f);
        class_776 blockRenderManager = mc.method_1541();
        class_1937 world = block.world();
        class_2680 blockState = block.state();
        class_2586 blockEntity = block.entity();
        class_1921 layer = class_4696.method_23679((class_2680)blockState) == class_11515.field_60926 ? class_4722.method_29382() : class_4722.method_24074();
        SinglePosVirtualBlockGetter lightWorld = SinglePosVirtualBlockGetter.createFullBright();
        lightWorld.blockState(blockState);
        lightWorld.blockEntity(blockEntity);
        class_1087 model = blockRenderManager.method_3349(blockState);
        ObjectArrayList parts = new ObjectArrayList();
        class_5819 random = world.method_8409();
        class_1087 class_10872 = WrapperBlockStateModel.unwrapCompat(model);
        if (class_10872 instanceof WrapperBlockStateModel) {
            WrapperBlockStateModel wrapper = (WrapperBlockStateModel)class_10872;
            wrapper.addPartsWithInfo((class_1920)world, block.pos(), blockState, random, (List<class_10889>)parts);
        } else {
            model.method_68513(random, (List)parts);
        }
        blockRenderManager.method_3355(blockState, class_2338.field_10980, (class_1920)lightWorld, this.matrices, this.field_59933.method_73477(layer), false, (List)parts);
        if (blockEntity != null && (renderer = mc.method_31975().method_3550(blockEntity)) != null) {
            class_11684 renderDispatcher = gameRenderer.method_72911();
            class_1937 previousLevel = blockEntity.method_10997();
            class_2680 stateBefore = blockEntity.method_11010();
            blockEntity.method_31662(world);
            blockEntity.method_31664(blockState);
            class_11954 renderState = renderer.method_74335();
            renderer.method_74331(blockEntity, renderState, 0.0f, EntityBlockRenderer.CAMERA.field_63078, null);
            renderer.method_3569(renderState, this.matrices, (class_11659)renderDispatcher.method_73003(), CAMERA);
            renderDispatcher.method_73002();
            blockEntity.method_31664(stateBefore);
            blockEntity.method_31662(previousLevel);
        }
        this.field_59933.method_22993();
        this.matrices.method_22909();
        texture.clear();
        state.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView(), (class_12137)RenderSystem.getSamplerCache().method_75297(FilterMode.NEAREST)), block.method_72127(), block.comp_4122(), block.comp_4123(), block.comp_4124(), block.comp_4125(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
    }

    protected void renderToTexture(EntityBlockRenderState state, class_4587 matrices) {
    }

    protected String method_70906() {
        return "Entity Block";
    }

    public Class<EntityBlockRenderState> method_70903() {
        return EntityBlockRenderState.class;
    }
}

