/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions;

import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.TranslatingContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.collision.ContinuousOBBCollider;
import com.zurrtum.create.foundation.collision.Matrix3d;
import com.zurrtum.create.foundation.collision.OrientedBB;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.ClientMotionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ContraptionColliderLockPacketRequest;
import com.zurrtum.create.infrastructure.packet.c2s.TrainCollisionPacket;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_745;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.MutablePair;

@Environment(value=EnvType.CLIENT)
public class ContraptionColliderClient {
    private static MutablePair<WeakReference<AbstractContraptionEntity>, Double> safetyLock = new MutablePair();
    private static Map<AbstractContraptionEntity, Map<class_1657, Double>> remoteSafetyLocks = new WeakHashMap<AbstractContraptionEntity, Map<class_1657, Double>>();
    private static int packetCooldown = 0;

    static void collideEntities(AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        if (contraption == null) {
            return;
        }
        class_238 bounds = contraptionEntity.method_5829();
        if (bounds == null) {
            return;
        }
        class_243 contraptionPosition = contraptionEntity.method_73189();
        class_243 contraptionMotion = contraptionPosition.method_1020(contraptionEntity.getPrevPositionVec());
        class_243 anchorVec = contraptionEntity.getAnchorVec();
        AbstractContraptionEntity.ContraptionRotationState rotation = null;
        if (ContraptionColliderClient.safetyLock.left != null && ((WeakReference)ContraptionColliderClient.safetyLock.left).get() == contraptionEntity) {
            ContraptionColliderClient.saveClientPlayerFromClipping(contraptionEntity, contraptionMotion);
        }
        boolean skipClientPlayer = false;
        class_1937 world = contraptionEntity.method_73183();
        List entitiesWithinAABB = world.method_8390(class_1297.class, bounds.method_1014(2.0).method_1012(0.0, 32.0, 0.0), contraptionEntity::method_30949);
        for (class_1297 entity : entitiesWithinAABB) {
            double d1;
            double idealVerticalMotion;
            boolean anyCollision;
            class_243 entityMotion;
            if (!entity.method_5805()) continue;
            ContraptionCollider.PlayerType playerType = ContraptionColliderClient.getPlayerType(entity);
            if (playerType == ContraptionCollider.PlayerType.REMOTE) {
                if (!(contraption instanceof TranslatingContraption)) continue;
                ContraptionColliderClient.saveRemotePlayerFromClipping((class_1657)entity, contraptionEntity, contraptionMotion);
                continue;
            }
            entity.method_24204().forEach(e -> {
                if (e instanceof class_3222) {
                    class_3222 playerEntity = (class_3222)e;
                    playerEntity.field_13987.field_14138 = 0;
                }
            });
            if (playerType == ContraptionCollider.PlayerType.CLIENT) {
                if (skipClientPlayer) continue;
                skipClientPlayer = true;
            }
            if (rotation == null) {
                rotation = contraptionEntity.getRotationState();
            }
            Matrix3d rotationMatrix = rotation.asMatrix();
            class_243 entityPosition = entity.method_73189();
            class_238 entityBounds = entity.method_5829();
            class_243 motion = entity.method_18798();
            float yawOffset = rotation.getYawOffset();
            class_243 position = ContraptionCollider.getWorldToLocalTranslation(entity, anchorVec, rotationMatrix, yawOffset);
            if (playerType == ContraptionCollider.PlayerType.CLIENT && entityBounds.method_17940() > 1.0) {
                entityBounds = entityBounds.method_1002(0.0, 0.125, 0.0);
            }
            motion = motion.method_1020(contraptionMotion);
            motion = rotationMatrix.transform(motion);
            class_238 localBB = entityBounds.method_997(position).method_1014(1.0E-7);
            OrientedBB obb = new OrientedBB(localBB);
            obb.setRotation(rotationMatrix);
            class_243 motionCopy = motion;
            List collidableBBs = contraption.getSimplifiedEntityColliders().orElseGet(() -> {
                ArrayList bbs = new ArrayList();
                List<class_265> potentialHits = ContraptionCollider.getPotentiallyCollidedShapes(world, contraption, localBB.method_18804(motionCopy));
                potentialHits.forEach(shape -> bbs.addAll(shape.method_1090()));
                return bbs;
            });
            MutableObject collisionResponse = new MutableObject((Object)class_243.field_1353);
            MutableObject normal = new MutableObject((Object)class_243.field_1353);
            MutableObject location = new MutableObject((Object)class_243.field_1353);
            MutableBoolean surfaceCollision = new MutableBoolean(false);
            MutableFloat temporalResponse = new MutableFloat(1.0f);
            class_243 obbCenter = obb.getCenter();
            boolean doHorizontalPass = !rotation.hasVerticalRotation();
            for (boolean horizontalPass : Iterate.trueAndFalse) {
                boolean noVerticalCollision;
                boolean verticalPass = !horizontalPass || !doHorizontalPass;
                for (class_238 bb : collidableBBs) {
                    boolean nearest;
                    class_243 separation;
                    double timeOfImpact;
                    class_243 currentResponse = (class_243)collisionResponse.getValue();
                    class_243 currentCenter = obbCenter.method_1019(currentResponse);
                    if (Math.abs(currentCenter.field_1352 - bb.method_1005().field_1352) - entityBounds.method_17939() - 1.0 > bb.method_17939() / 2.0 || Math.abs(currentCenter.field_1351 + motion.field_1351 - bb.method_1005().field_1351) - entityBounds.method_17940() - 1.0 > bb.method_17940() / 2.0 || Math.abs(currentCenter.field_1350 - bb.method_1005().field_1350) - entityBounds.method_17941() - 1.0 > bb.method_17941() / 2.0) continue;
                    obb.setCenter(currentCenter);
                    ContinuousOBBCollider.ContinuousSeparationManifold intersect = obb.intersect(bb, motion);
                    if (intersect == null) continue;
                    if (verticalPass && surfaceCollision.isFalse()) {
                        surfaceCollision.setValue(intersect.isSurfaceCollision());
                    }
                    boolean isTemporal = (timeOfImpact = intersect.getTimeOfImpact()) > 0.0 && timeOfImpact < 1.0;
                    class_243 collidingNormal = intersect.getCollisionNormal();
                    class_243 collisionPosition = intersect.getCollisionPosition();
                    if (!isTemporal && (separation = intersect.asSeparationVec(entity.method_49476())) != null && !separation.equals((Object)class_243.field_1353)) {
                        collisionResponse.setValue((Object)currentResponse.method_1019(separation));
                        timeOfImpact = 0.0;
                    }
                    boolean bl = nearest = timeOfImpact >= 0.0 && (double)temporalResponse.getValue().floatValue() > timeOfImpact;
                    if (collidingNormal != null && nearest) {
                        normal.setValue((Object)collidingNormal);
                    }
                    if (collisionPosition != null && nearest) {
                        location.setValue((Object)collisionPosition);
                    }
                    if (!isTemporal || !((double)temporalResponse.getValue().floatValue() > timeOfImpact)) continue;
                    temporalResponse.setValue((Number)timeOfImpact);
                }
                if (verticalPass) break;
                boolean noVerticalMotionResponse = temporalResponse.getValue().floatValue() == 1.0f;
                boolean bl = noVerticalCollision = ((class_243)collisionResponse.getValue()).field_1351 == 0.0;
                if (noVerticalCollision && noVerticalMotionResponse) break;
                collisionResponse.setValue((Object)((class_243)collisionResponse.getValue()).method_18805(1.0078125, 0.0, 1.0078125));
            }
            class_243 entityMotionNoTemporal = entityMotion = entity.method_18798();
            class_243 collisionNormal = (class_243)normal.getValue();
            class_243 collisionLocation = (class_243)location.getValue();
            class_243 totalResponse = (class_243)collisionResponse.getValue();
            boolean hardCollision = !totalResponse.equals((Object)class_243.field_1353);
            boolean temporalCollision = temporalResponse.getValue().floatValue() != 1.0f;
            class_243 motionResponse = !temporalCollision ? motion : motion.method_1029().method_1021(motion.method_1033() * (double)temporalResponse.getValue().floatValue());
            rotationMatrix.transpose();
            motionResponse = rotationMatrix.transform(motionResponse).method_1019(contraptionMotion);
            totalResponse = rotationMatrix.transform(totalResponse);
            totalResponse = VecHelper.rotate(totalResponse, yawOffset, class_2350.class_2351.field_11052);
            collisionNormal = rotationMatrix.transform(collisionNormal);
            collisionNormal = VecHelper.rotate(collisionNormal, yawOffset, class_2350.class_2351.field_11052);
            collisionNormal = collisionNormal.method_1029();
            collisionLocation = rotationMatrix.transform(collisionLocation);
            collisionLocation = VecHelper.rotate(collisionLocation, yawOffset, class_2350.class_2351.field_11052);
            rotationMatrix.transpose();
            double bounce = 0.0;
            double slide = 0.0;
            if (!collisionLocation.equals((Object)class_243.field_1353)) {
                class_2680 blockState;
                collisionLocation = collisionLocation.method_1019(entity.method_73189().method_1019(entity.method_5829().method_1005()).method_1021(0.5));
                if (temporalCollision) {
                    collisionLocation = collisionLocation.method_1031(0.0, motionResponse.field_1351, 0.0);
                }
                class_2338 pos = class_2338.method_49638((class_2374)contraptionEntity.toLocalVector(entity.method_73189(), 0.0f));
                if (contraption.getBlocks().containsKey(pos) && (blockState = contraption.getBlocks().get(pos).comp_1342()).method_26164(class_3481.field_22414)) {
                    surfaceCollision.setTrue();
                    totalResponse = totalResponse.method_1031(0.0, (double)0.1f, 0.0);
                }
                pos = class_2338.method_49638((class_2374)contraptionEntity.toLocalVector(collisionLocation, 0.0f));
                if (contraption.getBlocks().containsKey(pos)) {
                    blockState = contraption.getBlocks().get(pos).comp_1342();
                    MovingInteractionBehaviour movingInteractionBehaviour = contraption.getInteractors().get(pos);
                    if (movingInteractionBehaviour != null) {
                        movingInteractionBehaviour.handleEntityCollision(entity, pos, contraptionEntity);
                    }
                    bounce = BlockHelper.getBounceMultiplier(blockState.method_26204());
                    slide = Math.max(0.0f, blockState.method_26204().method_9499() - 0.6f);
                }
            }
            boolean hasNormal = !collisionNormal.equals((Object)class_243.field_1353);
            boolean bl = anyCollision = hardCollision || temporalCollision;
            if (bounce > 0.0 && hasNormal && anyCollision && ContraptionCollider.bounceEntity(entity, collisionNormal, contraptionEntity, bounce)) {
                entity.method_73183().method_43128((class_1297)(playerType == ContraptionCollider.PlayerType.CLIENT ? entity : null), entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14560, class_3419.field_15245, 0.5f, 1.0f);
                continue;
            }
            if (temporalCollision && (idealVerticalMotion = motionResponse.field_1351) != entityMotion.field_1351) {
                entity.method_18799(entityMotion.method_18805(1.0, 0.0, 1.0).method_1031(0.0, idealVerticalMotion, 0.0));
                entityMotion = entity.method_18798();
            }
            if (hardCollision) {
                double motionX = entityMotion.method_10216();
                double motionY = entityMotion.method_10214();
                double motionZ = entityMotion.method_10215();
                double intersectX = totalResponse.method_10216();
                double intersectY = totalResponse.method_10214();
                double intersectZ = totalResponse.method_10215();
                double horizonalEpsilon = 0.0078125;
                if (motionX != 0.0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0.0 == intersectX < 0.0) {
                    entityMotion = entityMotion.method_18805(0.0, 1.0, 1.0);
                }
                if (motionY != 0.0 && intersectY != 0.0 && motionY > 0.0 == intersectY < 0.0) {
                    entityMotion = entityMotion.method_18805(1.0, 0.0, 1.0).method_1031(0.0, contraptionMotion.field_1351, 0.0);
                }
                if (motionZ != 0.0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0.0 == intersectZ < 0.0) {
                    entityMotion = entityMotion.method_18805(1.0, 1.0, 0.0);
                }
            }
            if (bounce == 0.0 && slide > 0.0 && hasNormal && anyCollision && rotation.hasVerticalRotation()) {
                double slideFactor = collisionNormal.method_18805(1.0, 0.0, 1.0).method_1033() * 1.25;
                class_243 motionIn = entityMotionNoTemporal.method_18805(0.0, 0.9, 0.0).method_1031(0.0, (double)-0.01f, 0.0);
                class_243 slideNormal = collisionNormal.method_1036(motionIn.method_1036(collisionNormal)).method_1029();
                class_243 newMotion = entityMotion.method_18805(0.85, 0.0, 0.85).method_1019(slideNormal.method_1021(((double)0.2f + slide) * motionIn.method_1033() * slideFactor).method_1031(0.0, (double)-0.1f - collisionNormal.field_1351 * 0.125, 0.0));
                entity.method_18799(newMotion);
                entityMotion = entity.method_18798();
            }
            if (!hardCollision && surfaceCollision.isFalse()) continue;
            class_243 allowedMovement = ContraptionCollider.collide(totalResponse, entity);
            entity.method_5814(entityPosition.field_1352 + allowedMovement.field_1352, entityPosition.field_1351 + allowedMovement.field_1351, entityPosition.field_1350 + allowedMovement.field_1350);
            entityPosition = entity.method_73189();
            entityMotion = ContraptionColliderClient.handleDamageFromTrain(world, contraptionEntity, contraptionMotion, entity, entityMotion, playerType);
            entity.field_6037 = true;
            class_243 contactPointMotion = class_243.field_1353;
            if (surfaceCollision.isTrue()) {
                boolean canWalk;
                contraptionEntity.registerColliding(entity);
                entity.field_6017 = 0.0;
                for (class_1297 rider : entity.method_5736()) {
                    if (ContraptionColliderClient.getPlayerType(rider) != ContraptionCollider.PlayerType.CLIENT) continue;
                    class_310.method_1551().field_1724.field_3944.method_52787((class_2596)new ClientMotionPacket(rider.method_18798(), true, 0.0f));
                }
                boolean bl2 = canWalk = bounce != 0.0 || slide == 0.0;
                if (canWalk || !rotation.hasVerticalRotation()) {
                    if (canWalk) {
                        entity.method_24830(true);
                    }
                    if (entity instanceof class_1542) {
                        entityMotion = entityMotion.method_18805(0.5, 1.0, 0.5);
                    }
                }
                contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
                allowedMovement = ContraptionCollider.collide(contactPointMotion, entity);
                entity.method_5814(entityPosition.field_1352 + allowedMovement.field_1352, entityPosition.field_1351, entityPosition.field_1350 + allowedMovement.field_1350);
            }
            entity.method_18799(entityMotion);
            if (playerType != ContraptionCollider.PlayerType.CLIENT) continue;
            double d0 = entity.method_23317() - entity.field_6014 - contactPointMotion.field_1352;
            float limbSwing = class_3532.method_15355((float)((float)(d0 * d0 + (d1 = entity.method_23321() - entity.field_5969 - contactPointMotion.field_1350) * d1))) * 4.0f;
            if (limbSwing > 1.0f) {
                limbSwing = 1.0f;
            }
            class_310.method_1551().field_1724.field_3944.method_52787((class_2596)new ClientMotionPacket(entityMotion, true, limbSwing));
            if (!entity.method_24828() || !(contraption instanceof TranslatingContraption)) continue;
            safetyLock.setLeft(new WeakReference<AbstractContraptionEntity>(contraptionEntity));
            safetyLock.setRight((Object)(entity.method_23318() - contraptionEntity.method_23318()));
        }
    }

    private static class_243 handleDamageFromTrain(class_1937 world, AbstractContraptionEntity contraptionEntity, class_243 contraptionMotion, class_1297 entity, class_243 entityMotion, ContraptionCollider.PlayerType playerType) {
        class_1657 p;
        if (!(contraptionEntity instanceof CarriageContraptionEntity)) {
            return entityMotion;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)contraptionEntity;
        if (!entity.method_24828()) {
            return entityMotion;
        }
        if (AllSynchedDatas.CONTRAPTION_GROUNDED.get(entity).booleanValue()) {
            AllSynchedDatas.CONTRAPTION_GROUNDED.set(entity, false);
            return entityMotion;
        }
        if (cce.collidingEntities.containsKey(entity)) {
            return entityMotion;
        }
        if (entity instanceof class_1542) {
            return entityMotion;
        }
        if (cce.nonDamageTicks != 0) {
            return entityMotion;
        }
        if (!((Boolean)AllConfigs.server().trains.trainsCauseDamage.get()).booleanValue()) {
            return entityMotion;
        }
        class_243 diffMotion = contraptionMotion.method_1020(entity.method_18798());
        if (diffMotion.method_1033() <= (double)0.35f || contraptionMotion.method_1033() <= (double)0.35f) {
            return entityMotion;
        }
        class_1282 source = AllDamageSources.get(world).runOver(contraptionEntity);
        double damage = diffMotion.method_1033();
        if (entity.method_5864().method_5891() == class_1311.field_6302) {
            damage *= 2.0;
        }
        if (entity instanceof class_1657 && ((p = (class_1657)entity).method_68878() || p.method_7325())) {
            return entityMotion;
        }
        if (playerType == ContraptionCollider.PlayerType.CLIENT) {
            ((class_746)entity).field_3944.method_52787((class_2596)new TrainCollisionPacket((int)(damage * 16.0), contraptionEntity.method_5628()));
            world.method_8396(entity, entity.method_24515(), class_3417.field_15016, class_3419.field_15254, 1.0f, 0.75f);
        }
        class_243 added = entityMotion.method_1019(contraptionMotion.method_18805(1.0, 0.0, 1.0).method_1029().method_1031(0.0, 0.25, 0.0).method_1021(damage * 4.0)).method_1019(diffMotion);
        return VecHelper.clamp(added, 3.0f);
    }

    private static void saveClientPlayerFromClipping(AbstractContraptionEntity contraptionEntity, class_243 contraptionMotion) {
        class_746 entity = class_310.method_1551().field_1724;
        if (entity.method_5765()) {
            return;
        }
        double prevDiff = (Double)ContraptionColliderClient.safetyLock.right;
        double currentDiff = entity.method_23318() - contraptionEntity.method_23318();
        double motion = contraptionMotion.method_1020((class_243)entity.method_18798()).field_1351;
        double trend = Math.signum(currentDiff - prevDiff);
        class_634 handler = entity.field_3944;
        if (handler.method_2880().size() > 1) {
            if (packetCooldown > 0) {
                --packetCooldown;
            }
            if (packetCooldown == 0) {
                handler.method_52787((class_2596)new ContraptionColliderLockPacketRequest(contraptionEntity.method_5628(), currentDiff));
                packetCooldown = 3;
            }
        }
        if (trend == 0.0) {
            return;
        }
        if (trend == Math.signum(motion)) {
            return;
        }
        double speed = contraptionMotion.method_18805(0.0, 1.0, 0.0).method_1027();
        if (trend > 0.0 && speed < 0.1) {
            return;
        }
        if (speed < 0.05) {
            return;
        }
        if (!ContraptionColliderClient.savePlayerFromClipping((class_1657)entity, contraptionEntity, contraptionMotion, prevDiff)) {
            safetyLock.setLeft(null);
        }
    }

    public static void lockPacketReceived(int contraptionId, int remotePlayerId, double suggestedOffset) {
        class_638 level = class_310.method_1551().field_1687;
        class_1297 class_12972 = level.method_8469(contraptionId);
        if (!(class_12972 instanceof ControlledContraptionEntity)) {
            return;
        }
        ControlledContraptionEntity contraptionEntity = (ControlledContraptionEntity)class_12972;
        class_1297 class_12973 = level.method_8469(remotePlayerId);
        if (!(class_12973 instanceof class_745)) {
            return;
        }
        class_745 player = (class_745)class_12973;
        remoteSafetyLocks.computeIfAbsent(contraptionEntity, $ -> new WeakHashMap()).put(player, suggestedOffset);
    }

    private static void saveRemotePlayerFromClipping(class_1657 entity, AbstractContraptionEntity contraptionEntity, class_243 contraptionMotion) {
        if (entity.method_5765()) {
            return;
        }
        Map locksOnThisContraption = remoteSafetyLocks.getOrDefault((Object)contraptionEntity, Collections.emptyMap());
        double prevDiff = locksOnThisContraption.getOrDefault(entity, entity.method_23318() - contraptionEntity.method_23318());
        if (!ContraptionColliderClient.savePlayerFromClipping(entity, contraptionEntity, contraptionMotion, prevDiff) && locksOnThisContraption.containsKey(entity)) {
            locksOnThisContraption.remove(entity);
        }
    }

    private static boolean savePlayerFromClipping(class_1657 entity, AbstractContraptionEntity contraptionEntity, class_243 contraptionMotion, double yStartOffset) {
        class_238 bb = entity.method_5829().method_35580(0.25, 0.0, 0.25);
        double shortestDistance = Double.MAX_VALUE;
        double yStart = (double)entity.method_49476() + contraptionEntity.method_23318() + yStartOffset;
        double rayLength = Math.max(5.0, Math.abs(entity.method_23318() - yStart));
        for (int rayIndex = 0; rayIndex < 4; ++rayIndex) {
            class_243 end;
            class_243 start = new class_243(rayIndex / 2 == 0 ? bb.field_1323 : bb.field_1320, yStart, rayIndex % 2 == 0 ? bb.field_1321 : bb.field_1324);
            class_3965 hitResult = ContraptionHandlerClient.rayTraceContraption(start, end = start.method_1031(0.0, -rayLength, 0.0), contraptionEntity);
            if (hitResult == null) continue;
            class_243 hit = contraptionEntity.toGlobalVector(hitResult.method_17784(), 1.0f);
            double hitDiff = start.field_1351 - hit.field_1351;
            if (!(shortestDistance > hitDiff)) continue;
            shortestDistance = hitDiff;
        }
        if (shortestDistance > rayLength) {
            return false;
        }
        entity.method_5814(entity.method_23317(), yStart - shortestDistance, entity.method_23321());
        return true;
    }

    private static ContraptionCollider.PlayerType getPlayerType(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            return ContraptionCollider.PlayerType.NONE;
        }
        return entity instanceof class_746 ? ContraptionCollider.PlayerType.CLIENT : ContraptionCollider.PlayerType.REMOTE;
    }
}

