/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.bell;

import com.google.common.collect.Streams;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_4538;
import net.minecraft.class_9169;

@Environment(value=EnvType.CLIENT)
public class SoulPulseEffect {
    public static final int MAX_DISTANCE = 11;
    private static final List<List<class_2338>> LAYERS = SoulPulseEffect.genLayers();
    private static final int WAITING_TICKS = 100;
    public static final int TICKS_PER_LAYER = 6;
    private int ticks;
    public final class_2338 pos;
    public final int distance;
    public final List<class_2338> added;

    public SoulPulseEffect(class_2338 pos, int distance, boolean canOverlap) {
        this.ticks = 6 * distance;
        this.pos = pos;
        this.distance = distance;
        this.added = canOverlap ? null : new ArrayList();
    }

    public boolean finished() {
        return this.ticks <= -100;
    }

    public boolean canOverlap() {
        return this.added == null;
    }

    public List<class_2338> tick(class_1937 world) {
        if (this.finished()) {
            return null;
        }
        --this.ticks;
        if (this.ticks < 0 || this.ticks % 6 != 0) {
            return null;
        }
        List<class_2338> spawns = this.getPotentialSoulSpawns(world);
        while (spawns.isEmpty() && this.ticks > 0) {
            this.ticks -= 6;
            spawns.addAll(this.getPotentialSoulSpawns(world));
        }
        return spawns;
    }

    public int currentLayerIdx() {
        return this.distance - this.ticks / 6 - 1;
    }

    public List<class_2338> getPotentialSoulSpawns(class_1937 world) {
        if (world == null) {
            return new ArrayList<class_2338>();
        }
        return SoulPulseEffect.getLayer(this.currentLayerIdx()).map(p -> p.method_10081((class_2382)this.pos)).filter(p -> SoulPulseEffect.canSpawnSoulAt(world, p, true)).collect(Collectors.toList());
    }

    public static boolean isDark(class_1937 world, class_2338 at) {
        return world.method_8314(class_1944.field_9282, at) < 1;
    }

    public static boolean canSpawnSoulAt(class_1937 world, class_2338 at, boolean ignoreLight) {
        class_1299 dummy = class_1299.field_6051;
        double dummyWidth = 0.2;
        double dummyHeight = 0.75;
        double w2 = dummyWidth / 2.0;
        return world != null && class_9169.field_48745.isSpawnPositionOk((class_4538)world, at, dummy) && (ignoreLight || SoulPulseEffect.isDark(world, at)) && Streams.stream((Iterable)world.method_20812(null, new class_238((double)at.method_10263() + 0.5 - w2, (double)at.method_10264(), (double)at.method_10260() + 0.5 - w2, (double)at.method_10263() + 0.5 + w2, (double)at.method_10264() + dummyHeight, (double)at.method_10260() + 0.5 + w2))).allMatch(class_265::method_1110);
    }

    public void spawnParticles(class_1937 world, class_2338 at) {
        if (world == null || !world.method_8608()) {
            return;
        }
        class_243 p = class_243.method_24954((class_2382)at);
        if (this.canOverlap()) {
            world.method_8494((class_2394)((int)Math.round(VecHelper.getCenterOf((class_2382)this.pos).method_1022(VecHelper.getCenterOf((class_2382)at))) >= this.distance ? AllParticleTypes.SOUL_PERIMETER : AllParticleTypes.SOUL_EXPANDING_PERIMETER), p.field_1352 + 0.5, p.field_1351 + 0.5, p.field_1350 + 0.5, 0.0, 0.0, 0.0);
        }
        if (SoulPulseEffect.isDark(world, at)) {
            world.method_8494((class_2394)AllParticleTypes.SOUL, p.field_1352 + 0.5, p.field_1351 + 0.5, p.field_1350 + 0.5, 0.0, 0.0, 0.0);
            world.method_8406((class_2394)AllParticleTypes.SOUL_BASE, p.field_1352 + 0.5, p.field_1351 + 0.01, p.field_1350 + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private static List<List<class_2338>> genLayers() {
        ArrayList<List<class_2338>> layers = new ArrayList<List<class_2338>>();
        for (int i = 0; i < 11; ++i) {
            layers.add(new ArrayList());
        }
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 11; ++y) {
                for (int z = 0; z < 11; ++z) {
                    class_2338 prev;
                    int i;
                    class_2338 candidate = new class_2338(x, y, z);
                    int dist = (int)Math.round(Math.sqrt(candidate.method_10262((class_2382)class_2338.field_10980)));
                    if (dist > 11) continue;
                    if (dist <= 0) {
                        dist = 1;
                    }
                    List layer = (List)layers.get(dist - 1);
                    int start = layer.size();
                    int end = start + 1;
                    layer.add(candidate);
                    if (candidate.method_10263() != 0) {
                        layer.add(new class_2338(-candidate.method_10263(), candidate.method_10264(), candidate.method_10260()));
                        ++end;
                    }
                    if (candidate.method_10264() != 0) {
                        for (i = start; i < end; ++i) {
                            prev = (class_2338)layer.get(i);
                            layer.add(new class_2338(prev.method_10263(), -prev.method_10264(), prev.method_10260()));
                        }
                        end += end - start;
                    }
                    if (candidate.method_10260() == 0) continue;
                    for (i = start; i < end; ++i) {
                        prev = (class_2338)layer.get(i);
                        layer.add(new class_2338(prev.method_10263(), prev.method_10264(), -prev.method_10260()));
                    }
                }
            }
        }
        return layers;
    }

    public static Stream<class_2338> getLayer(int idx) {
        if (idx < 0 || idx >= 11) {
            return Stream.empty();
        }
        return LAYERS.get(idx).stream();
    }
}

