/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.flywheel.api.material.CardinalLightingMode;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.vertex.MutableVertexList;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.QuadMesh;
import com.zurrtum.create.client.flywheel.lib.model.SingleMeshModel;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_4608;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class FluidMesh {
    private static final RendererReloadCache<class_1058, Model> STREAM = new RendererReloadCache<class_1058, Model>(sprite -> new SingleMeshModel(new FluidStreamMesh((class_1058)sprite), FluidMesh.material(sprite)));
    private static final RendererReloadCache<SurfaceKey, Model> SURFACE = new RendererReloadCache<SurfaceKey, Model>(sprite -> new SingleMeshModel(new FluidSurfaceMesh(sprite.texture(), sprite.width()), FluidMesh.material(sprite.texture())));
    public static final float PIPE_RADIUS = 0.1875f;

    public static Model stream(class_1058 sprite) {
        return STREAM.get(sprite);
    }

    public static Model surface(class_1058 sprite, float width) {
        return SURFACE.get(new SurfaceKey(sprite, width));
    }

    private static SimpleMaterial material(class_1058 sprite) {
        return SimpleMaterial.builder().cardinalLightingMode(CardinalLightingMode.OFF).texture(sprite.method_45852()).transparency(Transparency.ORDER_INDEPENDENT).build();
    }

    @Environment(value=EnvType.CLIENT)
    private record SurfaceKey(class_1058 texture, float width) {
    }

    @Environment(value=EnvType.CLIENT)
    public record FluidSurfaceMesh(class_1058 texture, float width) implements QuadMesh
    {
        @Override
        public int vertexCount() {
            int quadWidth = class_3532.method_15386((float)this.width) - class_3532.method_15375((float)(-this.width));
            return 4 * quadWidth * quadWidth;
        }

        @Override
        public void write(MutableVertexList vertexList) {
            for (int i = 0; i < this.vertexCount(); ++i) {
                vertexList.r(i, 1.0f);
                vertexList.g(i, 1.0f);
                vertexList.b(i, 1.0f);
                vertexList.a(i, 1.0f);
                vertexList.light(i, 0);
                vertexList.overlay(i, class_4608.field_21444);
                vertexList.normalX(i, 0.0f);
                vertexList.normalY(i, 1.0f);
                vertexList.normalZ(i, 0.0f);
                vertexList.y(i, 0.0f);
            }
            float textureScale = 0.0625f;
            float left = -this.width;
            float right = this.width;
            float down = -this.width;
            float up = this.width;
            int vertex = 0;
            float x1 = left;
            while (x1 < right) {
                float x1floor = class_3532.method_15375((float)x1);
                float x2 = Math.min(x1floor + 1.0f, right);
                float u1 = this.texture.method_4580((x1 - x1floor) * 16.0f * textureScale);
                float u2 = this.texture.method_4580((x2 - x1floor) * 16.0f * textureScale);
                float y1 = down;
                while (y1 < up) {
                    float y1floor = class_3532.method_15375((float)y1);
                    float y2 = Math.min(y1floor + 1.0f, up);
                    float v1 = this.texture.method_4570((y1 - y1floor) * 16.0f * textureScale);
                    float v2 = this.texture.method_4570((y2 - y1floor) * 16.0f * textureScale);
                    vertexList.x(vertex, x1);
                    vertexList.z(vertex, y1);
                    vertexList.u(vertex, u1);
                    vertexList.v(vertex, v1);
                    vertexList.x(vertex + 1, x1);
                    vertexList.z(vertex + 1, y2);
                    vertexList.u(vertex + 1, u1);
                    vertexList.v(vertex + 1, v2);
                    vertexList.x(vertex + 2, x2);
                    vertexList.z(vertex + 2, y2);
                    vertexList.u(vertex + 2, u2);
                    vertexList.v(vertex + 2, v2);
                    vertexList.x(vertex + 3, x2);
                    vertexList.z(vertex + 3, y1);
                    vertexList.u(vertex + 3, u2);
                    vertexList.v(vertex + 3, v1);
                    vertex += 4;
                    y1 = y2;
                }
                x1 = x2;
            }
        }

        @Override
        public Vector4fc boundingSphere() {
            return new Vector4f(0.0f, 0.0f, 0.0f, this.width / class_3532.field_15724);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record FluidStreamMesh(class_1058 texture) implements QuadMesh
    {
        @Override
        public int vertexCount() {
            return 32;
        }

        @Override
        public void write(MutableVertexList vertexList) {
            for (int i = 0; i < this.vertexCount(); ++i) {
                vertexList.r(i, 1.0f);
                vertexList.g(i, 1.0f);
                vertexList.b(i, 1.0f);
                vertexList.a(i, 1.0f);
                vertexList.light(i, 0);
                vertexList.overlay(i, class_4608.field_21444);
                vertexList.v(i, 0.0f);
            }
            float textureScale = 0.03125f;
            float radius = 0.1875f;
            float left = -radius;
            float right = radius;
            int vertex = 0;
            for (class_2350 horizontalDirection : Iterate.horizontalDirections) {
                float x1 = left;
                while (x1 < right) {
                    float x1floor = class_3532.method_15375((float)x1);
                    float x2 = Math.min(x1floor + 1.0f, right);
                    float u1 = this.texture.method_4580((x1 - x1floor) * 16.0f * textureScale);
                    float u2 = this.texture.method_4580((x2 - x1floor) * 16.0f * textureScale);
                    FluidStreamMesh.putQuad(vertexList, vertex, horizontalDirection, radius, x1, x2, u1, u2);
                    vertex += 4;
                    x1 = x2;
                }
            }
        }

        private static void putQuad(MutableVertexList vertexList, int i, class_2350 horizontal, float radius, float p0, float p1, float u0, float u1) {
            float zStart;
            float zEnd;
            float xEnd;
            float xStart;
            switch (horizontal) {
                case field_11043: {
                    xStart = p1;
                    xEnd = p0;
                    zStart = zEnd = -radius;
                    break;
                }
                case field_11035: {
                    xStart = p0;
                    xEnd = p1;
                    zStart = zEnd = radius;
                    break;
                }
                case field_11039: {
                    zStart = p0;
                    zEnd = p1;
                    xStart = xEnd = -radius;
                    break;
                }
                case field_11034: {
                    zStart = p1;
                    zEnd = p0;
                    xStart = xEnd = radius;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(horizontal));
                }
            }
            vertexList.x(i, xStart);
            vertexList.y(i, 1.0f);
            vertexList.z(i, zStart);
            vertexList.u(i, u0);
            vertexList.x(i + 1, xStart);
            vertexList.y(i + 1, 0.0f);
            vertexList.z(i + 1, zStart);
            vertexList.u(i + 1, u0);
            vertexList.x(i + 2, xEnd);
            vertexList.y(i + 2, 0.0f);
            vertexList.z(i + 2, zEnd);
            vertexList.u(i + 2, u1);
            vertexList.x(i + 3, xEnd);
            vertexList.y(i + 3, 1.0f);
            vertexList.z(i + 3, zEnd);
            vertexList.u(i + 3, u1);
            for (int j = 0; j < 4; ++j) {
                vertexList.normalX(i + j, horizontal.method_10148());
                vertexList.normalY(i + j, horizontal.method_10164());
                vertexList.normalZ(i + j, horizontal.method_10165());
            }
        }

        @Override
        public Vector4fc boundingSphere() {
            return new Vector4f(0.0f, 0.5f, 0.0f, 1.0f);
        }
    }
}

