/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids.drain;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.fluids.drain.ItemDrainBlockEntity;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ItemDrainRenderer
implements class_827<ItemDrainBlockEntity, ItemDrainRenderState> {
    protected final class_10442 itemModelManager;

    public ItemDrainRenderer(class_5614.class_5615 context) {
        this.itemModelManager = context.comp_4536();
    }

    public ItemDrainRenderState createRenderState() {
        return new ItemDrainRenderState();
    }

    public void extractRenderState(ItemDrainBlockEntity be, ItemDrainRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        ItemDrainRenderer.updateFluidRenderState(be, state, tickProgress);
        ItemDrainRenderer.updateItemRenderState(be, state, this.itemModelManager, tickProgress);
    }

    public void submit(ItemDrainRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.process != null) {
            queue.method_73483(matrices, state.process.layer, (class_11659.class_11660)state.process);
        }
        if (state.item != null) {
            state.item.render(matrices, queue, cameraState.field_63078, state.field_62676);
        }
        if (state.fluid != null) {
            matrices.method_46416(0.0f, state.fluid.offset, 0.0f);
            queue.method_73483(matrices, state.fluid.layer, (class_11659.class_11660)state.fluid);
        }
    }

    public static void updateFluidRenderState(ItemDrainBlockEntity be, ItemDrainRenderState state, float tickProgress) {
        class_1799 heldItemStack;
        float level;
        SmartFluidTankBehaviour tank = be.internalTank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        if (!fluidStack.isEmpty() && (level = primaryTank.getFluidLevel().getValue(tickProgress)) != 0.0f) {
            float yMax = 0.3125f;
            float min = 0.125f;
            float max = min + 0.75f;
            float yOffset = 0.4375f * level;
            float yMin = yMax - yOffset;
            state.fluid = new FluidRenderState(class_12249.method_75977(), fluidStack.getFluid(), fluidStack.getComponentChanges(), min, max, yMin, yMax, yOffset, state.field_62676);
        }
        if ((heldItemStack = be.getHeldItemStack()).method_7960()) {
            return;
        }
        int processingTicks = be.processingTicks;
        if (processingTicks == -1) {
            return;
        }
        FluidStack fluidStack2 = GenericItemEmptying.emptyItem(be.method_10997(), heldItemStack, true).getFirst();
        if (fluidStack2.isEmpty()) {
            if (fluidStack.isEmpty()) {
                return;
            }
            fluidStack2 = fluidStack;
        }
        float processingPT = (float)processingTicks - tickProgress;
        float processingProgress = 1.0f - (processingPT - 5.0f) / 10.0f;
        processingProgress = class_3532.method_15363((float)processingProgress, (float)0.0f, (float)1.0f);
        float radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
        class_238 box = new class_238(0.5, 1.0, 0.5, 0.5, 0.25, 0.5).method_1014((double)(radius / 32.0f));
        state.process = new ProcessRenderState(class_12249.method_75977(), fluidStack2.getFluid(), fluidStack2.getComponentChanges(), box, state.field_62676);
    }

    public static void updateItemRenderState(ItemDrainBlockEntity be, ItemDrainRenderState state, class_10442 itemModelManager, float tickProgress) {
        boolean alongX;
        TransportedItemStack transported = be.heldItem;
        if (transported == null) {
            return;
        }
        class_2350 insertedFrom = transported.insertedFrom;
        if (!insertedFrom.method_10166().method_10179()) {
            return;
        }
        HeldItemRenderState item = state.item = new HeldItemRenderState();
        item.itemPosition = VecHelper.getCenterOf((class_2382)state.field_62673);
        float offset = class_3532.method_16439((float)tickProgress, (float)transported.prevBeltPosition, (float)transported.beltPosition);
        float sideOffset = class_3532.method_16439((float)tickProgress, (float)transported.prevSideOffset, (float)transported.sideOffset);
        item.offsetVec = class_243.method_24954((class_2382)insertedFrom.method_10153().method_62675()).method_1021((double)(0.5f - offset));
        boolean bl = alongX = insertedFrom.method_10170().method_10166() == class_2350.class_2351.field_11048;
        if (!alongX) {
            sideOffset *= -1.0f;
        }
        item.translate = item.offsetVec.method_1031(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)sideOffset);
        class_1799 itemStack = transported.stack;
        item.count = class_3532.method_15351((int)itemStack.method_7947()) / 2;
        item.upright = BeltHelper.isItemUpright(itemStack);
        int positive = insertedFrom.method_10171().method_10181();
        item.axis = insertedFrom.method_10166();
        item.verticalAngle = (float)positive * offset * 360.0f;
        class_10444 renderState = state.item.state = new class_10444();
        renderState.field_55337 = class_811.field_4319;
        itemModelManager.method_65596(renderState, itemStack, renderState.field_55337, be.method_10997(), null, 0);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ItemDrainRenderState
    extends class_11954 {
        public FluidRenderState fluid;
        public ProcessRenderState process;
        public HeldItemRenderState item;
    }

    @Environment(value=EnvType.CLIENT)
    public record ProcessRenderState(class_1921 layer, class_3611 fluid, class_9326 changes, class_238 box, int light) implements class_11659.class_11660
    {
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(this.fluid, this.changes, (float)this.box.field_1323, (float)this.box.field_1322, (float)this.box.field_1321, (float)this.box.field_1320, (float)this.box.field_1325, (float)this.box.field_1324, vertexConsumer, matricesEntry, this.light, true, false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class HeldItemRenderState {
        public class_10444 state;
        public class_243 itemPosition;
        public class_243 translate;
        public class_243 offsetVec;
        public int count;
        public boolean upright;
        public class_2350.class_2351 axis;
        public float verticalAngle;

        public void render(class_4587 matrices, class_11659 queue, class_243 positionVec, int light) {
            PoseTransformStack msr = TransformStack.of(matrices);
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.9375f, 0.5f);
            msr.nudge(0);
            matrices.method_61958(this.translate);
            boolean renderUpright = this.upright;
            if (renderUpright) {
                matrices.method_22904(0.0, 0.09375, 0.0);
            }
            if (this.axis != class_2350.class_2351.field_11048) {
                msr.rotateXDegrees(this.verticalAngle);
            }
            if (this.axis != class_2350.class_2351.field_11051) {
                msr.rotateZDegrees(-this.verticalAngle);
            }
            if (renderUpright) {
                class_243 vectorForOffset = this.itemPosition.method_1019(this.offsetVec);
                class_243 diff = vectorForOffset.method_1020(positionVec);
                if (this.axis != class_2350.class_2351.field_11048) {
                    diff = VecHelper.rotate(diff, this.verticalAngle, class_2350.class_2351.field_11048);
                }
                if (this.axis != class_2350.class_2351.field_11051) {
                    diff = VecHelper.rotate(diff, -this.verticalAngle, class_2350.class_2351.field_11051);
                }
                float yRot = (float)class_3532.method_15349((double)diff.field_1350, (double)(-diff.field_1352));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)((double)yRot - 1.5707963267948966)));
                matrices.method_46416(0.0f, 0.0f, -0.0625f);
            }
            Random r = new Random(0L);
            boolean blockItem = this.state.method_65608();
            for (int i = 0; i < this.count; ++i) {
                matrices.method_22903();
                if (blockItem) {
                    matrices.method_46416(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
                }
                matrices.method_22905(0.5f, 0.5f, 0.5f);
                if (!blockItem && !renderUpright) {
                    msr.rotateXDegrees(90.0f);
                }
                this.state.method_65604(matrices, queue, light, class_4608.field_21444, 0);
                matrices.method_22909();
                if (!renderUpright) {
                    if (!blockItem) {
                        msr.rotateYDegrees(10.0f);
                    }
                    matrices.method_22904(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                    continue;
                }
                matrices.method_46416(0.0f, 0.0f, -0.0625f);
            }
            matrices.method_22903();
            if (blockItem) {
                matrices.method_46416(r.nextFloat() * 0.0625f * (float)this.count, 0.0f, r.nextFloat() * 0.0625f * (float)this.count);
            }
            matrices.method_22905(0.5f, 0.5f, 0.5f);
            if (!blockItem && !renderUpright) {
                msr.rotateXDegrees(90.0f);
            }
            this.state.method_65604(matrices, queue, light, class_4608.field_21444, 0);
            matrices.method_22909();
            matrices.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record FluidRenderState(class_1921 layer, class_3611 fluid, class_9326 changes, float min, float max, float yMin, float yMax, float offset, int light) implements class_11659.class_11660
    {
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(this.fluid, this.changes, this.min, this.yMin, this.min, this.max, this.yMax, this.max, vertexConsumer, matricesEntry, this.light, false, false);
        }
    }
}

