/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids.pipes;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.foundation.fluid.FluidRenderer;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.PipeConnection;
import com.zurrtum.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TransparentStraightPipeRenderer
implements class_827<StraightPipeBlockEntity, TransparentStraightPipeRenderState> {
    public TransparentStraightPipeRenderer(class_5614.class_5615 context) {
    }

    public TransparentStraightPipeRenderState createRenderState() {
        return new TransparentStraightPipeRenderState();
    }

    public void extractRenderState(StraightPipeBlockEntity be, TransparentStraightPipeRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        FluidTransportBehaviour pipe = be.getBehaviour(FluidTransportBehaviour.TYPE);
        if (pipe == null) {
            return;
        }
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        state.layer = class_12249.method_75977();
        class_2350[] directions = Iterate.directions;
        int size = directions.length;
        state.radius = 0.1875f;
        state.data = new FluidRenderData[size];
        class_1937 world = be.method_10997();
        for (int i = 0; i < size; ++i) {
            LerpedFloat progress;
            FluidStack fluidStack;
            class_2350 side = directions[i];
            PipeConnection.Flow flow = pipe.getFlow(side);
            if (flow == null || (fluidStack = flow.fluid).isEmpty() || (progress = flow.progress) == null) continue;
            float value = progress.getValue(tickProgress);
            boolean inbound = flow.inbound;
            if (value == 1.0f) {
                if (inbound) {
                    PipeConnection.Flow opposite = pipe.getFlow(side.method_10153());
                    if (opposite == null) {
                        value -= 1.0E-6f;
                    }
                } else {
                    FluidTransportBehaviour adjacent = BlockEntityBehaviour.get((class_1922)world, state.field_62673.method_10093(side), FluidTransportBehaviour.TYPE);
                    if (adjacent == null) {
                        value -= 1.0E-6f;
                    } else {
                        PipeConnection.Flow other = adjacent.getFlow(side.method_10153());
                        if (other == null || !other.inbound && !other.complete) {
                            value -= 1.0E-6f;
                        }
                    }
                }
            }
            state.data[i] = new FluidRenderData(fluidStack.getFluid(), fluidStack.getComponentChanges(), side, value, inbound);
        }
    }

    public void submit(TransparentStraightPipeRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.data != null) {
            queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TransparentStraightPipeRenderState
    extends class_11954
    implements class_11659.class_11660 {
        public class_1921 layer;
        public float radius;
        public FluidRenderData[] data;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (FluidRenderData renderData : this.data) {
                if (renderData == null) continue;
                FluidRenderer.renderFluidStream(renderData.fluid, renderData.changes, renderData.side, this.radius, renderData.value, renderData.inbound, vertexConsumer, matricesEntry, this.field_62676);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record FluidRenderData(class_3611 fluid, class_9326 changes, class_2350 side, float value, boolean inbound) {
    }
}

