/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids.tank;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FluidTankRenderer
implements class_827<FluidTankBlockEntity, FluidTankRenderState> {
    public FluidTankRenderer(class_5614.class_5615 context) {
    }

    public FluidTankRenderState createRenderState() {
        return new FluidTankRenderState();
    }

    public void extractRenderState(FluidTankBlockEntity be, FluidTankRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        if (!be.isController()) {
            return;
        }
        if (be.window) {
            this.updateFluidTankState(be, state, tickProgress, crumblingOverlay);
        } else if (be.boiler.isActive()) {
            this.updateBoilerState(be, state, tickProgress, crumblingOverlay);
        }
    }

    public void updateFluidTankState(FluidTankBlockEntity be, FluidTankRenderState state, float tickProgress, @Nullable class_11683.class_11792 crumblingOverlay) {
        float tankHullWidth;
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.getHeight() - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(tickProgress);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        FluidStack fluidStack = be.getTankInventory().getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        state.layer = class_12249.method_75977();
        FluidTankRenderData data = new FluidTankRenderData();
        state.data = data;
        float clampedLevel = class_3532.method_15363((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        data.translateY = clampedLevel - totalHeight;
        data.light = state.field_62676;
        data.fluid = fluidStack.getFluid();
        data.changes = fluidStack.getComponentChanges();
        boolean top = false;
        int width = be.getWidth();
        data.xMin = tankHullWidth = 0.0703125f;
        data.xMax = data.xMin + (float)width - 2.0f * tankHullWidth;
        data.yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        data.yMax = data.yMin + clampedLevel;
        if (top) {
            data.yMin += totalHeight - clampedLevel;
            data.yMax += totalHeight - clampedLevel;
        }
        data.zMin = tankHullWidth;
        data.zMax = data.zMin + (float)width - 2.0f * tankHullWidth;
    }

    public void updateBoilerState(FluidTankBlockEntity be, FluidTankRenderState state, float tickProgress, @Nullable class_11683.class_11792 crumblingOverlay) {
        boolean[] occludedDirections = be.boiler.occludedDirections;
        if (occludedDirections[0] && occludedDirections[1] && occludedDirections[2] && occludedDirections[3]) {
            return;
        }
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        state.layer = class_12249.method_75972();
        BoilerRenderData data = new BoilerRenderData();
        state.data = data;
        data.translateXZ = (float)be.getWidth() / 2.0f;
        data.light = state.field_62676;
        data.translateX = data.translateXZ - 0.375f;
        data.dialPivotY = 0.375f;
        data.dialPivotZ = 0.5f;
        data.progress = -145.0f * be.boiler.gauge.getValue(tickProgress) + 90.0f;
        data.gauge = CachedBuffers.partial(AllPartialModels.BOILER_GAUGE, state.field_62674);
        data.gaugeDial = CachedBuffers.partial(AllPartialModels.BOILER_GAUGE_DIAL, state.field_62674);
        data.south = !occludedDirections[0];
        data.west = !occludedDirections[1];
        data.north = !occludedDirections[2];
        data.east = !occludedDirections[3];
    }

    public void submit(FluidTankRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.data != null) {
            state.data.translate(matrices);
            queue.method_73483(matrices, state.layer, (class_11659.class_11660)state.data);
        }
    }

    public boolean method_3563() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class FluidTankRenderState
    extends class_11954 {
        public class_1921 layer;
        public RenderData data;
    }

    @Environment(value=EnvType.CLIENT)
    public static class FluidTankRenderData
    implements RenderData {
        public class_3611 fluid;
        public class_9326 changes;
        public float xMin;
        public float xMax;
        public float yMin;
        public float yMax;
        public float zMin;
        public float zMax;
        public float translateY;
        public int light;

        @Override
        public void translate(class_4587 matrices) {
            matrices.method_46416(0.0f, this.translateY, 0.0f);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(this.fluid, this.changes, this.xMin, this.yMin, this.zMin, this.xMax, this.yMax, this.zMax, vertexConsumer, matricesEntry, this.light, false, true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface RenderData
    extends class_11659.class_11660 {
        public void translate(class_4587 var1);
    }

    @Environment(value=EnvType.CLIENT)
    public static class BoilerRenderData
    implements RenderData {
        public float translateX;
        public float dialPivotY;
        public float dialPivotZ;
        public float progress;
        public float translateXZ;
        public SuperByteBuffer gauge;
        public SuperByteBuffer gaugeDial;
        public boolean south;
        public boolean west;
        public boolean north;
        public boolean east;
        public int light;

        @Override
        public void translate(class_4587 matrices) {
            matrices.method_22904((double)this.translateXZ, 0.5, (double)this.translateXZ);
        }

        public void render(int yRot, class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.gauge.rotateYDegrees(yRot)).uncenter()).translate(this.translateX, 0.0f, 0.0f)).light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.gaugeDial.rotateYDegrees(yRot)).uncenter()).translate(this.translateX, 0.0f, 0.0f)).translate(0.0f, this.dialPivotY, this.dialPivotZ)).rotateXDegrees(this.progress)).translate(0.0f, -this.dialPivotY, -this.dialPivotZ)).light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (this.south) {
                this.render(-90, matricesEntry, vertexConsumer);
            }
            if (this.west) {
                this.render(-180, matricesEntry, vertexConsumer);
            }
            if (this.north) {
                this.render(-270, matricesEntry, vertexConsumer);
            }
            if (this.east) {
                this.render(-360, matricesEntry, vertexConsumer);
            }
        }
    }
}

