/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.google.common.cache.Cache;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorInteractionHandler;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorPackagePhysicsData;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorShape;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBehaviour;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class ChainConveyorClientBehaviour
extends ChainConveyorBehaviour {
    private static final int ticksUntilExpired = 30;
    public static final WorldAttached<Cache<Integer, ChainConveyorPackagePhysicsData>> physicsDataCache = new WorldAttached<Cache>($ -> new TickBasedCache(30, true));

    public static ChainConveyorPackagePhysicsData physicsData(ChainConveyorPackage box, class_1936 level) {
        if (box.physicsData == null) {
            try {
                ChainConveyorPackagePhysicsData physicsData = (ChainConveyorPackagePhysicsData)physicsDataCache.get(level).get((Object)box.netId, ChainConveyorPackagePhysicsData::new);
                box.physicsData = physicsData;
                return physicsData;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        physicsDataCache.get(level).getIfPresent((Object)box.netId);
        return (ChainConveyorPackagePhysicsData)box.physicsData;
    }

    public ChainConveyorClientBehaviour(ChainConveyorBlockEntity be) {
        super(be);
    }

    @Override
    public void blockEntityTickBoxVisuals() {
        if (!VisualizationManager.supportsVisualization((class_1936)((ChainConveyorBlockEntity)this.blockEntity).method_10997())) {
            this.tickBoxVisuals();
        }
    }

    @Override
    public void tickBoxVisuals() {
        for (ChainConveyorPackage chainConveyorPackage : ((ChainConveyorBlockEntity)this.blockEntity).getLoopingPackages()) {
            this.tickBoxVisuals(chainConveyorPackage);
        }
        for (Map.Entry entry : ((ChainConveyorBlockEntity)this.blockEntity).getTravellingPackages().entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.tickBoxVisuals(box);
            }
        }
    }

    private void tickBoxVisuals(ChainConveyorPackage box) {
        if (box.worldPosition == null) {
            return;
        }
        ChainConveyorPackagePhysicsData physicsData = ChainConveyorClientBehaviour.physicsData(box, (class_1936)((ChainConveyorBlockEntity)this.blockEntity).method_10997());
        physicsData.setBE((ChainConveyorBlockEntity)this.blockEntity);
        if (!physicsData.shouldTick() && !((ChainConveyorBlockEntity)this.blockEntity).isVirtual()) {
            return;
        }
        physicsData.prevTargetPos = physicsData.targetPos;
        physicsData.prevPos = physicsData.pos;
        physicsData.prevYaw = physicsData.yaw;
        physicsData.flipped = ((ChainConveyorBlockEntity)this.blockEntity).reversed;
        if (physicsData.pos != null) {
            if (physicsData.pos.method_1025(box.worldPosition) > 2.25) {
                physicsData.pos = box.worldPosition.method_1019(physicsData.pos.method_1020(box.worldPosition).method_1029().method_1021(1.5));
            }
            physicsData.motion = physicsData.motion.method_1031(0.0, -0.25, 0.0).method_1021(0.75).method_1019(box.worldPosition.method_1020(physicsData.pos).method_1021(0.25));
            physicsData.pos = physicsData.pos.method_1019(physicsData.motion);
        }
        physicsData.targetPos = box.worldPosition.method_1023(0.0, 0.5625, 0.0);
        if (physicsData.pos == null) {
            physicsData.pos = physicsData.targetPos;
            physicsData.prevPos = physicsData.targetPos;
            physicsData.prevTargetPos = physicsData.targetPos;
        }
        physicsData.yaw = AngleHelper.angleLerp(0.25, physicsData.yaw, box.yaw);
    }

    @Override
    public void updateChainShapes() {
        ArrayList<ChainConveyorShape> shapes = new ArrayList<ChainConveyorShape>();
        shapes.add(new ChainConveyorShape.ChainConveyorBB(class_243.method_24955((class_2382)class_2338.field_10980)));
        class_2338 pos = ((ChainConveyorBlockEntity)this.blockEntity).method_11016();
        for (class_2338 target : ((ChainConveyorBlockEntity)this.blockEntity).connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = ((ChainConveyorBlockEntity)this.blockEntity).connectionStats.get(target);
            if (stats == null) continue;
            class_243 localStart = stats.start().method_1020(class_243.method_24954((class_2382)pos));
            class_243 localEnd = stats.end().method_1020(class_243.method_24954((class_2382)pos));
            shapes.add(new ChainConveyorShape.ChainConveyorOBB(target, localStart, localEnd));
        }
        ChainConveyorInteractionHandler.loadedChains.get((class_1936)((ChainConveyorBlockEntity)this.blockEntity).method_10997()).put((Object)pos, shapes);
    }

    @Override
    public void invalidate() {
        ChainConveyorInteractionHandler.loadedChains.get((class_1936)((ChainConveyorBlockEntity)this.blockEntity).method_10997()).invalidate((Object)((ChainConveyorBlockEntity)this.blockEntity).method_11016());
    }
}

