/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.mixer;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.content.kinetics.base.SingleAxisRotatingVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.OrientedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2382;

@Environment(value=EnvType.CLIENT)
public class MixerVisual
extends SingleAxisRotatingVisual<MechanicalMixerBlockEntity>
implements SimpleDynamicVisual {
    private final RotatingInstance mixerHead;
    private final OrientedInstance mixerPole;
    private final MechanicalMixerBlockEntity mixer;

    public MixerVisual(VisualizationContext context, MechanicalMixerBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Models.partial(AllPartialModels.SHAFTLESS_COGWHEEL));
        this.mixer = blockEntity;
        this.mixerHead = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.MECHANICAL_MIXER_HEAD)).createInstance();
        this.mixerHead.setRotationAxis(class_2350.class_2351.field_11052);
        this.mixerPole = this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial(AllPartialModels.MECHANICAL_MIXER_POLE)).createInstance();
        this.animate(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    private void animate(float pt) {
        float renderedHeadOffset = this.mixer.getRenderedHeadOffset(pt);
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset, pt);
    }

    private void transformHead(float renderedHeadOffset, float pt) {
        float speed = this.mixer.getRenderedHeadRotationSpeed(pt);
        this.mixerHead.setPosition((class_2382)this.getVisualPosition()).nudge(0.0f, -renderedHeadOffset, 0.0f).setRotationalSpeed(speed * 2.0f * 6.0f).setChanged();
    }

    private void transformPole(float renderedHeadOffset) {
        this.mixerPole.position((class_2382)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.pos.method_10074(), this.mixerHead);
        this.relight(this.mixerPole);
    }

    @Override
    protected void _delete() {
        super._delete();
        this.mixerHead.delete();
        this.mixerPole.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(this.mixerHead);
        consumer.accept(this.mixerPole);
    }
}

