/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.steamEngine;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.steamEngine.SteamEngineRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class SteamEngineVisual
extends AbstractBlockEntityVisual<SteamEngineBlockEntity>
implements SimpleDynamicVisual {
    protected final TransformedInstance piston;
    protected final TransformedInstance linkage;
    protected final TransformedInstance connector;
    private Float lastAngle = Float.valueOf(Float.NaN);
    private class_2350.class_2351 lastAxis = null;

    public SteamEngineVisual(VisualizationContext context, SteamEngineBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        this.piston = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ENGINE_PISTON)).createInstance();
        this.linkage = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ENGINE_LINKAGE)).createInstance();
        this.connector = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ENGINE_CONNECTOR)).createInstance();
        this.animate();
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate();
    }

    private void animate() {
        Float angle = SteamEngineRenderer.getTargetAngle((SteamEngineBlockEntity)this.blockEntity);
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        PoweredShaftBlockEntity shaft = ((SteamEngineBlockEntity)this.blockEntity).getShaft();
        if (shaft != null) {
            axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        }
        if (Objects.equals(angle, this.lastAngle) && this.lastAxis == axis) {
            return;
        }
        this.lastAngle = angle;
        this.lastAxis = axis;
        if (angle == null) {
            this.piston.setVisible(false);
            this.linkage.setVisible(false);
            this.connector.setVisible(false);
            return;
        }
        this.piston.setVisible(true);
        this.linkage.setVisible(true);
        this.connector.setVisible(true);
        class_2350 facing = SteamEngineBlock.getFacing(this.blockState);
        class_2350.class_2351 facingAxis = facing.method_10166();
        boolean roll90 = facingAxis.method_10179() && axis == class_2350.class_2351.field_11052 || facingAxis.method_10178() && axis == class_2350.class_2351.field_11051;
        float piston = 0.375f * class_3532.method_15374((double)angle.floatValue()) - class_3532.method_15355((float)(class_3532.method_27285((float)0.875f) - class_3532.method_27285((float)0.375f) * class_3532.method_27285((float)class_3532.method_15362((double)angle.floatValue()))));
        float distance = class_3532.method_15355((float)class_3532.method_27285((float)(piston - 0.375f * class_3532.method_15374((double)angle.floatValue()))));
        float angle2 = (float)Math.acos(distance / 0.875f) * (class_3532.method_15362((double)angle.floatValue()) >= 0.0f ? 1.0f : -1.0f);
        this.transformed(this.piston, facing, roll90).translate(0.0f, piston + 1.25f, 0.0f).setChanged();
        ((TransformedInstance)((TransformedInstance)this.transformed(this.linkage, facing, roll90).center()).translate(0.0f, 1.0f, 0.0f).uncenter()).translate(0.0f, piston + 1.25f, 0.0f).translate(0.0f, 0.25f, 0.5f).rotateX(angle2).translate(0.0f, -0.25f, -0.5f).setChanged();
        ((TransformedInstance)((TransformedInstance)this.transformed(this.connector, facing, roll90).translate(0.0f, 2.0f, 0.0f).center()).rotateX(-(angle.floatValue() + 1.5707964f)).uncenter()).setChanged();
    }

    protected TransformedInstance transformed(TransformedInstance modelData, class_2350 facing, boolean roll90) {
        return (TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)modelData.setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotateYDegrees(AngleHelper.horizontalAngle(facing))).rotateXDegrees(AngleHelper.verticalAngle(facing) + 90.0f)).rotateYDegrees(roll90 ? -90.0f : 0.0f)).uncenter();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.piston, this.linkage, this.connector);
    }

    @Override
    protected void _delete() {
        this.piston.delete();
        this.linkage.delete();
        this.connector.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.piston);
        consumer.accept(this.linkage);
        consumer.accept(this.connector);
    }
}

