/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics;

import com.google.common.cache.Cache;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.client.content.trains.schedule.DestinationSuggestions;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_9323;

@Environment(value=EnvType.CLIENT)
public class AddressEditBoxHelper {
    private static final Cache<class_2338, WeakReference<ClipboardBlockEntity>> NEARBY_CLIPBOARDS = new TickBasedCache<class_2338, WeakReference<ClipboardBlockEntity>>(20, false);

    public static void advertiseClipboard(ClipboardBlockEntity blockEntity) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_2338 blockPos = blockEntity.method_11016();
        if (player.method_5707(class_243.method_24953((class_2382)blockPos)) > 1024.0) {
            return;
        }
        NEARBY_CLIPBOARDS.put((Object)blockPos, new WeakReference<ClipboardBlockEntity>(blockEntity));
    }

    public static DestinationSuggestions createSuggestions(class_437 screen, class_342 pInput, boolean anchorToBottom, String localAddress) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        ArrayList<IntAttached<String>> options = new ArrayList<IntAttached<String>>();
        HashSet<String> alreadyAdded = new HashSet<String>();
        DestinationSuggestions destinationSuggestions = new DestinationSuggestions(mc, screen, pInput, mc.field_1772, options, anchorToBottom, -72 + pInput.method_46427() + (anchorToBottom ? 0 : pInput.method_25364()));
        if (player == null) {
            return destinationSuggestions;
        }
        if (localAddress != null) {
            options.add(IntAttached.with(-1, localAddress));
            alreadyAdded.add(localAddress);
        }
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < 36; ++i) {
            AddressEditBoxHelper.appendAddresses(options, alreadyAdded, inventory.method_5438(i));
        }
        for (WeakReference wr : NEARBY_CLIPBOARDS.asMap().values()) {
            ClipboardBlockEntity cbe = (ClipboardBlockEntity)wr.get();
            if (cbe == null) continue;
            AddressEditBoxHelper.appendAddresses(options, alreadyAdded, cbe.method_58693());
        }
        return destinationSuggestions;
    }

    private static void appendAddresses(List<IntAttached<String>> options, Set<String> alreadyAdded, class_1799 item) {
        if (item == null || !item.method_31574((class_1792)AllItems.CLIPBOARD)) {
            return;
        }
        AddressEditBoxHelper.appendAddresses(options, alreadyAdded, item.method_57353());
    }

    private static void appendAddresses(List<IntAttached<String>> options, Set<String> alreadyAdded, class_9323 components) {
        List<List<ClipboardEntry>> pages = ClipboardEntry.readAll(components);
        pages.forEach(page -> page.forEach(entry -> {
            String string = entry.text.getString();
            if (entry.checked) {
                return;
            }
            if (!string.startsWith("#") || string.length() == 1) {
                return;
            }
            String address = string.substring(1);
            if (address.isBlank()) {
                return;
            }
            String trim = address.trim();
            if (!alreadyAdded.add(trim)) {
                return;
            }
            options.add(IntAttached.withZero(trim));
        }));
    }
}

