/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.nixieTube;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.content.redstone.nixieTube.DoubleFaceAttachedBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11767;
import net.minecraft.class_11768;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class NixieTubeRenderer
implements class_827<NixieTubeBlockEntity, NixieTubeRenderState> {
    protected final class_327 textRenderer;

    public NixieTubeRenderer(class_5614.class_5615 context) {
        this.textRenderer = context.comp_4540();
    }

    public NixieTubeRenderState createRenderState() {
        return new NixieTubeRenderState();
    }

    public void extractRenderState(NixieTubeBlockEntity be, NixieTubeRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        if (be.signalState != null) {
            NixieTubeRenderer.updateSignalRenderState(be, state, cameraPos);
        } else {
            NixieTubeRenderer.updateTextRenderState(this.textRenderer, be, state);
        }
    }

    public static void updateTextRenderState(class_327 textRenderer, NixieTubeBlockEntity be, NixieTubeRenderState state) {
        TextRenderState data = new TextRenderState();
        DoubleFaceAttachedBlock.DoubleAttachFace face = (DoubleFaceAttachedBlock.DoubleAttachFace)((Object)state.field_62674.method_11654((class_2769)NixieTubeBlock.FACE));
        class_2350 facing = (class_2350)state.field_62674.method_11654((class_2769)NixieTubeBlock.field_11177);
        data.yRot = (float)Math.PI / 180 * (AngleHelper.horizontalAngle(facing) - 90.0f + (float)(face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 180 : 0));
        data.zRot = (float)Math.PI / 180 * (float)(face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL ? -90 : (face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 90 : 0));
        if (face == DoubleFaceAttachedBlock.DoubleAttachFace.CEILING || facing == class_2350.field_11033) {
            data.zRot2 = (float)Math.PI;
        }
        data.layer = class_12249.method_75977();
        data.light = state.field_62676;
        data.tube = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE, state.field_62674);
        Couple<String> s = be.getDisplayedStrings();
        if (s != null) {
            class_1767 color = NixieTubeBlock.colorOf(state.field_62674);
            float flicker = be.method_10997().field_9229.method_43057();
            Couple<Integer> couple = DyeHelper.getDyeColors(color);
            int brightColor = (Integer)couple.getFirst() | 0xFF000000;
            int darkColor = (Integer)couple.getSecond() | 0xFF000000;
            int flickeringBrightColor = Color.mixColors(brightColor, darkColor, flicker / 4.0f);
            int y = face == DoubleFaceAttachedBlock.DoubleAttachFace.CEILING ? -5 : -3;
            data.left = NixieTubeRenderer.createTextDrawable(textRenderer, (String)s.getFirst(), y, flickeringBrightColor, darkColor);
            data.right = NixieTubeRenderer.createTextDrawable(textRenderer, (String)s.getSecond(), y, flickeringBrightColor, darkColor);
        }
        state.data = data;
    }

    @Nullable
    public static TextDrawableState createTextDrawable(class_327 textRenderer, String text, int y, int flickeringBrightColor, int darkColor) {
        int code = NixieTubeRenderer.visit(text);
        if (code == 32) {
            return null;
        }
        class_11768 glyph = textRenderer.method_72732(class_2583.field_24360.method_27708()).method_72736(code);
        class_11767.class_12238 bright = glyph.method_73399(0.0f, 0.0f, flickeringBrightColor, 0, class_2583.field_24360, 0.0f, 0.0f);
        if (bright == null) {
            return null;
        }
        class_11767.class_12238 dark = glyph.method_73399(0.0f, 0.0f, darkColor, 0, class_2583.field_24360, 0.0f, 0.0f);
        class_11767.class_12238 mix = glyph.method_73399(0.0f, 0.0f, Color.mixColors(darkColor, -16777216, 0.35f), 0, class_2583.field_24360, 0.0f, 0.0f);
        float x = ((float)textRenderer.method_1727(text) - 0.5f) / -2.0f;
        return new TextDrawableState(bright.method_73401(class_327.class_6415.field_33993), x, y, (class_11767)bright, (class_11767)dark, (class_11767)mix);
    }

    public static int visit(String text) {
        int length = text.length();
        if (length == 0) {
            return 32;
        }
        char c = text.charAt(0);
        if (Character.isHighSurrogate(c)) {
            if (length == 1) {
                return 65533;
            }
            char d = text.charAt(1);
            if (Character.isLowSurrogate(d)) {
                return Character.toCodePoint(c, d);
            }
            return 65533;
        }
        if (Character.isSurrogate(c)) {
            return 65533;
        }
        return c;
    }

    public static void updateSignalRenderState(NixieTubeBlockEntity be, NixieTubeRenderState state, class_243 cameraPos) {
        int zRot;
        SignalRenderState data = new SignalRenderState();
        state.data = data;
        DoubleFaceAttachedBlock.DoubleAttachFace face = (DoubleFaceAttachedBlock.DoubleAttachFace)((Object)state.field_62674.method_11654((class_2769)NixieTubeBlock.FACE));
        class_2350 facing = NixieTubeBlock.getFacing(state.field_62674);
        data.yRot = (float)Math.PI / 180 * (AngleHelper.horizontalAngle((class_2350)state.field_62674.method_11654((class_2769)NixieTubeBlock.field_11177)) - 90.0f + (float)(face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 180 : 0));
        int n = face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL ? -90 : (zRot = face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 90 : 0);
        if (facing == class_2350.field_11033) {
            zRot += 180;
        }
        data.zRot = (float)Math.PI / 180 * (float)zRot;
        data.light = state.field_62676;
        data.layer = class_12249.method_75965();
        data.panel = CachedBuffers.partial(AllPartialModels.SIGNAL_PANEL, state.field_62674);
        data.offset = facing == class_2350.field_11033 || state.field_62674.method_11654((class_2769)NixieTubeBlock.FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 0.25f : -0.25f;
        SignalDrawableState left = data.left = new SignalDrawableState();
        SignalBlockEntity.SignalState signalState = be.signalState;
        float renderTime = AnimationTickHolder.getRenderTime((class_1936)be.method_10997());
        boolean yellow = signalState.isYellowLight(renderTime);
        float longSide = yellow ? 1.0f : 4.0f;
        float longSideGlow = yellow ? 2.0f : 5.125f;
        boolean vert = facing.method_10166().method_10179();
        double distance = class_243.method_24953((class_2382)state.field_62673).method_1020(cameraPos).method_1027();
        left.light = state.field_62676;
        left.layer = CreateRenderTypes.translucent();
        if (signalState.isRedLight(renderTime)) {
            left.additive = true;
            if (distance < 9216.0) {
                left.cubeLayer = left.layer;
                left.cube = CachedBuffers.partial(AllPartialModels.SIGNAL_WHITE_CUBE, state.field_62674);
                left.glow = CachedBuffers.partial(AllPartialModels.SIGNAL_RED_GLOW, state.field_62674);
                if (vert) {
                    left.cubeX = 1.0f;
                    left.cubeY = longSide;
                    left.glowX = 2.0f;
                    left.glowY = longSideGlow;
                } else {
                    left.cubeX = longSide;
                    left.cubeY = 1.0f;
                    left.glowX = longSideGlow;
                    left.glowY = 2.0f;
                }
            }
            left.layer = CreateRenderTypes.additive2();
            left.layer2 = CreateRenderTypes.additive();
            left.signal = CachedBuffers.partial(AllPartialModels.SIGNAL_RED, state.field_62674);
        } else {
            left.signal = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE_SINGLE, state.field_62674);
        }
        SignalDrawableState right = data.right = new SignalDrawableState();
        right.light = state.field_62676;
        right.layer = CreateRenderTypes.translucent();
        if (yellow || signalState.isGreenLight(renderTime)) {
            right.additive = true;
            if (distance < 9216.0) {
                right.cubeLayer = right.layer;
                right.cube = CachedBuffers.partial(AllPartialModels.SIGNAL_WHITE_CUBE, state.field_62674);
                right.glow = CachedBuffers.partial(yellow ? AllPartialModels.SIGNAL_YELLOW_GLOW : AllPartialModels.SIGNAL_WHITE_GLOW, state.field_62674);
                if (vert) {
                    right.cubeX = longSide;
                    right.cubeY = 1.0f;
                    right.glowX = longSideGlow;
                    right.glowY = 2.0f;
                } else {
                    right.cubeX = 1.0f;
                    right.cubeY = longSide;
                    right.glowX = 2.0f;
                    right.glowY = longSideGlow;
                }
            }
            right.layer = CreateRenderTypes.additive2();
            right.layer2 = CreateRenderTypes.additive();
            right.signal = CachedBuffers.partial(yellow ? AllPartialModels.SIGNAL_YELLOW : AllPartialModels.SIGNAL_WHITE, state.field_62674);
        } else {
            right.signal = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE_SINGLE, state.field_62674);
        }
    }

    public void submit(NixieTubeRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        state.data.render(matrices, queue);
    }

    public static void drawInWorldString(class_327 fontRenderer, class_4587 ms, class_4597 buffer, String c, int color) {
        fontRenderer.method_27521(c, 0.0f, 0.0f, color, false, ms.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public int method_33893() {
        return 128;
    }

    @Environment(value=EnvType.CLIENT)
    public static class NixieTubeRenderState
    extends class_11954 {
        public NixieTubeRenderData data;
    }

    @Environment(value=EnvType.CLIENT)
    public static class TextRenderState
    implements NixieTubeRenderData,
    class_11659.class_11660 {
        public class_1921 layer;
        public float yRot;
        public float zRot;
        public float zRot2;
        public TextDrawableState left;
        public TextDrawableState right;
        public SuperByteBuffer tube;
        public int light;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.tube.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot));
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(this.zRot));
            if (this.zRot2 != 0.0f) {
                matrices.method_22903();
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(this.zRot2));
                queue.method_73529(1).method_73483(matrices, this.layer, (class_11659.class_11660)this);
                matrices.method_22909();
            } else {
                queue.method_73529(1).method_73483(matrices, this.layer, (class_11659.class_11660)this);
            }
            if (this.left != null) {
                matrices.method_22903();
                matrices.method_46416(-0.25f, 0.0f, 0.0f);
                matrices.method_22905(0.05f, -0.05f, 0.05f);
                queue.method_73483(matrices, this.left.layer, (class_11659.class_11660)this.left);
                matrices.method_22909();
            }
            if (this.right != null) {
                matrices.method_46416(0.25f, 0.0f, 0.0f);
                matrices.method_22905(0.05f, -0.05f, 0.05f);
                queue.method_73483(matrices, this.right.layer, (class_11659.class_11660)this.right);
            }
            matrices.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record TextDrawableState(class_1921 layer, float x, int y, class_11767 bright, class_11767 dark, class_11767 mix) implements class_11659.class_11660
    {
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            Matrix4f pose = matricesEntry.method_23761();
            pose.translate(this.x, (float)this.y, 0.0f);
            this.bright.method_73403(pose, vertexConsumer, 0xF000F0, false);
            pose.translate(0.5f, 0.5f, -0.0625f);
            this.dark.method_73403(pose, vertexConsumer, 0xF000F0, false);
            pose.scale(-1.0f, 1.0f, 1.0f);
            pose.translate(0.5f + this.x + this.x, -0.5f, 0.0625f);
            this.dark.method_73403(pose, vertexConsumer, 0xF000F0, false);
            pose.translate(-0.5f, 0.5f, -0.0625f);
            this.mix.method_73403(pose, vertexConsumer, 0xF000F0, false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface NixieTubeRenderData {
        public void render(class_4587 var1, class_11659 var2);
    }

    @Environment(value=EnvType.CLIENT)
    public static class SignalRenderState
    implements NixieTubeRenderData,
    class_11659.class_11660 {
        public float yRot;
        public float zRot;
        public int light;
        public class_1921 layer;
        public SuperByteBuffer panel;
        public float offset;
        public SignalDrawableState left;
        public SignalDrawableState right;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.panel.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot));
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(this.zRot));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            queue.method_73483(matrices, this.layer, (class_11659.class_11660)this);
            matrices.method_46416(0.5f, 0.46875f, 0.5f);
            matrices.method_22903();
            matrices.method_46416(this.offset, 0.0f, 0.0f);
            this.left.render(matrices, queue);
            matrices.method_22909();
            matrices.method_46416(-this.offset, 0.0f, 0.0f);
            this.right.render(matrices, queue);
            matrices.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SignalDrawableState {
        public class_1921 layer;
        public class_1921 layer2;
        public SuperByteBuffer signal;
        public int light;
        public class_1921 cubeLayer;
        public SuperByteBuffer cube;
        public float cubeX;
        public float cubeY;
        public SuperByteBuffer glow;
        public float glowX;
        public float glowY;
        public boolean additive;

        public void render(class_4587 matrices, class_11659 queue) {
            if (ShadersModHelper.isShaderPackInUse()) {
                if (this.additive) {
                    queue.method_73529(1).method_73483(matrices, this.layer, (e, v) -> this.renderAdditive(e, v, 153));
                    if (this.cube != null) {
                        queue.method_73529(1).method_73483(matrices, this.cubeLayer, this::renderCube);
                    }
                    queue.method_73529(2).method_73483(matrices, this.layer2, (e, v) -> this.renderAdditive(e, v, 102));
                } else {
                    queue.method_73529(1).method_73483(matrices, this.layer, this::renderNormal);
                }
            } else if (this.additive) {
                queue.method_73483(matrices, this.layer, (e, v) -> this.renderAdditive(e, v, 153));
                if (this.cube != null) {
                    queue.method_73483(matrices, this.cubeLayer, this::renderCube);
                }
                queue.method_73483(matrices, this.layer2, (e, v) -> this.renderAdditive(e, v, 102));
            } else {
                queue.method_73483(matrices, this.layer, this::renderNormal);
            }
        }

        public void renderCube(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)this.cube.light(0xF000F0).disableDiffuse().scale(this.cubeX, this.cubeY, 1.0f)).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderAdditive(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, int color) {
            if (this.glow != null) {
                ((SuperByteBuffer)this.glow.light(0xF000F0).disableDiffuse().scale(this.glowX, this.glowY, 2.0f)).color(color, color, color, color).renderInto(matricesEntry, vertexConsumer);
            }
            ((SuperByteBuffer)this.signal.light(0xF000F0).disableDiffuse().scale(1.0625f)).color(color, color, color, color).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderNormal(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.signal.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

