/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.Create;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.foundation.utility.CreatePaths;
import com.zurrtum.create.foundation.utility.FilesHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.SchematicUploadPacket;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ClientSchematicLoader {
    public static final int PACKET_DELAY = 10;
    private final List<class_2561> availableSchematics = new ArrayList<class_2561>();
    private final Map<String, InputStream> activeUploads = new HashMap<String, InputStream>();
    private int packetCycle;

    public ClientSchematicLoader() {
        this.refresh();
    }

    public void tick(class_310 mc) {
        if (this.activeUploads.isEmpty()) {
            return;
        }
        if (this.packetCycle-- > 0) {
            return;
        }
        this.packetCycle = 10;
        for (String schematic : new HashSet<String>(this.activeUploads.keySet())) {
            this.continueUpload(mc, schematic);
        }
    }

    public void startNewUpload(class_310 mc, String schematic) {
        Path path = CreatePaths.SCHEMATICS_DIR.resolve(schematic);
        if (!Files.exists(path, new LinkOption[0])) {
            Create.LOGGER.error("Missing Schematic file: {}", (Object)path);
            return;
        }
        try {
            long size = Files.size(path);
            if (!ClientSchematicLoader.validateSizeLimitation(mc, size)) {
                return;
            }
            class_746 player = mc.field_1724;
            if (!ClientSchematicLoader.isGZIPEncoded(path.toFile())) {
                if (player != null) {
                    player.method_7353((class_2561)CreateLang.translateDirect("schematics.wrongFormat", new Object[0]), false);
                }
                return;
            }
            InputStream in = Files.newInputStream(path, StandardOpenOption.READ);
            this.activeUploads.put(schematic, in);
            player.field_3944.method_52787((class_2596)SchematicUploadPacket.begin(schematic, size));
        }
        catch (IOException e) {
            Create.LOGGER.error("Encountered an error while starting schematic upload", (Throwable)e);
        }
    }

    public static boolean validateSizeLimitation(class_310 mc, long size) {
        if (mc.method_1496()) {
            return true;
        }
        long maxSize = ((Integer)AllConfigs.server().schematics.maxTotalSchematicSize.get()).intValue();
        if (size > maxSize * 1000L) {
            class_746 player = mc.field_1724;
            if (player != null) {
                player.method_7353((class_2561)CreateLang.translateDirect("schematics.uploadTooLarge", new Object[0]).method_27693(" (" + size / 1000L + " KB)."), false);
                player.method_7353((class_2561)CreateLang.translateDirect("schematics.maxAllowedSize", new Object[0]).method_27693(" " + maxSize + " KB"), false);
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGZIPEncoded(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = new byte[2];
            if (fis.read(bytes) != 2) {
                boolean bl = false;
                return bl;
            }
            int byte1 = bytes[0] & 0xFF;
            int byte2 = bytes[1] & 0xFF;
            boolean bl = byte1 == 31 && byte2 == 139;
            return bl;
        }
        catch (IOException exception) {
            return false;
        }
    }

    private void continueUpload(class_310 mc, String schematic) {
        if (this.activeUploads.containsKey(schematic)) {
            int maxPacketSize = (Integer)AllConfigs.server().schematics.maxSchematicPacketSize.get();
            byte[] data = new byte[maxPacketSize];
            try {
                int status = this.activeUploads.get(schematic).read(data);
                if (status != -1) {
                    if (status < maxPacketSize) {
                        data = Arrays.copyOf(data, status);
                    }
                    if (mc.field_1687 != null) {
                        mc.field_1724.field_3944.method_52787((class_2596)SchematicUploadPacket.write(schematic, data));
                    } else {
                        this.activeUploads.remove(schematic);
                        return;
                    }
                }
                if (status < maxPacketSize) {
                    this.finishUpload(mc, schematic);
                }
            }
            catch (IOException e) {
                Create.LOGGER.error("Encountered a error while uploading schematic", (Throwable)e);
            }
        }
    }

    private void finishUpload(class_310 mc, String schematic) {
        if (this.activeUploads.containsKey(schematic)) {
            mc.field_1724.field_3944.method_52787((class_2596)SchematicUploadPacket.finish(schematic));
            this.activeUploads.remove(schematic);
        }
    }

    public void refresh() {
        FilesHelper.createFolderIfMissing(CreatePaths.SCHEMATICS_DIR);
        this.availableSchematics.clear();
        try (Stream<Path> paths2 = Files.list(CreatePaths.SCHEMATICS_DIR);){
            paths2.filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".nbt")).forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                this.availableSchematics.add((class_2561)class_2561.method_43470((String)path.getFileName().toString()));
            });
        }
        catch (NoSuchFileException paths2) {
        }
        catch (IOException e) {
            Create.LOGGER.error("Failed to refresh schematics", (Throwable)e);
        }
        this.availableSchematics.sort((aT, bT) -> {
            String a = aT.getString();
            String b = bT.getString();
            if (a.endsWith(".nbt")) {
                a = a.substring(0, a.length() - 4);
            }
            if (b.endsWith(".nbt")) {
                b = b.substring(0, b.length() - 4);
            }
            int aLength = a.length();
            int bLength = b.length();
            int minSize = Math.min(aLength, bLength);
            boolean asNumeric = false;
            int lastNumericCompare = 0;
            for (int i = 0; i < minSize; ++i) {
                boolean bNumber;
                char aChar = a.charAt(i);
                char bChar = b.charAt(i);
                boolean aNumber = aChar >= '0' && aChar <= '9';
                boolean bl = bNumber = bChar >= '0' && bChar <= '9';
                if (asNumeric) {
                    if (aNumber && bNumber) {
                        if (lastNumericCompare != 0) continue;
                        lastNumericCompare = aChar - bChar;
                        continue;
                    }
                    if (aNumber) {
                        return 1;
                    }
                    if (bNumber) {
                        return -1;
                    }
                    if (lastNumericCompare == 0) {
                        if (aChar != bChar) {
                            return aChar - bChar;
                        }
                        asNumeric = false;
                        continue;
                    }
                    return lastNumericCompare;
                }
                if (aNumber && bNumber) {
                    asNumeric = true;
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aChar == bChar) continue;
                return aChar - bChar;
            }
            if (asNumeric) {
                if (aLength > bLength && a.charAt(bLength) >= '0' && a.charAt(bLength) <= '9') {
                    return 1;
                }
                if (bLength > aLength && b.charAt(aLength) >= '0' && b.charAt(aLength) <= '9') {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    return aLength - bLength;
                }
                return lastNumericCompare;
            }
            return aLength - bLength;
        });
    }

    public List<class_2561> getAvailableSchematics() {
        return this.availableSchematics;
    }
}

