/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.bogey;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.content.trains.bogey.BogeyBlockEntityRenderer;
import com.zurrtum.create.client.content.trains.bogey.BogeyRenderer;
import com.zurrtum.create.client.content.trains.bogey.LargeBogeyRenderState;
import com.zurrtum.create.client.content.trains.bogey.SmallBogeyRenderState;
import com.zurrtum.create.client.content.trains.bogey.StandardBogeyRenderState;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_12249;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class StandardBogeyRenderer
implements BogeyRenderer {
    public static void updateRenderState(StandardBogeyRenderState data, float wheelAngle, int light) {
        data.layer = class_12249.method_75972();
        data.shaft = CachedBuffers.block((class_2680)AllBlocks.SHAFT.method_9564().method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11051));
        data.angle = (float)Math.PI / 180 * wheelAngle;
        data.light = light;
        data.offset = -1.5078125;
    }

    @Override
    public BogeyBlockEntityRenderer.BogeyRenderState getRenderData(@Nullable class_2487 bogeyData, float wheelAngle, float tickProgress, int light, boolean inContraption) {
        StandardBogeyRenderState data = new StandardBogeyRenderState();
        StandardBogeyRenderer.updateRenderState(data, wheelAngle, light);
        return data;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Large
    extends StandardBogeyRenderer {
        public static final float BELT_RADIUS_PX = 5.0f;
        public static final float BELT_RADIUS_IN_UV_SPACE = 0.3125f;

        @Override
        public BogeyBlockEntityRenderer.BogeyRenderState getRenderData(@Nullable class_2487 bogeyData, float wheelAngle, float tickProgress, int light, boolean inContraption) {
            LargeBogeyRenderState data = new LargeBogeyRenderState();
            Large.updateRenderState(data, wheelAngle, light);
            data.secondaryShaft = CachedBuffers.block((class_2680)AllBlocks.SHAFT.method_9564().method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11048));
            class_2680 air = class_2246.field_10124.method_9564();
            data.drive = CachedBuffers.partial(AllPartialModels.BOGEY_DRIVE, air);
            data.belt = CachedBuffers.partial(AllPartialModels.BOGEY_DRIVE_BELT, air);
            float spriteSize = AllSpriteShifts.BOGEY_BELT.getTarget().method_4575() - AllSpriteShifts.BOGEY_BELT.getTarget().method_4593();
            float scroll = 0.0054541538f * wheelAngle;
            scroll -= (float)class_3532.method_15375((float)scroll);
            data.scroll = scroll * spriteSize * 0.5f;
            data.piston = CachedBuffers.partial(AllPartialModels.BOGEY_PISTON, air);
            data.pistonOffset = (float)(0.25 * Math.sin(AngleHelper.rad(wheelAngle)));
            data.wheels = CachedBuffers.partial(AllPartialModels.LARGE_BOGEY_WHEELS, air);
            data.pin = CachedBuffers.partial(AllPartialModels.BOGEY_PIN, air);
            return data;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Small
    extends StandardBogeyRenderer {
        @Override
        public BogeyBlockEntityRenderer.BogeyRenderState getRenderData(@Nullable class_2487 bogeyData, float wheelAngle, float tickProgress, int light, boolean inContraption) {
            SmallBogeyRenderState data = new SmallBogeyRenderState();
            Small.updateRenderState(data, wheelAngle, light);
            class_2680 air = class_2246.field_10124.method_9564();
            data.frame = CachedBuffers.partial(AllPartialModels.BOGEY_FRAME, air);
            data.wheels = CachedBuffers.partial(AllPartialModels.SMALL_BOGEY_WHEELS, air);
            return data;
        }
    }
}

