/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderState;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class StationRenderer
implements class_827<StationBlockEntity, StationRenderState> {
    protected final class_10442 itemModelManager;

    public StationRenderer(class_5614.class_5615 context) {
        this.itemModelManager = context.comp_4536();
    }

    public StationRenderState createRenderState() {
        return new StationRenderState();
    }

    public void extractRenderState(StationBlockEntity be, StationRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        TrackBlockRenderer renderer;
        state.field_62673 = be.method_11016();
        state.field_62675 = be.method_11017();
        class_1937 world = be.method_10997();
        state.field_62676 = world != null ? class_761.method_23794((class_1920)world, (class_2338)state.field_62673) : 0xF000F0;
        DepotBehaviour depotBehaviour = be.depotBehaviour;
        state.incoming = DepotRenderer.createIncomingStateList(depotBehaviour, this.itemModelManager, tickProgress, world);
        state.outputs = DepotRenderer.createOutputStateList(depotBehaviour, this.itemModelManager, world);
        TrackTargetingBehaviour<GlobalStation> target = be.edgePoint;
        class_2338 targetPosition = target.getGlobalPosition();
        class_2680 trackState = world.method_8320(targetPosition);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ITrackBlock track = (ITrackBlock)block;
        GlobalStation station = be.getStation();
        boolean isAssembling = (Boolean)be.method_11010().method_11654((class_2769)StationBlock.ASSEMBLING);
        if (!isAssembling || (station == null || station.getPresentTrain() != null) && !be.isVirtual()) {
            this.updateFlagState(be.flag.getValue(tickProgress) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF, be, state, tickProgress);
            TrackBlockRenderer renderer2 = AllTrackRenders.get(track);
            if (renderer2 != null) {
                state.block = renderer2.getRenderState(world, new class_243((double)(targetPosition.method_10263() - state.field_62673.method_10263()), (double)(targetPosition.method_10264() - state.field_62673.method_10264()), (double)(targetPosition.method_10260() - state.field_62673.method_10260())), trackState, targetPosition, target.getTargetDirection(), target.getTargetBezier(), TrackTargetingBehaviour.RenderedTrackOverlayType.STATION, 1.0f);
            }
            return;
        }
        this.updateFlagState(AllPartialModels.STATION_ASSEMBLE, be, state, tickProgress);
        if (be.isVirtual() && be.bogeyLocations == null) {
            be.refreshAssemblyInfo();
        }
        if ((renderer = AllTrackRenders.get(track)) == null) {
            return;
        }
        state.block = renderer.getAssemblyRenderState(be, new class_243((double)(targetPosition.method_10263() - state.field_62673.method_10263()), (double)(targetPosition.method_10264() - state.field_62673.method_10264()), (double)(targetPosition.method_10260() - state.field_62673.method_10260())), world, targetPosition, trackState);
    }

    public void updateFlagState(PartialModel flag, StationBlockEntity be, StationRenderState state, float tickProgress) {
        if (be.resolveFlagAngle()) {
            state.layer = class_12249.method_75972();
            state.flag = CachedBuffers.partial(flag, be.method_11010());
            float value = be.flag.getValue(tickProgress);
            float progress = (float)Math.pow(Math.min(value * 5.0f, 1.0f), 2.0);
            if (be.flag.getChaseTarget() > 0.0f && !be.flag.settled() && progress == 1.0f) {
                float wiggleProgress = (value - 0.2f) / 0.8f;
                progress += (float)(Math.sin(wiggleProgress * ((float)Math.PI * 2) * 4.0f) / 8.0 / (double)Math.max(1.0f, 8.0f * wiggleProgress));
            }
            float nudge = 0.001953125f;
            state.flagYRot = (float)Math.PI / 180 * (float)be.flagYRot;
            boolean flipped = be.flagFlipped;
            state.flagOffsetZ = flipped ? 0.875f - nudge : 0.125f + nudge;
            state.flagXRot = (float)Math.PI / 180 * (float)(flipped ? 1 : -1) * (progress * 90.0f + 270.0f);
            state.flagYRot2 = flipped ? 0.0f : (float)Math.PI;
        }
    }

    public void submit(StationRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.incoming != null || state.outputs != null) {
            DepotRenderer.renderItemsOf(state.incoming, state.outputs, state.field_62673, cameraState.field_63078, queue, matrices, state.field_62676);
        }
        if (state.layer != null) {
            queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
        }
        if (state.block != null) {
            state.block.render(matrices, queue);
        }
    }

    public boolean method_3563() {
        return true;
    }

    public int method_33893() {
        return 192;
    }

    @Environment(value=EnvType.CLIENT)
    public static class StationRenderState
    extends class_11954
    implements class_11659.class_11660 {
        public DepotRenderer.DepotItemState[] incoming;
        public List<DepotRenderer.DepotOutputItemState> outputs;
        public class_1921 layer;
        public SuperByteBuffer flag;
        public float flagYRot;
        public float flagOffsetZ;
        public float flagXRot;
        public float flagYRot2;
        public TrackBlockRenderState block;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (this.flag != null) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.flag.center()).rotateY(this.flagYRot)).translate(0.001953125f, 0.59375f, this.flagOffsetZ)).uncenter();
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.flag.rotateX(this.flagXRot)).translate(0.03125f, 0.0f, 0.0f)).rotateY(this.flagYRot2)).translate(-0.03125f, 0.0f, 0.0f);
                this.flag.light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

