/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.glsl;

import com.zurrtum.create.client.flywheel.backend.compile.FlwPrograms;
import com.zurrtum.create.client.flywheel.backend.glsl.LoadError;
import com.zurrtum.create.client.flywheel.backend.glsl.LoadResult;
import com.zurrtum.create.client.flywheel.backend.glsl.SourceFile;
import com.zurrtum.create.client.flywheel.lib.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.VisibleForTesting;

@Environment(value=EnvType.CLIENT)
public class ShaderSources {
    public static final String SHADER_DIR = "flywheel/";
    @VisibleForTesting
    protected final Map<class_2960, LoadResult> cache;

    public ShaderSources(class_3300 manager) {
        SourceFinder sourceFinder = new SourceFinder(manager);
        long loadStart = System.nanoTime();
        manager.method_14488("flywheel", ShaderSources::isShader).forEach(sourceFinder::rootLoad);
        long loadEnd = System.nanoTime();
        FlwPrograms.LOGGER.info("Loaded {} shader sources in {}", (Object)sourceFinder.results.size(), (Object)StringUtil.formatTime(loadEnd - loadStart));
        this.cache = sourceFinder.results;
    }

    private static class_2960 locationWithoutFlywheelPrefix(class_2960 loc) {
        return class_2960.method_60655((String)loc.method_12836(), (String)loc.method_12832().substring(SHADER_DIR.length()));
    }

    public LoadResult find(class_2960 location) {
        return this.cache.computeIfAbsent(location, loc -> new LoadResult.Failure(new LoadError.ResourceError((class_2960)loc)));
    }

    public SourceFile get(class_2960 location) {
        return this.find(location).unwrap();
    }

    private static boolean isShader(class_2960 loc) {
        String path = loc.method_12832();
        return path.endsWith(".glsl") || path.endsWith(".vert") || path.endsWith(".frag") || path.endsWith(".comp");
    }

    @Environment(value=EnvType.CLIENT)
    private static class SourceFinder {
        private final Deque<class_2960> findStack = new ArrayDeque<class_2960>();
        private final Map<class_2960, LoadResult> results = new HashMap<class_2960, LoadResult>();
        private final class_3300 manager;

        public SourceFinder(class_3300 manager) {
            this.manager = manager;
        }

        public void rootLoad(class_2960 loc, class_3298 resource) {
            class_2960 strippedLoc = ShaderSources.locationWithoutFlywheelPrefix(loc);
            if (this.results.containsKey(strippedLoc)) {
                return;
            }
            this.results.put(strippedLoc, this.readResource(strippedLoc, resource));
        }

        public LoadResult recursiveLoad(class_2960 location) {
            if (this.findStack.contains(location)) {
                this.findStack.addLast(location);
                List<class_2960> copy = List.copyOf(this.findStack);
                this.findStack.removeLast();
                return new LoadResult.Failure(new LoadError.CircularDependency(location, copy));
            }
            this.findStack.addLast(location);
            LoadResult out = this._find(location);
            this.findStack.removeLast();
            return out;
        }

        private LoadResult _find(class_2960 location) {
            LoadResult out = this.results.get(location);
            if (out == null) {
                out = this.load(location);
                this.results.put(location, out);
            }
            return out;
        }

        private LoadResult load(class_2960 loc) {
            return this.manager.method_14486(loc.method_45138(ShaderSources.SHADER_DIR)).map(resource -> this.readResource(loc, (class_3298)resource)).orElseGet(() -> new LoadResult.Failure(new LoadError.ResourceError(loc)));
        }

        private LoadResult readResource(class_2960 loc, class_3298 resource) {
            LoadResult loadResult;
            block8: {
                InputStream stream = resource.method_14482();
                try {
                    String sourceString = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    loadResult = SourceFile.parse(this::recursiveLoad, loc, sourceString);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return new LoadResult.Failure(new LoadError.IOError(loc, e));
                    }
                }
                stream.close();
            }
            return loadResult;
        }
    }
}

