/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBufferer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11515;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.UnknownNullability;

@Environment(value=EnvType.CLIENT)
class MeshEmitter
implements class_4588 {
    private final class_11515 renderType;
    private final class_9799 byteBufferBuilder;
    private @UnknownNullability class_287 bufferBuilder;
    private BakedModelBufferer.ResultConsumer resultConsumer;
    private boolean currentShade;

    MeshEmitter(class_11515 renderType) {
        this.renderType = renderType;
        this.byteBufferBuilder = new class_9799(renderType.method_72021());
    }

    public void prepare(BakedModelBufferer.ResultConsumer resultConsumer) {
        this.resultConsumer = resultConsumer;
    }

    public void end() {
        if (this.bufferBuilder != null) {
            this.emit();
        }
        this.resultConsumer = null;
    }

    public class_287 unwrap(boolean shade) {
        this.prepareForGeometry(shade);
        return this.bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (this.bufferBuilder == null) {
            this.bufferBuilder = new class_287(this.byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1590);
        } else if (shade != this.currentShade) {
            this.emit();
            this.bufferBuilder = new class_287(this.byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1590);
        }
        this.currentShade = shade;
    }

    private void prepareForGeometry(class_777 quad) {
        this.prepareForGeometry(quad.comp_3725());
    }

    private void emit() {
        class_9801 data = this.bufferBuilder.method_60794();
        this.bufferBuilder = null;
        if (data != null) {
            this.resultConsumer.accept(this.renderType, this.currentShade, data);
            data.close();
        }
    }

    public void method_22919(class_4587.class_4665 pose, class_777 quad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.method_22919(pose, quad, red, green, blue, alpha, packedLight, packedOverlay);
    }

    public void method_22920(class_4587.class_4665 pose, class_777 quad, float[] brightnesses, float red, float green, float blue, float alpha, int[] lights, int overlay) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.method_22920(pose, quad, brightnesses, red, green, blue, alpha, lights, overlay);
    }

    public class_4588 method_22912(float x, float y, float z) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public class_4588 method_39415(int color) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public class_4588 method_22913(float u, float v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public class_4588 method_60796(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public class_4588 method_22921(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public class_4588 method_22914(float normalX, float normalY, float normalZ) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public class_4588 method_75298(float width) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }
}

