/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.logistics.depot.EjectorSlot;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerBulkScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ScrollValueBehaviour<B extends SmartBlockEntity, T extends ServerScrollValueBehaviour>
extends BlockEntityBehaviour<B>
implements ValueSettingsBehaviour {
    public static final BehaviourType<ScrollValueBehaviour<?, ?>> TYPE = new BehaviourType();
    protected T behaviour;
    ValueBoxTransform slotPositioning;
    public class_2561 label;
    protected boolean needsWrench;
    protected Function<Integer, String> formatter = i -> Integer.toString(i);
    protected Supplier<Boolean> isActive = () -> true;

    public ScrollValueBehaviour(class_2561 label, B be, ValueBoxTransform slotPositioning) {
        super(be);
        this.label = label;
        this.slotPositioning = slotPositioning;
        this.behaviour = this.blockEntity.getBehaviour(ServerScrollValueBehaviour.TYPE);
    }

    @Nullable
    public List<? extends SmartBlockEntity> getBulk() {
        T t = this.behaviour;
        if (t instanceof ServerBulkScrollValueBehaviour) {
            ServerBulkScrollValueBehaviour bulkBehaviour = (ServerBulkScrollValueBehaviour)t;
            return bulkBehaviour.getBulk();
        }
        return null;
    }

    @Override
    public void initialize() {
        if (this.behaviour == null) {
            this.behaviour = this.blockEntity.getBehaviour(ServerScrollValueBehaviour.TYPE);
        }
    }

    @Override
    public void tick() {
    }

    public static BlockEntityBehaviour<EjectorBlockEntity> ejector(EjectorBlockEntity blockEntity) {
        return new ScrollValueBehaviour((class_2561)CreateLang.translateDirect("weighted_ejector.stack_size", new Object[0]), blockEntity, new EjectorSlot(blockEntity)).withFormatter(i -> i == 0 ? "*" : String.valueOf(i));
    }

    public ScrollValueBehaviour<B, T> withFormatter(Function<Integer, String> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollValueBehaviour<B, T> onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public String formatValue() {
        return this.formatter.apply(((ServerScrollValueBehaviour)this.behaviour).getValue());
    }

    @Override
    public boolean isActive() {
        return this.isActive.get();
    }

    @Override
    public boolean testHit(class_243 hit) {
        class_2680 state = ((ServerScrollValueBehaviour)this.behaviour).blockEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)((ServerScrollValueBehaviour)this.behaviour).blockEntity.method_11016()));
        return this.slotPositioning.testHit((class_1936)((BlockEntityBehaviour)this.behaviour).getLevel(), ((BlockEntityBehaviour)this.behaviour).getPos(), state, localHit);
    }

    public void setLabel(class_2561 label) {
        this.label = label;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Override
    public ValueBoxTransform getSlotPositioning() {
        return this.slotPositioning;
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        return new ValueSettingsBoard(this.label, ((ServerScrollValueBehaviour)this.behaviour).getMax(), 10, (List<class_2561>)ImmutableList.of((Object)class_2561.method_43470((String)"Value")), new ValueSettingsFormatter());
    }

    @Override
    public ValueSettings getValueSettings() {
        return ((ServerScrollValueBehaviour)this.behaviour).getValueSettings();
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings valueSetting, boolean ctrlDown) {
        ((ServerScrollValueBehaviour)this.behaviour).setValueSettings(player, valueSetting, ctrlDown);
    }

    @Override
    public boolean mayInteract(class_1657 player) {
        return this.behaviour.mayInteract(player);
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        ((ServerScrollValueBehaviour)this.behaviour).onShortInteract(player, hand, side, hitResult);
    }

    @Override
    public int netId() {
        return this.behaviour.netId();
    }

    @Override
    public boolean onlyVisibleWithWrench() {
        return this.needsWrench;
    }

    @Environment(value=EnvType.CLIENT)
    public static class StepContext {
        public int currentValue;
        public boolean forward;
        public boolean shift;
        public boolean control;
    }
}

