/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.render;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class BlockEntityRenderHelper {
    @Nullable
    public static BlockEntityListRenderState getBlockEntitiesRenderState(boolean supportsVisualization, List<class_2586> blockEntities, BitSet shouldRenderBEs, BitSet erroredBEsOut, @Nullable VirtualRenderWorld renderLevel, class_1937 realLevel, class_4587 ms, @Nullable Matrix4f lightTransform, class_243 camera, float pt) {
        int size = blockEntities.size();
        if (size == 0) {
            return null;
        }
        class_310 mc = class_310.method_1551();
        class_824 dispatcher = mc.method_31975();
        ArrayList<class_11954> states = new ArrayList<class_11954>();
        int i = shouldRenderBEs.nextSetBit(0);
        while (i >= 0 && i < size) {
            class_2586 blockEntity = blockEntities.get(i);
            if (!supportsVisualization || !VisualizationHelper.skipVanillaRender(blockEntity)) {
                class_827 renderer = dispatcher.method_3550(blockEntity);
                if (renderer == null) {
                    erroredBEsOut.set(i);
                } else {
                    try {
                        class_11954 renderState = renderer.method_74335();
                        int realLevelLight = class_761.method_23794((class_1920)realLevel, (class_2338)BlockEntityRenderHelper.getLightPos(lightTransform, blockEntity.method_11016()));
                        if (renderLevel != null) {
                            renderLevel.setExternalLight(realLevelLight);
                        }
                        renderer.method_74331(blockEntity, renderState, pt, camera, null);
                        if (renderLevel == null) {
                            renderState.field_62676 = realLevelLight;
                        }
                        states.add(renderState);
                    }
                    catch (Exception e) {
                        erroredBEsOut.set(i);
                        String message = "BlockEntity " + String.valueOf(RegisteredObjectsHelper.getKeyOrThrow(blockEntity.method_11017())) + " could not be rendered virtually.";
                        if (((Boolean)AllConfigs.client().explainRenderErrors.get()).booleanValue()) {
                            Create.LOGGER.error(message, (Throwable)e);
                        }
                        Create.LOGGER.error(message);
                    }
                }
            }
            i = shouldRenderBEs.nextSetBit(i + 1);
        }
        if (renderLevel != null) {
            renderLevel.resetExternalLight();
        }
        if (states.isEmpty()) {
            return null;
        }
        return new BlockEntityListRenderState(dispatcher, ms, camera, class_2338.method_49638((class_2374)camera), states);
    }

    private static class_2338 getLightPos(@Nullable Matrix4f lightTransform, class_2338 contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f((float)contraptionPos.method_10263() + 0.5f, (float)contraptionPos.method_10264() + 0.5f, (float)contraptionPos.method_10260() + 0.5f, 1.0f);
            lightVec.mul((Matrix4fc)lightTransform);
            return class_2338.method_49637((double)lightVec.x(), (double)lightVec.y(), (double)lightVec.z());
        }
        return contraptionPos;
    }

    @Environment(value=EnvType.CLIENT)
    public record BlockEntityListRenderState(class_824 dispatcher, class_4587 matrices, class_243 camera, class_2338 cameraPos, List<class_11954> states) {
        public void render(class_11659 queue, class_12075 cameraRenderState) {
            class_243 prevPos = cameraRenderState.field_63078;
            class_2338 prevBlockPos = cameraRenderState.field_63077;
            class_243 prevEntityPos = cameraRenderState.field_63080;
            cameraRenderState.field_63078 = this.camera;
            cameraRenderState.field_63077 = this.cameraPos;
            cameraRenderState.field_63080 = new class_243(prevEntityPos.field_1352 - prevPos.field_1352 + this.camera.field_1352, prevEntityPos.field_1351 - prevPos.field_1351 + this.camera.field_1351, prevEntityPos.field_1350 - prevPos.field_1350 + this.camera.field_1350);
            for (class_11954 state : this.states) {
                class_827 renderer = this.dispatcher.method_74349(state);
                if (renderer == null) continue;
                class_2338 pos = state.field_62673;
                this.matrices.method_22903();
                this.matrices.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                renderer.method_3569(state, this.matrices, queue, cameraRenderState);
                this.matrices.method_22909();
            }
            cameraRenderState.field_63078 = prevPos;
            cameraRenderState.field_63077 = prevBlockPos;
            cameraRenderState.field_63080 = prevEntityPos;
        }
    }
}

