/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.infrastructure.component.SandPaperItemComponent;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_10526;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class SandPaperModel
implements class_10439,
class_10515<RenderData> {
    public static final class_2960 ID = class_2960.method_60655((String)"create", (String)"model/sand_paper");
    private final class_1921 layer = class_4722.method_29382();
    private final List<class_777> quads;
    private final class_10809 settings;
    private final Supplier<Vector3fc[]> vector;

    public SandPaperModel(List<class_777> quads, class_10809 settings) {
        this.quads = quads;
        this.settings = settings;
        this.vector = Suppliers.memoize(() -> class_10430.method_67990(this.quads));
    }

    public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 ctx, int seed) {
        class_1657 entity;
        state.method_70946((Object)this);
        state.method_70947();
        class_10444.class_10446 layerRenderState = state.method_65601();
        layerRenderState.method_67992(this.layer);
        layerRenderState.method_67995(this.vector);
        this.settings.method_68000(layerRenderState, displayContext);
        layerRenderState.method_67997().addAll(this.quads);
        RenderData data = new RenderData();
        data.state = layerRenderState;
        if (ctx instanceof class_1657) {
            class_1657 player = (class_1657)ctx;
            data.itemInUseCount = player.method_6014();
            entity = player;
        } else {
            class_746 player = class_310.method_1551().field_1724;
            data.itemInUseCount = player.method_6014();
            entity = player;
        }
        SandPaperItemComponent component = (SandPaperItemComponent)stack.method_58694(AllDataComponents.SAND_PAPER_POLISHING);
        if (component != null) {
            int maxUseTime = stack.method_7935((class_1309)entity);
            boolean jeiMode = stack.method_57826(AllDataComponents.SAND_PAPER_JEI);
            float partialTicks = AnimationTickHolder.getPartialTicks();
            float time = (float)(!jeiMode ? data.itemInUseCount : -AnimationTickHolder.getTicks() % maxUseTime) - partialTicks + 1.0f;
            boolean bl = data.reverseBobbing = time / (float)maxUseTime < 0.8f;
            if (data.reverseBobbing) {
                data.bobbing = -class_3532.method_15379((float)(class_3532.method_15362((double)(time / 4.0f * (float)Math.PI)) * 0.1f));
            }
            class_1799 toPolish = component.item();
            data.item = new class_10444();
            data.item.field_55337 = displayContext;
            resolver.method_65596(data.item, toPolish, class_811.field_4317, (class_1937)world, ctx, seed);
        }
        layerRenderState.method_65617((class_10515)this, (Object)data);
    }

    public void submit(RenderData data, class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, boolean glint, int i) {
        int modifier;
        assert (data != null);
        class_10444.class_10446 state = data.state;
        boolean leftHand = displayContext == class_811.field_4321;
        boolean firstPerson = leftHand || displayContext == class_811.field_4322;
        matrices.method_22903();
        if (firstPerson && data.itemInUseCount > 0) {
            modifier = leftHand ? -1 : 1;
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_46416((float)modifier * 0.5f, 0.0f, -0.25f);
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees((float)(modifier * 40)));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees((float)(modifier * 10)));
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)(modifier * 90)));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
        }
        queue.method_73480(matrices, displayContext, light, overlay, 0, state.field_55349, state.field_56964, state.field_55347, state.field_55348);
        matrices.method_22909();
        if (data.item == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        if (displayContext == class_811.field_4317) {
            matrices.method_46416(0.0f, 0.2f, 1.0f);
            matrices.method_22905(0.75f, 0.75f, 0.75f);
        } else {
            modifier = leftHand ? -1 : 1;
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)(modifier * 40)));
        }
        if (data.reverseBobbing) {
            if (displayContext == class_811.field_4317) {
                matrices.method_46416(data.bobbing, data.bobbing, 0.0f);
            } else {
                matrices.method_46416(0.0f, data.bobbing, 0.0f);
            }
        }
        data.item.method_65604(matrices, queue, light, overlay, 0);
        matrices.method_22909();
    }

    public void method_72175(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    public RenderData extractArgument(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    @Environment(value=EnvType.CLIENT)
    public static class RenderData {
        class_10444.class_10446 state;
        class_10444 item;
        int itemInUseCount;
        boolean reverseBobbing;
        float bobbing;
    }

    @Environment(value=EnvType.CLIENT)
    public record Unbaked(class_2960 model) implements class_10439.class_10441
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("model").forGetter(Unbaked::model)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> method_65585() {
            return CODEC;
        }

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(this.model);
        }

        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 model = baker.method_45872(this.model);
            class_10419 textures = model.method_68045();
            List quads = model.method_68034(textures, baker, (class_3665)class_1086.field_63619).method_68048();
            class_10809 settings = class_10809.method_68001((class_7775)baker, (class_10819)model, (class_10419)textures);
            return new SandPaperModel(quads, settings);
        }
    }
}

