/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10419;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_10526;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_11684;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_804;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class WorldshaperModel
implements class_10439,
class_10515<RenderData> {
    public static final class_2960 ID = class_2960.method_60655((String)"create", (String)"model/handheld_worldshaper");
    public static final class_2960 ITEM_ID = class_2960.method_60655((String)"create", (String)"item/handheld_worldshaper/item");
    public static final class_2960 CORE_ID = class_2960.method_60655((String)"create", (String)"item/handheld_worldshaper/core");
    public static final class_2960 CORE_GLOW_ID = class_2960.method_60655((String)"create", (String)"item/handheld_worldshaper/core_glow");
    public static final class_2960 ACCELERATOR_ID = class_2960.method_60655((String)"create", (String)"item/handheld_worldshaper/accelerator");
    private static final int[] TINTS = new int[0];
    private static final class_5819 random = class_5819.method_43047();
    private static final class_4587 matrices = new class_4587();
    private final class_1921 blockLayer = class_4722.method_76545();
    private final class_1921 itemLayer = CreateRenderTypes.itemGlowingSolid();
    private final class_1921 translucent = CreateRenderTypes.itemGlowingTranslucent();
    private final class_10809 settings;
    private final List<class_777> item;
    private final List<class_777> core;
    private final List<class_777> coreGlow;
    private final List<class_777> accelerator;
    private final Supplier<Vector3fc[]> vector;

    public WorldshaperModel(class_10809 settings, List<class_777> item, List<class_777> core, List<class_777> coreGlow, List<class_777> accelerator) {
        this.settings = settings;
        this.item = item;
        this.core = core;
        this.coreGlow = coreGlow;
        this.accelerator = accelerator;
        this.vector = Suppliers.memoize(() -> {
            HashSet<Vector3fc> set = new HashSet<Vector3fc>();
            WorldshaperModel.addPosition(set, item);
            WorldshaperModel.addPosition(set, core);
            WorldshaperModel.addPosition(set, coreGlow);
            WorldshaperModel.addPosition(set, accelerator);
            return (Vector3fc[])set.toArray(Vector3fc[]::new);
        });
    }

    private static void addPosition(Set<Vector3fc> set, List<class_777> quads) {
        for (class_777 bakedQuad : quads) {
            set.add(bakedQuad.comp_5238());
            set.add(bakedQuad.comp_5239());
            set.add(bakedQuad.comp_5240());
            set.add(bakedQuad.comp_5241());
        }
    }

    public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 user, int seed) {
        state.method_70946((Object)this);
        state.method_70947();
        class_10444.class_10446 renderState = state.method_65601();
        renderState.method_67995(this.vector);
        renderState.method_67996(this.settings.comp_3766());
        renderState.method_67994(this.settings.comp_3767());
        RenderData data = new RenderData();
        data.transform = this.settings.comp_3768().method_3503(displayContext);
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        boolean mainHand = player.method_6047() == stack;
        data.rightHand = mainHand ^ player.method_6068() == class_1306.field_6182;
        boolean bl = data.inHand = mainHand || player.method_6079() == stack;
        if (displayContext == class_811.field_4317) {
            data.state = (class_2680)stack.method_58694(AllDataComponents.SHAPER_BLOCK_USED);
            data.used = UsedRenderState.create(mc, data.state, displayContext, world, user, seed);
        }
        state.method_70946((Object)data);
        renderState.method_65617((class_10515)this, (Object)data);
    }

    public void submit(RenderData data, class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, boolean glint, int i) {
        assert (data != null);
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22903();
        data.transform.method_23075(displayContext.method_67675(), matrices.method_23760());
        WorldshaperModel.renderItem(displayContext, matrices, queue, light, overlay, this.item, this.blockLayer);
        float pt = AnimationTickHolder.getPartialTicks();
        float worldTime = AnimationTickHolder.getRenderTime() / 20.0f;
        float animation = class_3532.method_15363((float)(Create.ZAPPER_RENDER_HANDLER.getAnimation(data.rightHand, pt) * 5.0f), (float)0.0f, (float)1.0f);
        float multiplier = data.inHand ? animation : class_3532.method_15374((double)(worldTime * 5.0f));
        int lightItensity = (int)(15.0f * class_3532.method_15363((float)multiplier, (float)0.0f, (float)1.0f));
        int glowLight = class_765.method_23687((int)lightItensity, (int)Math.max(lightItensity, 4));
        WorldshaperModel.renderItem(displayContext, matrices, queue, glowLight, overlay, this.core, this.itemLayer);
        WorldshaperModel.renderItem(displayContext, matrices, queue, glowLight, overlay, this.coreGlow, this.translucent);
        float angle = worldTime * -25.0f;
        if (data.inHand) {
            angle += 360.0f * animation;
        }
        matrices.method_46416(0.5f, 0.345f, 0.5f);
        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(angle %= 360.0f));
        matrices.method_46416(-0.5f, -0.345f, -0.5f);
        WorldshaperModel.renderItem(displayContext, matrices, queue, light, overlay, this.accelerator, this.blockLayer);
        matrices.method_22909();
        if (data.used != null) {
            data.used.render(matrices, queue, light, overlay);
        }
        matrices.method_22909();
    }

    private static void renderItem(class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, List<class_777> item, class_1921 layer) {
        queue.method_73480(matrices, displayContext, light, overlay, 0, TINTS, item, layer, class_10444.class_10445.field_55341);
    }

    public void method_72175(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    public RenderData extractArgument(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    @Environment(value=EnvType.CLIENT)
    public static class RenderData {
        public class_804 transform;
        public class_2680 state;
        public boolean rightHand;
        public boolean inHand;
        public UsedRenderState used;

        public boolean equals(Object o) {
            if (!(o instanceof RenderData)) {
                return false;
            }
            RenderData data = (RenderData)o;
            return this.transform == data.transform && this.state == data.state && this.rightHand == data.rightHand && this.inHand == data.inHand;
        }

        public int hashCode() {
            return Objects.hash(this.rightHand, this.inHand);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface UsedRenderState {
        public static UsedRenderState create(class_310 mc, class_2680 state, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 user, int seed) {
            if (state == null) {
                return null;
            }
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof class_2310) {
                class_2310 block = (class_2310)class_22482;
                return UsedItemRenderState.create(mc, block, displayContext, world, user, seed);
            }
            return UsedBlockRenderState.create(mc, state, random, matrices);
        }

        public void render(class_4587 var1, class_11659 var2, int var3, int var4);
    }

    @Environment(value=EnvType.CLIENT)
    public record UsedBlockRenderState(class_1921 layer, class_776 blockRenderManager, class_4587 matrices, SinglePosVirtualBlockGetter world, class_2680 state, List<class_10889> parts) implements UsedRenderState,
    class_11659.class_11660
    {
        public static UsedBlockRenderState create(class_310 mc, class_2680 state, class_5819 random, class_4587 matrices) {
            class_1921 layer = class_4696.method_23679((class_2680)state) == class_11515.field_60926 ? class_4722.method_29382() : class_4722.method_24074();
            class_776 blockRenderManager = mc.method_1541();
            SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
            world.blockState(state);
            random.method_43052(42L);
            List parts = blockRenderManager.method_3349(state).method_68512(random);
            return new UsedBlockRenderState(layer, blockRenderManager, matrices, world, state, parts);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue, int light, int overlay) {
            matrices.method_46416(-0.42f, -0.385f, 0.0f);
            matrices.method_22905(0.25f, 0.25f, 0.25f);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(30.0f));
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
            queue.method_73483(matrices, this.layer, (class_11659.class_11660)this);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.matrices.method_23760().method_66521(matricesEntry);
            this.blockRenderManager.method_3355(this.state, class_2338.field_10980, (class_1920)this.world, this.matrices, vertexConsumer, false, this.parts);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record UsedItemRenderState(class_308 diffuseLighting, class_4597.class_4598 entityVertexConsumers, class_11684 entityRenderDispatcher, class_10444 state) implements UsedRenderState
    {
        public static UsedItemRenderState create(class_310 mc, class_2310 block, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 user, int seed) {
            class_10444 item = new class_10444();
            item.field_55337 = displayContext;
            mc.method_65386().method_65596(item, block.method_8389().method_7854(), displayContext, (class_1937)world, user, seed);
            if (item.method_65608()) {
                return new UsedItemRenderState(null, null, null, item);
            }
            class_757 gameRenderer = mc.field_1773;
            return new UsedItemRenderState(gameRenderer.method_71114(), mc.method_22940().method_23000(), gameRenderer.method_72911(), item);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue, int light, int overlay) {
            if (this.diffuseLighting != null) {
                this.entityRenderDispatcher.method_73002();
                this.entityVertexConsumers.method_22993();
                this.diffuseLighting.method_71034(class_308.class_11274.field_60026);
            }
            matrices.method_46416(-0.242f, -0.278f, 0.0f);
            matrices.method_22905(0.25f, 0.25f, 0.25f);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(30.0f));
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
            this.state.method_65604(matrices, queue, light, overlay, 0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Unbaked
    implements class_10439.class_10441 {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<? extends class_10439.class_10441> method_65585() {
            return CODEC;
        }

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(CORE_ID);
            resolver.markDependency(CORE_GLOW_ID);
            resolver.markDependency(ACCELERATOR_ID);
        }

        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 model = baker.method_45872(ITEM_ID);
            class_10419 textures = model.method_68045();
            List quads = model.method_68034(textures, baker, (class_3665)class_1086.field_63619).method_68048();
            class_10809 settings = class_10809.method_68001((class_7775)baker, (class_10819)model, (class_10419)textures);
            return new WorldshaperModel(settings, quads, Unbaked.bake(baker, CORE_ID), Unbaked.bake(baker, CORE_GLOW_ID), Unbaked.bake(baker, ACCELERATOR_ID));
        }

        private static List<class_777> bake(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            return model.method_68034(model.method_68045(), baker, (class_3665)class_1086.field_63619).method_68048();
        }
    }
}

