/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.PonderSceneElement;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.instruction.TickingInstruction;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class AnimateElementInstruction<T extends PonderSceneElement>
extends TickingInstruction {
    protected class_243 deltaPerTick;
    protected class_243 totalDelta;
    protected class_243 target;
    protected ElementLink<T> link;
    protected T element;
    private final BiConsumer<T, class_243> setter;
    private final Function<T, class_243> getter;

    protected AnimateElementInstruction(ElementLink<T> link, class_243 totalDelta, int ticks, BiConsumer<T, class_243> setter, Function<T, class_243> getter) {
        super(false, ticks);
        this.link = link;
        this.setter = setter;
        this.getter = getter;
        this.deltaPerTick = totalDelta.method_1021(1.0 / (double)ticks);
        this.totalDelta = totalDelta;
        this.target = totalDelta;
    }

    @Override
    protected final void firstTick(PonderScene scene) {
        super.firstTick(scene);
        this.element = (PonderSceneElement)scene.resolve(this.link);
        if (this.element == null) {
            return;
        }
        this.target = this.getter.apply(this.element).method_1019(this.totalDelta);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.element == null) {
            return;
        }
        if (this.remainingTicks == 0) {
            this.setter.accept(this.element, this.target);
            this.setter.accept(this.element, this.target);
            return;
        }
        this.setter.accept(this.element, this.getter.apply(this.element).method_1019(this.deltaPerTick));
    }
}

