/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.render.DefaultSuperRenderTypeBuffer;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.render.SceneRenderState;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_12137;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class SceneRenderer
extends class_11239<SceneRenderState> {
    private static final Vector3f DIFFUSE_LIGHT_0 = new Vector3f(0.4f, -1.0f, 0.7f).normalize();
    private static final Vector3f DIFFUSE_LIGHT_1 = new Vector3f(-0.4f, -0.5f, 0.7f).normalize();
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public SceneRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public void prepare(SceneRenderState renderState, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        int width = renderState.width() * windowScaleFactor;
        int height = renderState.height() * windowScaleFactor;
        GpuTexture texture = (GpuTexture)TEXTURES.get(renderState.id());
        if (texture == null) {
            texture = GpuTexture.create(width, height);
            TEXTURES.put(renderState.id(), (Object)texture);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.field_60042.method_71092((float)width, (float)height), (class_10366)class_10366.field_54954);
        texture.prepare();
        this.matrices.method_22903();
        this.matrices.method_22905((float)windowScaleFactor, (float)windowScaleFactor, 1.0f);
        class_310 mc = class_310.method_1551();
        class_757 gameRenderer = mc.field_1773;
        class_308 lighting = gameRenderer.method_71114();
        class_11684 renderDispatcher = gameRenderer.method_72911();
        lighting.method_71035(class_308.class_11274.field_60025, DIFFUSE_LIGHT_0, DIFFUSE_LIGHT_1);
        lighting.method_71034(class_308.class_11274.field_60025);
        class_11661 queue = renderDispatcher.method_73003();
        this.renderScene(mc, renderState, this.matrices, queue);
        renderDispatcher.method_73002();
        this.field_59933.method_22993();
        lighting.method_71036(mc.field_1687.method_8597().comp_5221());
        this.matrices.method_22909();
        texture.clear();
        state.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView(), (class_12137)RenderSystem.getSamplerCache().method_75297(FilterMode.NEAREST)), renderState.method_72127(), renderState.comp_4122(), renderState.comp_4123(), renderState.comp_4124(), renderState.comp_4125(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
    }

    private void renderScene(class_310 mc, SceneRenderState state, class_4587 poseStack, class_11661 queue) {
        float partialTicks = state.partialTicks();
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        PonderScene scene = state.scene();
        poseStack.method_46416(0.0f, 0.0f, -800.0f);
        PonderScene.SceneTransform transform = scene.getTransform();
        transform.updateScreenParams(state.width(), state.height(), state.slide());
        transform.apply(poseStack, partialTicks);
        transform.updateSceneRVE(partialTicks);
        if (!scene.shouldHidePlatformShadow()) {
            float flash;
            poseStack.method_22903();
            poseStack.method_46416((float)scene.getBasePlateOffsetX(), 0.0f, (float)scene.getBasePlateOffsetZ());
            UIRenderHelper.flipForGuiRender(poseStack);
            float alpha = flash = state.finishingFlash().getValue(partialTicks) * 0.9f;
            flash *= flash;
            flash = flash * 2.0f - 1.0f;
            flash *= flash;
            flash = 1.0f - flash;
            for (int f = 0; f < 4; ++f) {
                poseStack.method_46416((float)scene.getBasePlateSize(), 0.0f, 0.0f);
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, -9.765625E-4f);
                if (flash > 0.0f) {
                    poseStack.method_22903();
                    poseStack.method_22905(1.0f, 0.5f + flash * 0.75f, 1.0f);
                    SceneRenderer.fillGradient((class_4597)this.field_59933, this.matrices, 0, -1, -scene.getBasePlateSize(), 0, 0, new Color(13041609).getRGB(), new Color(-1429798967).scaleAlpha(alpha).getRGB());
                    poseStack.method_22909();
                }
                poseStack.method_46416(0.0f, 0.0f, 0.001953125f);
                SceneRenderer.fillGradient((class_4597)this.field_59933, this.matrices, 0, 0, -scene.getBasePlateSize(), 4, 0, new Color(0x66000000).getRGB(), new Color(0).getRGB());
                poseStack.method_22909();
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
            }
            poseStack.method_22909();
        }
        this.field_59933.method_22993();
        scene.renderScene(mc, buffer, queue, poseStack, partialTicks);
        buffer.draw();
    }

    public static void fillGradient(class_4597 vertexConsumers, class_4587 matrices, int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        class_4588 buffer = vertexConsumers.method_73477(PonderRenderTypes.getGui());
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        buffer.method_22918((Matrix4fc)matrix4f, (float)x1, (float)y1, (float)z).method_39415(colorFrom);
        buffer.method_22918((Matrix4fc)matrix4f, (float)x1, (float)y2, (float)z).method_39415(colorTo);
        buffer.method_22918((Matrix4fc)matrix4f, (float)x2, (float)y2, (float)z).method_39415(colorTo);
        buffer.method_22918((Matrix4fc)matrix4f, (float)x2, (float)y1, (float)z).method_39415(colorFrom);
    }

    protected void renderToTexture(SceneRenderState state, class_4587 matrices) {
    }

    protected String method_70906() {
        return "Scene";
    }

    public Class<SceneRenderState> method_70903() {
        return SceneRenderState.class;
    }
}

