/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.ui;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1144;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class PonderProgressBar
extends AbstractSimiWidget {
    public static final Couple<Color> BAR_COLORS = Couple.create(new Color(-2136298787, true), new Color(1353362141, true)).map(Color::setImmutable);
    LerpedFloat progress;
    PonderUI ponder;

    public PonderProgressBar(PonderUI ponder, int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.ponder = ponder;
        this.progress = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void tick() {
        this.progress.chase(this.ponder.getActiveScene().getSceneProgress(), 0.5, LerpedFloat.Chaser.EXP);
        this.progress.tickChaser();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && this.ponder.getActiveScene().getKeyframeCount() > 0 && mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758 + 4) && mouseY >= (double)this.method_46427() - 3.0 && mouseY < (double)(this.method_46427() + this.field_22759 + 20);
    }

    public void method_25365(boolean focused) {
        super.method_25365(false);
    }

    @Override
    public void method_25348(class_11909 click, boolean doubled) {
        PonderScene activeScene = this.ponder.getActiveScene();
        int keyframeIndex = this.getHoveredKeyframeIndex(activeScene, click.comp_4798());
        if (keyframeIndex == -1) {
            this.ponder.seekToTime(0);
        } else if (keyframeIndex == activeScene.getKeyframeCount()) {
            this.ponder.seekToTime(activeScene.getTotalTime());
        } else {
            this.ponder.seekToTime(activeScene.getKeyframeTime(keyframeIndex));
        }
    }

    public int getHoveredKeyframeIndex(PonderScene activeScene, double mouseX) {
        int keyframeTime;
        int totalTime = activeScene.getTotalTime();
        int clickedAtTime = (int)((mouseX - (double)this.method_46426()) / ((double)this.field_22758 + 4.0) * (double)totalTime);
        int lastKeyframeTime = activeScene.getKeyframeTime(activeScene.getKeyframeCount() - 1);
        int diffToEnd = totalTime - clickedAtTime;
        int diffToLast = clickedAtTime - lastKeyframeTime;
        if (diffToEnd > 0 && diffToEnd < diffToLast / 2) {
            return activeScene.getKeyframeCount();
        }
        int index = -1;
        int i = 0;
        while (i < activeScene.getKeyframeCount() && (keyframeTime = activeScene.getKeyframeTime(i)) <= clickedAtTime) {
            index = i++;
        }
        return index;
    }

    @Override
    public void doRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        this.field_22762 = this.method_25405(mouseX, mouseY);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(this.method_46426(), this.method_46427(), 400.0f).withBounds(this.field_22758, this.field_22759).render(graphics);
        poseStack.pushMatrix();
        poseStack.translate((float)(this.method_46426() - 2), (float)(this.method_46427() - 2));
        poseStack.pushMatrix();
        poseStack.scale((float)(this.field_22758 + 4) * this.progress.getValue(partialTicks), 1.0f);
        Color c1 = (Color)BAR_COLORS.getFirst();
        Color c2 = (Color)BAR_COLORS.getSecond();
        UIRenderHelper.drawGradientRect(graphics, 0.0f, 1.0f, 1.0f, 3.0f, c1, c1);
        UIRenderHelper.drawGradientRect(graphics, 0.0f, 3.0f, 1.0f, 4.0f, c2, c2);
        poseStack.popMatrix();
        this.renderKeyframes(graphics, mouseX, partialTicks);
        poseStack.popMatrix();
    }

    private void renderKeyframes(class_332 graphics, int mouseX, float partialTicks) {
        PonderScene activeScene = this.ponder.getActiveScene();
        Couple<Color> hover = PonderUI.COLOR_HOVER.map(c -> c.setAlpha(224));
        Couple<Color> idle = PonderUI.COLOR_HOVER.map(c -> c.setAlpha(112));
        int hoverIndex = this.field_22762 ? this.getHoveredKeyframeIndex(activeScene, mouseX) : -2;
        if (hoverIndex == -1) {
            this.drawKeyframe(graphics, activeScene, true, 0, 0, (Color)hover.getFirst(), (Color)hover.getSecond(), 8);
        } else if (hoverIndex == activeScene.getKeyframeCount()) {
            this.drawKeyframe(graphics, activeScene, true, activeScene.getTotalTime(), this.field_22758 + 4, (Color)hover.getFirst(), (Color)hover.getSecond(), 8);
        }
        for (int i = 0; i < activeScene.getKeyframeCount(); ++i) {
            int keyframeTime = activeScene.getKeyframeTime(i);
            int keyframePos = (int)((float)keyframeTime / (float)activeScene.getTotalTime() * (float)(this.field_22758 + 2));
            boolean selected = i == hoverIndex;
            Couple<Color> colors = selected ? hover : idle;
            int height = selected ? 8 : 4;
            this.drawKeyframe(graphics, activeScene, selected, keyframeTime, keyframePos, (Color)colors.getFirst(), (Color)colors.getSecond(), height);
        }
    }

    private void drawKeyframe(class_332 graphics, PonderScene activeScene, boolean selected, int keyframeTime, int keyframePos, Color startColor, Color endColor, int height) {
        if (selected) {
            int offset;
            String text;
            class_327 font = graphics.field_44656.field_1772;
            UIRenderHelper.drawGradientRect(graphics, keyframePos, 9.0f, (float)keyframePos + 2.0f, 9.0f + (float)height, endColor, startColor);
            if (activeScene.getCurrentTime() < keyframeTime) {
                text = ">";
                offset = -2 - font.method_1727(text);
            } else {
                text = "<";
                offset = 4;
            }
            graphics.method_51439(font, (class_2561)class_2561.method_43470((String)text).method_27692(class_124.field_1067), keyframePos + offset, 10, endColor.getRGB(), false);
        }
        UIRenderHelper.drawGradientRect(graphics, keyframePos, 0.0f, (float)keyframePos + 2.0f, 1.0f + (float)height, startColor, endColor);
    }

    public void method_25354(class_1144 handler) {
    }
}

