/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllContraptionTypeTags;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.UniqueLinkedList;
import com.zurrtum.create.catnip.math.BBHelper;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ContraptionWorld;
import com.zurrtum.create.content.contraptions.MountedStorageManager;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.zurrtum.create.content.contraptions.actors.seat.SeatBlock;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.bearing.MechanicalBearingBlock;
import com.zurrtum.create.content.contraptions.bearing.StabilizedContraption;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlock;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import com.zurrtum.create.content.contraptions.chassis.ChassisBlockEntity;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonHeadBlock;
import com.zurrtum.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.logistics.crate.CreativeCrateBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.redstone.contact.RedstoneContactBlock;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import net.minecraft.class_10225;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2281;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2440;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2764;
import net.minecraft.class_2769;
import net.minecraft.class_2814;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3499;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_7477;
import net.minecraft.class_7871;
import net.minecraft.class_8942;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class Contraption {
    public static final Codec<Map<UUID, Integer>> SEAT_MAP_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)Codec.INT);
    public static final Codec<Map<UUID, BlockFace>> SUB_CONTRAPTIONS_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, BlockFace.CODEC);
    public Optional<List<class_238>> simplifiedEntityColliders;
    public AbstractContraptionEntity entity;
    public class_238 bounds;
    public class_2338 anchor;
    public boolean stalled;
    public boolean hasUniversalCreativeCrate;
    public boolean disassembled;
    protected Map<class_2338, class_3499.class_3501> blocks;
    protected Map<class_2338, class_2487> updateTags;
    public Object2BooleanMap<class_2338> isLegacy;
    protected List<MutablePair<class_3499.class_3501, MovementContext>> actors;
    protected Map<class_2338, MovingInteractionBehaviour> interactors;
    protected List<class_1799> disabledActors;
    protected List<class_238> superglue;
    protected List<class_2338> seats;
    protected Map<UUID, Integer> seatMapping;
    protected Map<UUID, BlockFace> stabilizedSubContraptions;
    protected MountedStorageManager storage;
    protected Multimap<class_2338, class_3499.class_3501> capturedMultiblocks;
    private Set<SuperGlueEntity> glueToRemove;
    private Map<class_2338, class_1297> initialPassengers;
    private List<BlockFace> pendingSubContraptions;
    private CompletableFuture<Void> simplifiedEntityColliderProvider;
    public final AtomicReference<?> clientContraption = new AtomicReference();
    protected ContraptionWorld collisionLevel;

    public Contraption() {
        this.blocks = new HashMap<class_2338, class_3499.class_3501>();
        this.updateTags = new HashMap<class_2338, class_2487>();
        this.isLegacy = new Object2BooleanArrayMap();
        this.seats = new ArrayList<class_2338>();
        this.actors = new ArrayList<MutablePair<class_3499.class_3501, MovementContext>>();
        this.disabledActors = new ArrayList<class_1799>();
        this.interactors = new HashMap<class_2338, MovingInteractionBehaviour>();
        this.superglue = new ArrayList<class_238>();
        this.seatMapping = new HashMap<UUID, Integer>();
        this.glueToRemove = new HashSet<SuperGlueEntity>();
        this.initialPassengers = new HashMap<class_2338, class_1297>();
        this.pendingSubContraptions = new ArrayList<BlockFace>();
        this.stabilizedSubContraptions = new HashMap<UUID, BlockFace>();
        this.simplifiedEntityColliders = Optional.empty();
        this.storage = new MountedStorageManager();
        this.capturedMultiblocks = ArrayListMultimap.create();
    }

    public ContraptionWorld getContraptionWorld() {
        if (this.collisionLevel == null) {
            this.collisionLevel = new ContraptionWorld(this.entity.method_73183(), this);
        }
        return this.collisionLevel;
    }

    public abstract boolean assemble(class_1937 var1, class_2338 var2) throws AssemblyException;

    public abstract boolean canBeStabilized(class_2350 var1, class_2338 var2);

    public abstract ContraptionType getType();

    protected boolean customBlockPlacement(class_1936 world, class_2338 pos, class_2680 state) {
        return false;
    }

    protected boolean customBlockRemoval(class_1936 world, class_2338 pos, class_2680 state) {
        return false;
    }

    protected boolean addToInitialFrontier(class_1937 world, class_2338 pos, class_2350 forcedDirection, Queue<class_2338> frontier) throws AssemblyException {
        return true;
    }

    public static Contraption fromData(class_1937 world, class_11368 view, boolean spawnData) {
        ContraptionType type = (ContraptionType)view.method_71426("Type", ContraptionType.CODEC).orElseThrow();
        Contraption contraption = type.factory.get();
        contraption.read(world, view, spawnData);
        contraption.collisionLevel = new ContraptionWorld(world, contraption);
        contraption.gatherBBsOffThread();
        return contraption;
    }

    public boolean searchMovedStructure(class_1937 world, class_2338 pos, @Nullable class_2350 forcedDirection) throws AssemblyException {
        this.initialPassengers.clear();
        UniqueLinkedList<class_2338> frontier = new UniqueLinkedList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        this.anchor = pos;
        if (this.bounds == null) {
            this.bounds = new class_238(class_2338.field_10980);
        }
        if (!BlockMovementChecks.isBrittle(world.method_8320(pos))) {
            frontier.add(pos);
        }
        if (!this.addToInitialFrontier(world, pos, forcedDirection, frontier)) {
            return false;
        }
        for (int limit = 100000; limit > 0; --limit) {
            if (frontier.isEmpty()) {
                return true;
            }
            if (this.moveBlock(world, forcedDirection, frontier, visited)) continue;
            return false;
        }
        throw AssemblyException.structureTooLarge();
    }

    public void onEntityCreated(AbstractContraptionEntity entity) {
        this.entity = entity;
        for (BlockFace blockFace : this.pendingSubContraptions) {
            class_2350 face = blockFace.getFace();
            StabilizedContraption subContraption = new StabilizedContraption(face);
            class_1937 world = entity.method_73183();
            class_2338 pos = blockFace.getPos();
            try {
                if (!subContraption.assemble(world, pos)) {
                }
            }
            catch (AssemblyException e) {}
            continue;
            subContraption.removeBlocksFromWorld(world, class_2338.field_10980);
            OrientedContraptionEntity movedContraption = OrientedContraptionEntity.create(world, subContraption, face);
            class_2338 anchor = blockFace.getConnectedPos();
            movedContraption.method_5814((float)anchor.method_10263() + 0.5f, anchor.method_10264(), (float)anchor.method_10260() + 0.5f);
            world.method_8649((class_1297)movedContraption);
            this.stabilizedSubContraptions.put(movedContraption.method_5667(), new BlockFace(this.toLocalPos(pos), face));
        }
        this.storage.initialize();
        this.gatherBBsOffThread();
    }

    public void onEntityRemoved(AbstractContraptionEntity entity) {
        if (this.simplifiedEntityColliderProvider != null) {
            this.simplifiedEntityColliderProvider.cancel(false);
            this.simplifiedEntityColliderProvider = null;
        }
    }

    public void onEntityInitialize(class_1937 world, AbstractContraptionEntity contraptionEntity) {
        if (world.method_8608()) {
            return;
        }
        for (OrientedContraptionEntity orientedCE : world.method_18467(OrientedContraptionEntity.class, contraptionEntity.method_5829().method_1014(1.0))) {
            if (!this.stabilizedSubContraptions.containsKey(orientedCE.method_5667())) continue;
            orientedCE.method_5804(contraptionEntity);
        }
        for (class_2338 seatPos : this.getSeats()) {
            int seatIndex;
            class_1297 passenger = this.initialPassengers.get(seatPos);
            if (passenger == null || (seatIndex = this.getSeats().indexOf(seatPos)) == -1) continue;
            contraptionEntity.addSittingPassenger(passenger, seatIndex);
        }
    }

    private boolean canStickTo(class_2680 state, class_2680 other) {
        class_2248 stateBlock = state.method_26204();
        if (stateBlock == class_2246.field_10030) {
            return other.method_26204() != class_2246.field_21211;
        }
        if (stateBlock == class_2246.field_21211) {
            return other.method_26204() != class_2246.field_10030;
        }
        class_2248 otherBlock = other.method_26204();
        return otherBlock == class_2246.field_10030 || otherBlock == class_2246.field_21211;
    }

    protected boolean moveBlock(class_1937 world, @Nullable class_2350 forcedDirection, Queue<class_2338> frontier, Set<class_2338> visited) throws AssemblyException {
        class_2350 offset;
        Object attached;
        class_2586 class_25862;
        class_2338 pos = frontier.poll();
        if (pos == null) {
            return false;
        }
        visited.add(pos);
        if (world.method_31606(pos)) {
            return true;
        }
        if (!world.method_8477(pos)) {
            throw AssemblyException.unloadedChunk(pos);
        }
        if (this.isAnchoringBlockAt(pos)) {
            return true;
        }
        class_2680 state = world.method_8320(pos);
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos)) {
            return true;
        }
        if (!this.movementAllowed(state, world, pos)) {
            throw AssemblyException.unmovableBlock(pos, state);
        }
        if (state.method_26204() instanceof AbstractChassisBlock && !this.moveChassis(world, pos, forcedDirection, frontier, visited)) {
            return false;
        }
        if (state.method_27852((class_2248)AllBlocks.BELT)) {
            this.moveBelt(pos, frontier, visited, state);
        }
        if (state.method_27852((class_2248)AllBlocks.WINDMILL_BEARING) && (class_25862 = world.method_8321(pos)) instanceof WindmillBearingBlockEntity) {
            WindmillBearingBlockEntity wbbe = (WindmillBearingBlockEntity)class_25862;
            wbbe.disassembleForMovement();
        }
        if (state.method_27852((class_2248)AllBlocks.GANTRY_CARRIAGE)) {
            this.moveGantryPinion(world, pos, frontier, visited, state);
        }
        if (state.method_27852((class_2248)AllBlocks.GANTRY_SHAFT)) {
            this.moveGantryShaft(world, pos, frontier, visited, state);
        }
        if (state.method_27852((class_2248)AllBlocks.STICKER) && ((Boolean)state.method_11654((class_2769)StickerBlock.EXTENDED)).booleanValue() && !visited.contains(attached = pos.method_10093(offset = (class_2350)state.method_11654((class_2769)StickerBlock.field_10927))) && !BlockMovementChecks.isNotSupportive(world.method_8320((class_2338)attached), offset.method_10153())) {
            frontier.add((class_2338)attached);
        }
        if ((attached = world.method_8321(pos)) instanceof ChainConveyorBlockEntity) {
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)attached;
            ccbe.notifyConnectedToValidate();
        }
        if (state.method_28498((class_2769)class_2281.field_10770) && state.method_28498((class_2769)class_2281.field_10768) && state.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && !visited.contains(attached = pos.method_10093(offset = class_2281.method_9758((class_2680)state)))) {
            frontier.add((class_2338)attached);
        }
        if ((attached = state.method_26204()) instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogey = (AbstractBogeyBlock)attached;
            for (class_2350 d : bogey.getStickySurfaces((class_1922)world, pos, state)) {
                if (visited.contains(pos.method_10093(d))) continue;
                frontier.add(pos.method_10093(d));
            }
        }
        if (state.method_27852((class_2248)AllBlocks.MECHANICAL_BEARING)) {
            this.moveBearing(pos, frontier, visited, state);
        }
        if (state.method_27852((class_2248)AllBlocks.WINDMILL_BEARING)) {
            this.moveWindmillBearing(pos, frontier, visited, state);
        }
        if (state.method_26204() instanceof SeatBlock) {
            this.moveSeat(world, pos);
        }
        if (state.method_26204() instanceof PulleyBlock) {
            this.movePulley(world, pos, frontier, visited);
        }
        if (state.method_26204() instanceof MechanicalPistonBlock && !this.moveMechanicalPiston(world, pos, frontier, visited, state)) {
            return false;
        }
        if (MechanicalPistonBlock.isExtensionPole(state)) {
            this.movePistonPole(world, pos, frontier, visited, state);
        }
        if (MechanicalPistonBlock.isPistonHead(state)) {
            this.movePistonHead(world, pos, frontier, visited, state);
        }
        class_2338 posDown = pos.method_10074();
        class_2680 stateBelow = world.method_8320(posDown);
        if (!visited.contains(posDown) && stateBelow.method_27852((class_2248)AllBlocks.CART_ASSEMBLER)) {
            frontier.add(posDown);
        }
        for (class_2350 offset2 : Iterate.directions) {
            boolean canStick;
            class_2338 offsetPos = pos.method_10093(offset2);
            class_2680 blockState = world.method_8320(offsetPos);
            if (this.isAnchoringBlockAt(offsetPos)) continue;
            if (!this.movementAllowed(blockState, world, offsetPos)) {
                if (offset2 != forcedDirection) continue;
                throw AssemblyException.unmovableBlock(pos, state);
            }
            boolean wasVisited = visited.contains(offsetPos);
            boolean faceHasGlue = SuperGlueEntity.isGlued((class_1936)world, pos, offset2, this.glueToRemove);
            boolean blockAttachedTowardsFace = BlockMovementChecks.isBlockAttachedTowards(blockState, world, offsetPos, offset2.method_10153());
            boolean brittle = BlockMovementChecks.isBrittle(blockState);
            boolean bl = canStick = !brittle && this.canStickTo(state, blockState);
            if (canStick) {
                if (state.method_26223() == class_3619.field_15970 || blockState.method_26223() == class_3619.field_15970) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(state, offset2)) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(blockState, offset2.method_10153())) {
                    canStick = false;
                }
            }
            if (wasVisited || !canStick && !blockAttachedTowardsFace && !faceHasGlue && (offset2 != forcedDirection || BlockMovementChecks.isNotSupportive(state, forcedDirection))) continue;
            frontier.add(offsetPos);
        }
        this.addBlock(world, pos, this.capture(world, pos));
        if (this.blocks.size() <= (Integer)AllConfigs.server().kinetics.maxBlocksMoved.get()) {
            return true;
        }
        throw AssemblyException.structureTooLarge();
    }

    protected void movePistonHead(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2338 attached;
        class_2350 direction = (class_2350)state.method_11654((class_2769)MechanicalPistonHeadBlock.field_10927);
        class_2338 offset = pos.method_10093(direction.method_10153());
        if (!visited.contains(offset)) {
            class_2350 pistonFacing;
            class_2680 blockState = world.method_8320(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((class_2350)blockState.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166() == direction.method_10166()) {
                frontier.add(offset);
            }
            if (blockState.method_26204() instanceof MechanicalPistonBlock && (pistonFacing = (class_2350)blockState.method_11654((class_2769)MechanicalPistonBlock.FACING)) == direction && blockState.method_11654(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
                frontier.add(offset);
            }
        }
        if (state.method_11654(MechanicalPistonHeadBlock.TYPE) == class_2764.field_12634 && !visited.contains(attached = pos.method_10093(direction))) {
            frontier.add(attached);
        }
    }

    protected void movePistonPole(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        for (class_2350 d : Iterate.directionsInAxis(((class_2350)state.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166())) {
            class_2350 pistonFacing;
            class_2338 offset = pos.method_10093(d);
            if (visited.contains(offset)) continue;
            class_2680 blockState = world.method_8320(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((class_2350)blockState.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166() == d.method_10166()) {
                frontier.add(offset);
            }
            if (MechanicalPistonBlock.isPistonHead(blockState) && ((class_2350)blockState.method_11654((class_2769)MechanicalPistonHeadBlock.field_10927)).method_10166() == d.method_10166()) {
                frontier.add(offset);
            }
            if (!(blockState.method_26204() instanceof MechanicalPistonBlock) || (pistonFacing = (class_2350)blockState.method_11654((class_2769)MechanicalPistonBlock.FACING)) != d && (pistonFacing != d.method_10153() || blockState.method_11654(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.EXTENDED)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryPinion(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2338 offset = pos.method_10093((class_2350)state.method_11654((class_2769)GantryCarriageBlock.FACING));
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
        class_2350.class_2351 rotationAxis = ((IRotate)state.method_26204()).getRotationAxis(state);
        for (class_2350 d : Iterate.directionsInAxis(rotationAxis)) {
            offset = pos.method_10093(d);
            class_2680 offsetState = world.method_8320(offset);
            if (!offsetState.method_27852((class_2248)AllBlocks.GANTRY_SHAFT) || ((class_2350)offsetState.method_11654((class_2769)GantryShaftBlock.FACING)).method_10166() != d.method_10166() || visited.contains(offset)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryShaft(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        for (class_2350 d : Iterate.directions) {
            class_2338 offset = pos.method_10093(d);
            if (visited.contains(offset)) continue;
            class_2680 offsetState = world.method_8320(offset);
            class_2350 facing = (class_2350)state.method_11654((class_2769)GantryShaftBlock.FACING);
            if (d.method_10166() == facing.method_10166() && offsetState.method_27852((class_2248)AllBlocks.GANTRY_SHAFT) && offsetState.method_11654((class_2769)GantryShaftBlock.FACING) == facing) {
                frontier.add(offset);
                continue;
            }
            if (!offsetState.method_27852((class_2248)AllBlocks.GANTRY_CARRIAGE) || offsetState.method_11654((class_2769)GantryCarriageBlock.FACING) != d) continue;
            frontier.add(offset);
        }
    }

    private void moveWindmillBearing(class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)WindmillBearingBlock.FACING);
        class_2338 offset = pos.method_10093(facing);
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
    }

    private void moveBearing(class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)MechanicalBearingBlock.FACING);
        if (!this.canBeStabilized(facing, pos.method_10059((class_2382)this.anchor))) {
            class_2338 offset = pos.method_10093(facing);
            if (!visited.contains(offset)) {
                frontier.add(offset);
            }
            return;
        }
        this.pendingSubContraptions.add(new BlockFace(pos, facing));
    }

    private void moveBelt(class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2338 nextPos = BeltBlock.nextSegmentPosition(state, pos, true);
        class_2338 prevPos = BeltBlock.nextSegmentPosition(state, pos, false);
        if (nextPos != null && !visited.contains(nextPos)) {
            frontier.add(nextPos);
        }
        if (prevPos != null && !visited.contains(prevPos)) {
            frontier.add(prevPos);
        }
    }

    private void moveSeat(class_1937 world, class_2338 pos) {
        SeatEntity seat;
        List passengers;
        class_2338 local = this.toLocalPos(pos);
        this.getSeats().add(local);
        List seatsEntities = world.method_18467(SeatEntity.class, new class_238(pos));
        if (!seatsEntities.isEmpty() && !(passengers = (seat = (SeatEntity)((Object)seatsEntities.getFirst())).method_5685()).isEmpty()) {
            this.initialPassengers.put(local, (class_1297)passengers.getFirst());
        }
    }

    private void movePulley(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited) {
        int limit = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        class_2338 ropePos = pos;
        while (limit-- >= 0 && world.method_8477(ropePos = ropePos.method_10074())) {
            class_2680 ropeState = world.method_8320(ropePos);
            class_2248 block = ropeState.method_26204();
            if (!(block instanceof PulleyBlock.RopeBlock) && !(block instanceof PulleyBlock.MagnetBlock)) {
                if (visited.contains(ropePos)) break;
                frontier.add(ropePos);
                break;
            }
            this.addBlock(world, ropePos, this.capture(world, ropePos));
        }
    }

    private boolean moveMechanicalPiston(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) throws AssemblyException {
        class_2680 poleState;
        class_2350 direction = (class_2350)state.method_11654((class_2769)MechanicalPistonBlock.FACING);
        MechanicalPistonBlock.PistonState pistonState = (MechanicalPistonBlock.PistonState)((Object)state.method_11654(MechanicalPistonBlock.STATE));
        if (pistonState == MechanicalPistonBlock.PistonState.MOVING) {
            return false;
        }
        class_2338 offset = pos.method_10093(direction.method_10153());
        if (!visited.contains(offset) && (poleState = world.method_8320(offset)).method_27852((class_2248)AllBlocks.PISTON_EXTENSION_POLE) && ((class_2350)poleState.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166() == direction.method_10166()) {
            frontier.add(offset);
        }
        if ((pistonState == MechanicalPistonBlock.PistonState.EXTENDED || MechanicalPistonBlock.isStickyPiston(state)) && !visited.contains(offset = pos.method_10093(direction))) {
            frontier.add(offset);
        }
        return true;
    }

    private boolean moveChassis(class_1937 world, class_2338 pos, class_2350 movementDirection, Queue<class_2338> frontier, Set<class_2338> visited) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof ChassisBlockEntity)) {
            return false;
        }
        ChassisBlockEntity chassis = (ChassisBlockEntity)be;
        chassis.addAttachedChasses(frontier, visited);
        List<class_2338> includedBlockPositions = chassis.getIncludedBlockPositions(movementDirection, false);
        if (includedBlockPositions == null) {
            return false;
        }
        for (class_2338 blockPos : includedBlockPositions) {
            if (visited.contains(blockPos)) continue;
            frontier.add(blockPos);
        }
        return true;
    }

    protected Pair<class_3499.class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        class_2680 blockstate = world.method_8320(pos);
        if (blockstate.method_27852((class_2248)AllBlocks.REDSTONE_CONTACT)) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)RedstoneContactBlock.POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.method_27852((class_2248)AllBlocks.POWERED_SHAFT)) {
            blockstate = BlockHelper.copyProperties(blockstate, AllBlocks.SHAFT.method_9564());
        }
        if (blockstate.method_26204() instanceof ControlsBlock && this.getType().is(AllContraptionTypeTags.OPENS_CONTROLS)) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)ControlsBlock.OPEN, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.method_28498((class_2769)SlidingDoorBlock.VISIBLE)) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate.method_26204() instanceof class_2269) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)class_2269.field_10729, (Comparable)Boolean.valueOf(false));
            world.method_64310(pos, blockstate.method_26204(), -1);
        }
        if (blockstate.method_26204() instanceof class_2440) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)class_2440.field_11358, (Comparable)Boolean.valueOf(false));
            world.method_64310(pos, blockstate.method_26204(), -1);
        }
        class_2487 compoundnbt = this.getBlockEntityNBT(world, pos);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PoweredShaftBlockEntity) {
            blockEntity = new BracketedKineticBlockEntity(pos, blockstate);
        }
        if (blockEntity instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)blockEntity;
            try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), Create.LOGGER);){
                fpbe.writeSafe((class_11372)new class_11362((class_8942)logging, (DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), compoundnbt));
            }
        }
        return Pair.of((Object)new class_3499.class_3501(pos, blockstate, compoundnbt), (Object)blockEntity);
    }

    protected void addBlock(class_1937 level, class_2338 pos, Pair<class_3499.class_3501, class_2586> pair) {
        CreativeCrateBlockEntity crateBlockEntity;
        MovingInteractionBehaviour interactionBehaviour;
        class_2680 state;
        class_3499.class_3501 structureBlockInfo;
        class_3499.class_3501 captured = (class_3499.class_3501)pair.getKey();
        class_2338 localPos = pos.method_10059((class_2382)this.anchor);
        if (this.blocks.put(localPos, structureBlockInfo = new class_3499.class_3501(localPos, state = captured.comp_1342(), captured.comp_1343())) != null) {
            return;
        }
        this.bounds = this.bounds.method_991(new class_238(localPos));
        class_2586 be = (class_2586)pair.getValue();
        if (be != null) {
            class_2487 updateTag = be.method_16887((class_7225.class_7874)level.method_30349());
            this.updateTags.put(localPos, updateTag);
        }
        this.storage.addBlock(level, state, pos, localPos, be);
        this.captureMultiblock(localPos, structureBlockInfo, be);
        if (MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)state) != null) {
            this.actors.add((MutablePair<class_3499.class_3501, MovementContext>)MutablePair.of((Object)structureBlockInfo, null));
        }
        if ((interactionBehaviour = MovingInteractionBehaviour.REGISTRY.get((class_2688<class_2248, ?>)state)) != null) {
            this.interactors.put(localPos, interactionBehaviour);
        }
        if (be instanceof CreativeCrateBlockEntity && (crateBlockEntity = (CreativeCrateBlockEntity)be).getBehaviour(ServerFilteringBehaviour.TYPE).getFilter().method_7960()) {
            this.hasUniversalCreativeCrate = true;
        }
    }

    protected void captureMultiblock(class_2338 localPos, class_3499.class_3501 structureBlockInfo, class_2586 be) {
        if (!(be instanceof IMultiBlockEntityContainer)) {
            return;
        }
        IMultiBlockEntityContainer multiBlockBE = (IMultiBlockEntityContainer)be;
        class_2487 nbt = structureBlockInfo.comp_1343();
        class_2338 controllerPos = nbt.method_67491("Controller", class_2338.field_25064).map(this::toLocalPos).orElse(localPos);
        nbt.method_67494("Controller", class_2338.field_25064, (Object)controllerPos);
        if (this.updateTags.containsKey(localPos)) {
            this.updateTags.get(localPos).method_67494("Controller", class_2338.field_25064, (Object)controllerPos);
        }
        if (multiBlockBE.isController() && multiBlockBE.getHeight() <= 1 && multiBlockBE.getWidth() <= 1) {
            nbt.method_67494("LastKnownPos", class_2338.field_25064, (Object)class_2338.field_10980.method_10087(0x7FFFFFFE));
            return;
        }
        nbt.method_10551("LastKnownPos");
        this.capturedMultiblocks.put((Object)controllerPos, (Object)structureBlockInfo);
    }

    @Nullable
    protected class_2487 getBlockEntityNBT(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null) {
            return null;
        }
        class_2487 nbt = blockEntity.method_38242((class_7225.class_7874)world.method_30349());
        nbt.method_10551("x");
        nbt.method_10551("y");
        nbt.method_10551("z");
        return nbt;
    }

    protected class_2338 toLocalPos(class_2338 globalPos) {
        return globalPos.method_10059((class_2382)this.anchor);
    }

    protected boolean movementAllowed(class_2680 state, class_1937 world, class_2338 pos) {
        return BlockMovementChecks.isMovementAllowed(state, world, pos);
    }

    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return pos.equals((Object)this.anchor);
    }

    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        this.readBlocksCompound(view.method_71434("Blocks"), world);
        this.capturedMultiblocks.clear();
        view.method_71438("CapturedMultiblocks").forEach(c -> {
            class_2338 controllerPos = (class_2338)c.method_71426("Controller", class_2338.field_25064).orElseThrow();
            ((List)c.method_71426("Parts", CreateCodecs.BLOCK_POS_LIST_CODEC).orElseThrow()).forEach(pos -> this.capturedMultiblocks.put((Object)controllerPos, (Object)this.blocks.get(pos)));
        });
        this.storage.read(view, spawnData, this);
        this.actors.clear();
        view.method_71438("Actors").forEach(c -> c.method_71426("Pos", class_2338.field_25064).ifPresent(pos -> {
            class_3499.class_3501 info = this.blocks.get(pos);
            if (info == null) {
                return;
            }
            MovementContext context = MovementContext.read(world, info, c, this);
            this.actors.add((MutablePair<class_3499.class_3501, MovementContext>)MutablePair.of((Object)info, (Object)context));
        }));
        this.disabledActors.clear();
        this.superglue.clear();
        this.seats.clear();
        this.seatMapping.clear();
        this.stabilizedSubContraptions.clear();
        view.method_71426("DisabledActors", CreateCodecs.ITEM_LIST_CODEC).ifPresent(list -> {
            this.disabledActors.addAll((Collection<class_1799>)list);
            for (class_1799 stack : this.disabledActors) {
                this.setActorsActive(stack, false);
            }
        });
        view.method_71426("Superglue", CreateCodecs.BOX_CODEC.listOf()).ifPresent(list -> this.superglue.addAll((Collection<class_238>)list));
        view.method_71426("Seats", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresent(list -> this.seats.addAll((Collection<class_2338>)list));
        view.method_71426("Passengers", SEAT_MAP_CODEC).ifPresent(map -> this.seatMapping.putAll((Map<UUID, Integer>)map));
        view.method_71426("SubContraptions", SUB_CONTRAPTIONS_CODEC).ifPresent(map -> this.stabilizedSubContraptions.putAll((Map<UUID, BlockFace>)map));
        view.method_71426("Interactors", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresentOrElse(list -> list.forEach(pos -> {
            class_3499.class_3501 structureBlockInfo = this.blocks.get(pos);
            if (structureBlockInfo == null) {
                return;
            }
            MovingInteractionBehaviour behaviour = MovingInteractionBehaviour.REGISTRY.get((class_2688<class_2248, ?>)structureBlockInfo.comp_1342());
            if (behaviour != null) {
                this.interactors.put((class_2338)pos, behaviour);
            }
        }), this.interactors::clear);
        view.method_71426("BoundsFront", CreateCodecs.BOX_CODEC).ifPresent(box -> {
            this.bounds = box;
        });
        this.stalled = view.method_71433("Stalled", false);
        this.hasUniversalCreativeCrate = view.method_71433("BottomlessSupply", false);
        this.anchor = (class_2338)view.method_71426("Anchor", class_2338.field_25064).orElseThrow();
    }

    public void write(class_11372 view, boolean spawnPacket) {
        view.method_71468("Type", CreateRegistries.CONTRAPTION_TYPE.method_39673(), (Object)this.getType());
        this.writeBlocksCompound(view.method_71461("Blocks"), spawnPacket);
        class_11372.class_11374 multiblocks = view.method_71476("CapturedMultiblocks");
        this.capturedMultiblocks.keySet().forEach(controllerPos -> {
            class_11372 block = multiblocks.method_71480();
            block.method_71468("Controller", class_2338.field_25064, controllerPos);
            Collection multiblockParts = this.capturedMultiblocks.get(controllerPos);
            List<class_2338> list = multiblockParts.stream().map(class_3499.class_3501::comp_1341).toList();
            block.method_71468("Parts", CreateCodecs.BLOCK_POS_LIST_CODEC, list);
        });
        class_11372.class_11374 actors = view.method_71476("Actors");
        for (MutablePair<class_3499.class_3501, MovementContext> actor : this.getActors()) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)((class_3499.class_3501)actor.left).comp_1342());
            if (behaviour == null) continue;
            class_11372 item = actors.method_71480();
            item.method_71468("Pos", class_2338.field_25064, (Object)((class_3499.class_3501)actor.left).comp_1341());
            behaviour.writeExtraData((MovementContext)actor.right);
            ((MovementContext)actor.right).write(item);
        }
        view.method_71468("DisabledActors", CreateCodecs.ITEM_LIST_CODEC, this.disabledActors);
        if (!spawnPacket) {
            view.method_71468("Superglue", CreateCodecs.BOX_CODEC.listOf(), this.superglue);
        }
        this.writeStorage(view, spawnPacket);
        view.method_71468("Interactors", CreateCodecs.BLOCK_POS_LIST_CODEC, this.interactors.keySet().stream().toList());
        view.method_71468("Seats", CreateCodecs.BLOCK_POS_LIST_CODEC, this.seats);
        view.method_71468("Passengers", SEAT_MAP_CODEC, this.seatMapping);
        view.method_71468("SubContraptions", SUB_CONTRAPTIONS_CODEC, this.stabilizedSubContraptions);
        view.method_71468("Anchor", class_2338.field_25064, (Object)this.anchor);
        view.method_71472("Stalled", this.stalled);
        view.method_71472("BottomlessSupply", this.hasUniversalCreativeCrate);
        if (this.bounds != null) {
            view.method_71468("BoundsFront", CreateCodecs.BOX_CODEC, (Object)this.bounds);
        }
    }

    public void writeStorage(class_11372 view, boolean spawnPacket) {
        this.storage.write(view, spawnPacket);
    }

    private void writeBlocksCompound(class_11372 view, boolean spawnPacket) {
        class_2814 palette = new class_2814(16);
        class_11372.class_11374 blockList = view.method_71476("BlockList");
        for (class_3499.class_3501 block : this.blocks.values()) {
            int id = palette.method_12291((Object)block.comp_1342(), (i, s) -> {
                throw new IllegalStateException("Palette Map index exceeded maximum");
            });
            class_2338 pos = block.comp_1341();
            class_11372 c = blockList.method_71480();
            c.method_71466("Pos", pos.method_10063());
            c.method_71465("State", id);
            class_2487 updateTag = this.updateTags.get(pos);
            if (spawnPacket) {
                if (updateTag != null) {
                    c.method_71468("Data", class_2487.field_25128, (Object)updateTag);
                    continue;
                }
                if (block.comp_1343() == null) continue;
                c.method_71468("Data", class_2487.field_25128, (Object)block.comp_1343());
                c.method_71472("Legacy", true);
                continue;
            }
            if (block.comp_1343() != null) {
                c.method_71468("Data", class_2487.field_25128, (Object)block.comp_1343());
            }
            if (updateTag == null) continue;
            c.method_71468("UpdateTag", class_2487.field_25128, (Object)updateTag);
        }
        int size = palette.method_12197();
        ArrayList<class_2680> paletteData = new ArrayList<class_2680>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            paletteData.add((class_2680)palette.method_12288(i2));
        }
        view.method_71468("Palette", CreateCodecs.BLOCK_STATE_LIST_CODEC, paletteData);
    }

    private void readBlocksCompound(class_11368 view, class_1937 world) {
        this.blocks.clear();
        this.updateTags.clear();
        this.isLegacy.clear();
        class_2814 palette = new class_2814(16, view.method_71426("Palette", CreateCodecs.BLOCK_STATE_LIST_CODEC).orElseGet(ArrayList::new));
        view.method_71438("BlockList").forEach(c -> {
            class_3499.class_3501 info = Contraption.readStructureBlockInfo(c, (class_2814<class_2680>)palette);
            this.blocks.put(info.comp_1341(), info);
            c.method_71426("UpdateTag", class_2487.field_25128).ifPresent(updateTag -> this.updateTags.put(info.comp_1341(), (class_2487)updateTag));
            this.isLegacy.put((Object)info.comp_1341(), c.method_71433("Legacy", false));
        });
        AllClientHandle.INSTANCE.resetClientContraption(this);
    }

    private static class_3499.class_3501 readStructureBlockInfo(class_11368 view, class_2814<class_2680> palette) {
        return new class_3499.class_3501(class_2338.method_10092((long)view.method_71425("Pos", 0L)), Objects.requireNonNull((class_2680)palette.method_12288(view.method_71424("State", 0))), (class_2487)view.method_71426("Data", class_2487.field_25128).orElse(null));
    }

    private static class_3499.class_3501 legacyReadStructureBlockInfo(class_2487 blockListEntry, class_7871<class_2248> holderGetter) {
        return new class_3499.class_3501(NBTHelper.readBlockPos(blockListEntry, "Pos"), class_2512.method_10681(holderGetter, (class_2487)blockListEntry.method_68568("Block")), blockListEntry.method_10545("Data") ? blockListEntry.method_68568("Data") : null);
    }

    public void removeBlocksFromWorld(class_1937 world, class_2338 offset) {
        this.glueToRemove.forEach(glue -> {
            this.superglue.add(glue.method_5829().method_997(class_243.method_24954((class_2382)offset.method_10081((class_2382)this.anchor)).method_1021(-1.0)));
            glue.method_31472();
        });
        ArrayList<class_3341> minimisedGlue = new ArrayList<class_3341>();
        for (int i = 0; i < this.superglue.size(); ++i) {
            minimisedGlue.add(null);
        }
        for (boolean brittles : Iterate.trueAndFalse) {
            Iterator<class_3499.class_3501> iterator = this.blocks.values().iterator();
            while (iterator.hasNext()) {
                class_3499.class_3501 block = iterator.next();
                if (brittles != BlockMovementChecks.isBrittle(block.comp_1342())) continue;
                for (int i = 0; i < this.superglue.size(); ++i) {
                    class_238 aabb = this.superglue.get(i);
                    if (aabb == null || !aabb.method_1008((double)block.comp_1341().method_10263() + 0.5, (double)block.comp_1341().method_10264() + 0.5, (double)block.comp_1341().method_10260() + 0.5)) continue;
                    if (minimisedGlue.get(i) == null) {
                        minimisedGlue.set(i, new class_3341(block.comp_1341()));
                        continue;
                    }
                    minimisedGlue.set(i, BBHelper.encapsulate((class_3341)minimisedGlue.get(i), block.comp_1341()));
                }
                class_2338 add = block.comp_1341().method_10081((class_2382)this.anchor).method_10081((class_2382)offset);
                if (this.customBlockRemoval((class_1936)world, add, block.comp_1342())) continue;
                class_2680 oldState = world.method_8320(add);
                class_2248 blockIn = oldState.method_26204();
                boolean blockMismatch = block.comp_1342().method_26204() != blockIn;
                if (blockMismatch &= AllBlocks.POWERED_SHAFT != blockIn || !block.comp_1342().method_27852((class_2248)AllBlocks.SHAFT)) {
                    iterator.remove();
                }
                world.method_8544(add);
                int flags = 122;
                if (blockIn instanceof class_3737 && oldState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)oldState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                    world.method_8652(add, class_2246.field_10382.method_9564(), flags);
                    continue;
                }
                world.method_8652(add, class_2246.field_10124.method_9564(), flags);
            }
        }
        this.superglue.clear();
        Object object = minimisedGlue.iterator();
        while (object.hasNext()) {
            class_238 bb;
            class_3341 box = (class_3341)object.next();
            if (box == null || !((bb = new class_238((double)box.method_35415(), (double)box.method_35416(), (double)box.method_35417(), (double)(box.method_35418() + 1), (double)(box.method_35419() + 1), (double)(box.method_35420() + 1))).method_995() > 1.01)) continue;
            this.superglue.add(bb);
        }
        for (class_3499.class_3501 block : this.blocks.values()) {
            class_2338 add = block.comp_1341().method_10081((class_2382)this.anchor).method_10081((class_2382)offset);
            int flags = 67;
            world.method_8413(add, block.comp_1342(), class_2246.field_10124.method_9564(), flags);
            class_3218 serverWorld = (class_3218)world;
            class_7477.method_43989((class_2680)block.comp_1342()).ifPresent(poiType -> world.method_8503().execute(() -> serverWorld.method_19494().method_19115(add, poiType)));
            BlockHelper.markAndNotifyBlock(world, add, world.method_8500(add), block.comp_1342(), class_2246.field_10124.method_9564(), flags);
            block.comp_1342().method_30102((class_1936)world, add, flags & 0xFFFFFFFE);
        }
    }

    public void addBlocksToWorld(class_1937 world, StructureTransform transform) {
        if (this.disassembled) {
            return;
        }
        this.disassembled = true;
        boolean shouldDropBlocks = (Boolean)AllConfigs.server().kinetics.noDropWhenContraptionReplaceBlocks.get() == false;
        this.translateMultiblockControllers(transform);
        for (boolean nonBrittles : Iterate.trueAndFalse) {
            for (class_3499.class_3501 block : this.blocks.values()) {
                class_2680 blockState;
                class_2680 state;
                class_2338 targetPos;
                if (nonBrittles == BlockMovementChecks.isBrittle(block.comp_1342()) || this.customBlockPlacement((class_1936)world, targetPos = transform.apply(block.comp_1341()), state = transform.apply(block.comp_1342()))) continue;
                if (nonBrittles) {
                    for (class_2350 face : Iterate.directions) {
                        state = state.method_26191((class_4538)world, (class_10225)world, targetPos, face, targetPos.method_10093(face), world.method_8320(targetPos.method_10093(face)), world.field_9229);
                    }
                }
                if ((blockState = world.method_8320(targetPos)).method_26214((class_1922)world, targetPos) == -1.0f || state.method_26220((class_1922)world, targetPos).method_1110() && !blockState.method_26220((class_1922)world, targetPos).method_1110()) {
                    if (targetPos.method_10264() == world.method_31607()) {
                        targetPos = targetPos.method_10084();
                    }
                    world.method_20290(2001, targetPos, class_2248.method_9507((class_2680)state));
                    if (!shouldDropBlocks) continue;
                    class_2248.method_9610((class_2680)state, (class_1936)world, (class_2338)targetPos, null);
                    continue;
                }
                if (state.method_26204() instanceof class_3737 && state.method_28498((class_2769)class_2741.field_12508)) {
                    class_3610 FluidState = world.method_8316(targetPos);
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(FluidState.method_15772() == class_3612.field_15910));
                }
                world.method_22352(targetPos, shouldDropBlocks);
                if (state.method_27852((class_2248)AllBlocks.SHAFT)) {
                    state = ShaftBlock.pickCorrectShaftType(state, world, targetPos);
                }
                if (state.method_28498((class_2769)SlidingDoorBlock.VISIBLE)) {
                    state = (class_2680)((class_2680)state.method_11657((class_2769)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)SlidingDoorBlock.field_10945) == false))).method_11657((class_2769)SlidingDoorBlock.field_10940, (Comparable)Boolean.valueOf(false));
                }
                if (state.method_27852(class_2246.field_37571)) {
                    state = class_2246.field_37571.method_9564();
                }
                world.method_8652(targetPos, state, 67);
                boolean verticalRotation = transform.rotationAxis == null || transform.rotationAxis.method_10179();
                boolean bl = verticalRotation = verticalRotation && transform.rotation != class_2470.field_11467;
                if (verticalRotation && (state.method_26204() instanceof PulleyBlock.RopeBlock || state.method_26204() instanceof PulleyBlock.MagnetBlock || state.method_26204() instanceof class_2323)) {
                    world.method_22352(targetPos, shouldDropBlocks);
                }
                class_2586 blockEntity = world.method_8321(targetPos);
                class_2487 tag = block.comp_1343();
                if (state.method_27852(class_2246.field_28108) || state.method_27852(class_2246.field_37571)) {
                    tag = null;
                }
                if (blockEntity != null) {
                    tag = NBTProcessors.process(state, blockEntity, tag, false);
                }
                if (blockEntity != null && tag != null) {
                    tag.method_10569("x", targetPos.method_10263());
                    tag.method_10569("y", targetPos.method_10264());
                    tag.method_10569("z", targetPos.method_10260());
                    if (verticalRotation && blockEntity instanceof PulleyBlockEntity) {
                        tag.method_10551("Offset");
                        tag.method_10551("InitialOffset");
                    }
                    if (blockEntity instanceof IMultiBlockEntityContainer && (tag.method_10545("LastKnownPos") || this.capturedMultiblocks.isEmpty())) {
                        tag.method_67494("LastKnownPos", class_2338.field_25064, (Object)class_2338.field_10980.method_10087(0x7FFFFFFE));
                        tag.method_10551("Controller");
                    }
                    try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), Create.LOGGER);){
                        blockEntity.method_58690(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)world.method_30349(), (class_2487)tag));
                    }
                }
                this.storage.unmount(world, block, targetPos, blockEntity);
                if (blockEntity == null) continue;
                transform.apply(blockEntity);
            }
        }
        Object object = this.blocks.values().iterator();
        while (object.hasNext()) {
            class_3499.class_3501 block = (class_3499.class_3501)object.next();
            if (!this.shouldUpdateAfterMovement(block)) continue;
            class_2338 targetPos = transform.apply(block.comp_1341());
            BlockHelper.markAndNotifyBlock(world, targetPos, world.method_8500(targetPos), block.comp_1342(), block.comp_1342(), 67);
        }
        for (class_238 box : this.superglue) {
            box = new class_238(transform.apply(new class_243(box.field_1323, box.field_1322, box.field_1321)), transform.apply(new class_243(box.field_1320, box.field_1325, box.field_1324)));
            if (world.method_8608()) continue;
            world.method_8649((class_1297)new SuperGlueEntity(world, box));
        }
    }

    protected void translateMultiblockControllers(StructureTransform transform) {
        if (transform.rotationAxis != null && transform.rotationAxis != class_2350.class_2351.field_11052 && transform.rotation != class_2470.field_11467) {
            this.capturedMultiblocks.values().forEach(info -> info.comp_1343().method_67494("LastKnownPos", class_2338.field_25064, (Object)class_2338.field_10980.method_10087(0x7FFFFFFE)));
            return;
        }
        this.capturedMultiblocks.keySet().forEach(controllerPos -> {
            Collection multiblockParts = this.capturedMultiblocks.get(controllerPos);
            Optional optionalBoundingBox = class_3341.method_35411(multiblockParts.stream().map(info -> transform.apply(info.comp_1341())).toList());
            if (optionalBoundingBox.isEmpty()) {
                return;
            }
            class_3341 boundingBox = (class_3341)optionalBoundingBox.get();
            class_2338 newControllerPos = new class_2338(boundingBox.method_35415(), boundingBox.method_35416(), boundingBox.method_35417());
            class_2338 otherPos = transform.unapply(newControllerPos);
            multiblockParts.forEach(info -> info.comp_1343().method_67494("Controller", class_2338.field_25064, (Object)newControllerPos));
            if (controllerPos.equals((Object)otherPos)) {
                return;
            }
            class_3499.class_3501 prevControllerInfo = this.blocks.get(controllerPos);
            class_3499.class_3501 newControllerInfo = this.blocks.get(otherPos);
            if (prevControllerInfo == null || newControllerInfo == null) {
                return;
            }
            this.blocks.put(otherPos, new class_3499.class_3501(newControllerInfo.comp_1341(), newControllerInfo.comp_1342(), prevControllerInfo.comp_1343()));
            this.blocks.put((class_2338)controllerPos, new class_3499.class_3501(prevControllerInfo.comp_1341(), prevControllerInfo.comp_1342(), newControllerInfo.comp_1343()));
        });
    }

    public void addPassengersToWorld(class_1937 world, StructureTransform transform, List<class_1297> seatedEntities) {
        for (class_1297 seatedEntity : seatedEntities) {
            Integer seatIndex;
            if (this.getSeatMapping().isEmpty() || (seatIndex = this.getSeatMapping().get(seatedEntity.method_5667())) == null) continue;
            class_2338 seatPos = this.getSeats().get(seatIndex);
            if (!(world.method_8320(seatPos = transform.apply(seatPos)).method_26204() instanceof SeatBlock) || SeatBlock.isSeatOccupied(world, seatPos)) continue;
            SeatBlock.sitDown(world, seatPos, seatedEntity);
        }
    }

    public void startMoving(class_1937 world) {
        this.disabledActors.clear();
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            MovementContext context = new MovementContext(world, (class_3499.class_3501)pair.left, this);
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)((class_3499.class_3501)pair.left).comp_1342());
            if (behaviour != null) {
                behaviour.startMoving(context);
            }
            pair.setRight((Object)context);
            if (!(behaviour instanceof ContraptionControlsMovement)) continue;
            this.disableActorOnStart(context);
        }
        for (class_1799 stack : this.disabledActors) {
            this.setActorsActive(stack, false);
        }
    }

    protected void disableActorOnStart(MovementContext context) {
        if (!ContraptionControlsMovement.isDisabledInitially(context)) {
            return;
        }
        class_1799 filter = ContraptionControlsMovement.getFilter(context);
        if (filter == null) {
            return;
        }
        if (this.isActorTypeDisabled(filter)) {
            return;
        }
        this.disabledActors.add(filter);
    }

    public boolean isActorTypeDisabled(class_1799 filter) {
        return this.disabledActors.stream().anyMatch(i -> ContraptionControlsMovement.isSameFilter(i, filter));
    }

    public void setActorsActive(class_1799 referenceStack, boolean enable) {
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            class_1799 behaviourStack;
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)((class_3499.class_3501)pair.left).comp_1342());
            if (behaviour == null || (behaviourStack = behaviour.canBeDisabledVia((MovementContext)pair.right)) == null || !referenceStack.method_7960() && !ContraptionControlsMovement.isSameFilter(referenceStack, behaviourStack)) continue;
            boolean bl = ((MovementContext)pair.right).disabled = !enable;
            if (enable) continue;
            behaviour.onDisabledByControls((MovementContext)pair.right);
        }
    }

    public List<class_1799> getDisabledActors() {
        return this.disabledActors;
    }

    public void stop(class_1937 world) {
        this.forEachActor(world, (behaviour, ctx) -> {
            behaviour.stopMoving((MovementContext)ctx);
            ctx.position = null;
            ctx.motion = class_243.field_1353;
            ctx.relativeMotion = class_243.field_1353;
            ctx.rotation = v -> v;
        });
    }

    public void forEachActor(class_1937 world, BiConsumer<MovementBehaviour, MovementContext> callBack) {
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)((class_3499.class_3501)pair.getLeft()).comp_1342());
            if (behaviour == null) continue;
            callBack.accept(behaviour, (MovementContext)pair.getRight());
        }
    }

    protected boolean shouldUpdateAfterMovement(class_3499.class_3501 info) {
        if (class_7477.method_43989((class_2680)info.comp_1342()).isPresent()) {
            return false;
        }
        return !(info.comp_1342().method_26204() instanceof SlidingDoorBlock);
    }

    public void expandBoundsAroundAxis(class_2350.class_2351 axis) {
        Set<class_2338> blocks = this.getBlocks().keySet();
        int radius = (int)Math.ceil(Contraption.getRadius(blocks, axis));
        int maxX = radius + 2;
        int maxY = radius + 2;
        int maxZ = radius + 2;
        int minX = -radius - 1;
        int minY = -radius - 1;
        int minZ = -radius - 1;
        if (axis == class_2350.class_2351.field_11048) {
            maxX = (int)this.bounds.field_1320;
            minX = (int)this.bounds.field_1323;
        } else if (axis == class_2350.class_2351.field_11052) {
            maxY = (int)this.bounds.field_1325;
            minY = (int)this.bounds.field_1322;
        } else if (axis == class_2350.class_2351.field_11051) {
            maxZ = (int)this.bounds.field_1324;
            minZ = (int)this.bounds.field_1321;
        }
        this.bounds = new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public Map<UUID, Integer> getSeatMapping() {
        return this.seatMapping;
    }

    public class_2338 getSeatOf(UUID entityId) {
        if (!this.getSeatMapping().containsKey(entityId)) {
            return null;
        }
        int seatIndex = this.getSeatMapping().get(entityId);
        if (seatIndex >= this.getSeats().size()) {
            return null;
        }
        return this.getSeats().get(seatIndex);
    }

    public class_2338 getBearingPosOf(UUID subContraptionEntityId) {
        if (this.stabilizedSubContraptions.containsKey(subContraptionEntityId)) {
            return this.stabilizedSubContraptions.get(subContraptionEntityId).getConnectedPos();
        }
        return null;
    }

    public void setSeatMapping(Map<UUID, Integer> seatMapping) {
        this.seatMapping = seatMapping;
    }

    public List<class_2338> getSeats() {
        return this.seats;
    }

    public Map<class_2338, class_3499.class_3501> getBlocks() {
        return this.blocks;
    }

    public Object2BooleanMap<class_2338> getIsLegacy() {
        return this.isLegacy;
    }

    public List<MutablePair<class_3499.class_3501, MovementContext>> getActors() {
        return this.actors;
    }

    @Nullable
    public MutablePair<class_3499.class_3501, MovementContext> getActorAt(class_2338 localPos) {
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            if (!localPos.equals((Object)((class_3499.class_3501)pair.left).comp_1341())) continue;
            return pair;
        }
        return null;
    }

    public Map<class_2338, MovingInteractionBehaviour> getInteractors() {
        return this.interactors;
    }

    public void invalidateColliders() {
        this.simplifiedEntityColliders = Optional.empty();
        this.gatherBBsOffThread();
    }

    private void gatherBBsOffThread() {
        this.getContraptionWorld();
        if (this.simplifiedEntityColliderProvider != null) {
            this.simplifiedEntityColliderProvider.cancel(false);
        }
        this.simplifiedEntityColliderProvider = CompletableFuture.supplyAsync(() -> {
            class_265 combinedShape = class_259.method_1073();
            for (Map.Entry<class_2338, class_3499.class_3501> entry : this.blocks.entrySet()) {
                class_3499.class_3501 info = entry.getValue();
                class_2338 localPos = entry.getKey();
                class_265 collisionShape = info.comp_1342().method_26194((class_1922)this.collisionLevel, localPos, class_3726.method_16194());
                if (collisionShape.method_1110()) continue;
                combinedShape = class_259.method_1082((class_265)combinedShape, (class_265)collisionShape.method_1096((double)localPos.method_10263(), (double)localPos.method_10264(), (double)localPos.method_10260()), (class_247)class_247.field_1366);
            }
            return combinedShape.method_1097().method_1090();
        }).thenAccept(r -> {
            this.simplifiedEntityColliders = Optional.of(r);
        });
    }

    public static double getRadius(Iterable<? extends class_2382> blocks, class_2350.class_2351 axis) {
        class_2350.class_2351 axisA;
        class_2350.class_2351 axisB = switch (axis) {
            case class_2350.class_2351.field_11048 -> {
                axisA = class_2350.class_2351.field_11052;
                yield class_2350.class_2351.field_11051;
            }
            case class_2350.class_2351.field_11052 -> {
                axisA = class_2350.class_2351.field_11048;
                yield class_2350.class_2351.field_11051;
            }
            case class_2350.class_2351.field_11051 -> {
                axisA = class_2350.class_2351.field_11048;
                yield class_2350.class_2351.field_11052;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(axis));
        };
        int maxDistSq = 0;
        for (class_2382 class_23822 : blocks) {
            int b;
            int a = class_23822.method_30558(axisA);
            int distSq = a * a + (b = class_23822.method_30558(axisB)) * b;
            if (distSq <= maxDistSq) continue;
            maxDistSq = distSq;
        }
        return Math.sqrt(maxDistSq);
    }

    public MountedStorageManager getStorage() {
        return this.storage;
    }

    public boolean isHiddenInPortal(class_2338 localPos) {
        return false;
    }

    public Optional<List<class_238>> getSimplifiedEntityColliders() {
        return this.simplifiedEntityColliders;
    }

    public void tickStorage(AbstractContraptionEntity entity) {
        this.getStorage().tick(entity);
    }

    public boolean containsBlockBreakers() {
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)((class_3499.class_3501)pair.getLeft()).comp_1342());
            if (!(behaviour instanceof BlockBreakingMovementBehaviour) && !(behaviour instanceof HarvesterMovementBehaviour)) continue;
            return true;
        }
        return false;
    }
}

