/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.behaviour.dispenser;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.zurrtum.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_5819;

public class DropperMovementBehaviour
extends MovementBehaviour {
    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        if (context.world.method_8608()) {
            return;
        }
        MountedItemStorage storage = context.getItemStorage();
        if (storage == null) {
            return;
        }
        int slot = DropperMovementBehaviour.getSlot(storage, context.world.field_9229, context.contraption.getStorage().getAllItems());
        if (slot == -1) {
            DropperMovementBehaviour.failDispense(context, pos);
            return;
        }
        class_1799 stack = storage.method_5438(slot).method_7972();
        MountedDispenseBehavior behavior = this.getDispenseBehavior(context, pos, stack);
        class_1799 remainder = behavior.dispense(stack, context, pos);
        storage.method_5447(slot, remainder);
    }

    protected MountedDispenseBehavior getDispenseBehavior(MovementContext context, class_2338 pos, class_1799 stack) {
        return DefaultMountedDispenseBehavior.INSTANCE;
    }

    private static int getSlot(MountedItemStorage storage, class_5819 random, class_1263 contraptionInventory) {
        IntArrayList filledSlots = new IntArrayList();
        int size = storage.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = storage.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_7947() == 1 && stack.method_7914() != 1) {
                storage.method_5447(i, class_1799.field_8037);
                boolean fill = DropperMovementBehaviour.tryTopOff(stack, contraptionInventory);
                storage.method_5447(i, stack);
                if (!fill) continue;
            }
            filledSlots.add(i);
        }
        return switch (filledSlots.size()) {
            case 0 -> -1;
            case 1 -> filledSlots.getInt(0);
            default -> (Integer)class_156.method_32309((List)filledSlots, (class_5819)random);
        };
    }

    private static boolean tryTopOff(class_1799 stack, class_1263 from) {
        int count = stack.method_7947();
        int extract = from.extract(stack, stack.method_7914() - count);
        if (extract == 0) {
            return false;
        }
        stack.method_7939(count + extract);
        return true;
    }

    private static void failDispense(MovementContext ctx, class_2338 pos) {
        ctx.world.method_20290(1001, pos, 0);
    }
}

