/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.api.effect.OpenPipeEffectHandler;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.fluids.FlowSource;
import com.zurrtum.create.content.fluids.FluidReactions;
import com.zurrtum.create.content.fluids.pipes.VanillaFluidTargets;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_12206;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class OpenEndedPipe
extends FlowSource {
    private static final Function<class_2338, Codec<OpenEndedPipe>> CODEC = class_156.method_34866(pos -> RecordCodecBuilder.create(instance -> instance.group((App)FluidStack.OPTIONAL_CODEC.fieldOf("Fluid").forGetter(i -> i.fluidHandler.stack), (App)Codec.BOOL.fieldOf("Pulling").forGetter(i -> i.wasPulling), (App)class_2350.field_29502.fieldOf("Direction").forGetter(i -> i.location.getFace())).apply((Applicative)instance, (stack, wasPulling, direction) -> new OpenEndedPipe((FluidStack)stack, (boolean)wasPulling, (class_2338)pos, (class_2350)direction))));
    private class_1937 world;
    private final class_2338 pos;
    private class_238 aoe;
    private final OpenEndFluidHandler fluidHandler = new OpenEndFluidHandler();
    private final class_2338 outputPos;
    private boolean wasPulling;

    public static Codec<OpenEndedPipe> codec(class_2338 pos) {
        return CODEC.apply(pos);
    }

    public OpenEndedPipe(BlockFace face) {
        super(face);
        this.outputPos = face.getConnectedPos();
        this.pos = face.getPos();
        this.aoe = new class_238(this.outputPos).method_1012(0.0, -1.0, 0.0);
        if (face.getFace() == class_2350.field_11033) {
            this.aoe = this.aoe.method_1012(0.0, -1.0, 0.0);
        }
    }

    private OpenEndedPipe(FluidStack stack, boolean wasPulling, class_2338 pos, class_2350 direction) {
        this(new BlockFace(pos, direction));
        this.fluidHandler.stack = stack;
        this.wasPulling = wasPulling;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2338 getOutputPos() {
        return this.outputPos;
    }

    public class_238 getAOE() {
        return this.aoe;
    }

    @Override
    public void manageSource(class_1937 world, class_2586 networkBE) {
        this.world = world;
    }

    @Override
    @Nullable
    public FluidInventory provideHandler() {
        return this.fluidHandler;
    }

    @Override
    public boolean isEndpoint() {
        return true;
    }

    private FluidStack removeFluidFromSpace(boolean simulate) {
        if (this.world == null) {
            return FluidStack.EMPTY;
        }
        if (!this.world.method_8477(this.outputPos)) {
            return FluidStack.EMPTY;
        }
        class_2680 state = this.world.method_8320(this.outputPos);
        class_3610 fluidState = state.method_26227();
        boolean waterlog = state.method_28498((class_2769)class_2741.field_12508);
        FluidStack drainBlock = VanillaFluidTargets.drainBlock(this.world, this.outputPos, state, simulate);
        if (!drainBlock.isEmpty()) {
            if (!simulate && state.method_28498((class_2769)class_2741.field_20432) && drainBlock.getFluid() == AllFluids.HONEY) {
                AdvancementBehaviour.tryAward((class_1922)this.world, this.pos, AllAdvancements.HONEY_DRAIN);
            }
            return drainBlock;
        }
        if (!waterlog && !state.method_45474()) {
            return FluidStack.EMPTY;
        }
        if (fluidState.method_15769() || !fluidState.method_15771()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(fluidState.method_15772(), 81000);
        if (simulate) {
            return stack;
        }
        if (FluidHelper.isWater(stack.getFluid())) {
            AdvancementBehaviour.tryAward((class_1922)this.world, this.pos, AllAdvancements.WATER_SUPPLY);
        }
        if (waterlog) {
            this.world.method_8652(this.outputPos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 3);
            this.world.method_64312(this.outputPos, (class_3611)class_3612.field_15910, 1);
        } else {
            class_2680 newState = (class_2680)fluidState.method_15759().method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(14));
            class_3610 newFluidState = newState.method_26227();
            class_3611 class_36112 = newFluidState.method_15772();
            if (class_36112 instanceof class_3609) {
                class_3218 serverWorld;
                class_3610 potentiallyFilled;
                class_3609 flowing = (class_3609)class_36112;
                class_36112 = this.world;
                if (class_36112 instanceof class_3218 && (potentiallyFilled = flowing.method_15727(serverWorld = (class_3218)class_36112, this.outputPos, newState)).equals((Object)fluidState)) {
                    return stack;
                }
            }
            this.world.method_8652(this.outputPos, newState, 3);
        }
        return stack;
    }

    private boolean provideFluidToSpace(FluidStack fluid, boolean simulate) {
        if (this.world == null) {
            return false;
        }
        if (!this.world.method_8477(this.outputPos)) {
            return false;
        }
        class_2680 state = this.world.method_8320(this.outputPos);
        class_3610 fluidState = state.method_26227();
        boolean waterlog = state.method_28498((class_2769)class_2741.field_12508);
        if (!waterlog && !state.method_45474()) {
            return false;
        }
        if (fluid.isEmpty()) {
            return false;
        }
        if (!(fluid.getFluid() instanceof class_3609)) {
            return false;
        }
        if (!FluidHelper.hasBlockState(fluid.getFluid())) {
            return true;
        }
        if (!fluidState.method_15769() && FluidHelper.convertToStill(fluidState.method_15772()) != fluid.getFluid()) {
            FluidReactions.handlePipeSpillCollision(this.world, this.outputPos, fluid.getFluid(), fluidState);
            return false;
        }
        if (fluidState.method_15771()) {
            return false;
        }
        if (waterlog && fluid.getFluid() != class_3612.field_15910) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (!((Boolean)AllConfigs.server().fluids.pipesPlaceFluidSourceBlocks.get()).booleanValue()) {
            return true;
        }
        if (((Boolean)this.world.method_75728().method_75697(class_12206.field_63755, this.outputPos)).booleanValue() && FluidHelper.isTag(fluid, (class_6862<class_3611>)class_3486.field_15517)) {
            int i = this.outputPos.method_10263();
            int j = this.outputPos.method_10264();
            int k = this.outputPos.method_10260();
            this.world.method_43128(null, (double)i, (double)j, (double)k, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (this.world.field_9229.method_43057() - this.world.field_9229.method_43057()) * 0.8f);
            return true;
        }
        if (waterlog) {
            this.world.method_8652(this.outputPos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
            this.world.method_64312(this.outputPos, (class_3611)class_3612.field_15910, 1);
            return true;
        }
        this.world.method_8652(this.outputPos, fluid.getFluid().method_15785().method_15759(), 3);
        return true;
    }

    private class OpenEndFluidHandler
    implements SidedFluidInventory {
        private static final Optional<Integer> MAX = Optional.of(81000);
        private static final int[] SLOTS = new int[]{0, 1};
        private FluidStack stack = FluidStack.EMPTY;
        private int previousAmount = 0;

        private OpenEndFluidHandler() {
        }

        @Override
        public FluidStack onExtract(FluidStack stack) {
            return this.removeMaxSize(stack, MAX);
        }

        @Override
        public int getMaxAmountPerStack() {
            return 81000;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public int[] getAvailableSlots(class_2350 side) {
            return SLOTS;
        }

        @Override
        public FluidStack getStack(int slot) {
            if (slot > 1) {
                return FluidStack.EMPTY;
            }
            if (slot == 0) {
                return this.stack;
            }
            if (this.stack == FluidStack.EMPTY) {
                this.stack = OpenEndedPipe.this.removeFluidFromSpace(false);
                if (!this.stack.isEmpty()) {
                    this.setMaxSize(this.stack, MAX);
                }
                return this.stack;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public int getMaxAmount(FluidStack stack) {
            OpenPipeEffectHandler effectHandler = OpenPipeEffectHandler.REGISTRY.get(stack.getFluid());
            if (effectHandler != null && !FluidHelper.hasBlockState(stack.getFluid())) {
                return 81;
            }
            return SidedFluidInventory.super.getMaxAmount(stack);
        }

        @Override
        public boolean canInsert(int slot, FluidStack resource, @Nullable class_2350 dir) {
            if (slot != 0 || !OpenEndedPipe.this.provideFluidToSpace(resource, true)) {
                return false;
            }
            if (!this.stack.isEmpty() && !this.matches(this.stack, resource)) {
                this.stack = FluidStack.EMPTY;
            }
            return true;
        }

        @Override
        public boolean canExtract(int slot, FluidStack stack, class_2350 dir) {
            return OpenEndedPipe.this.world != null && OpenEndedPipe.this.world.method_8477(OpenEndedPipe.this.outputPos);
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            if (slot != 0) {
                return;
            }
            if (stack != FluidStack.EMPTY) {
                this.setMaxSize(stack, MAX);
            }
            this.stack = stack;
        }

        @Override
        public void markDirty() {
            int amount = this.stack.getAmount();
            if (amount > this.previousAmount) {
                class_3611 fluid = this.stack.getFluid();
                OpenPipeEffectHandler effectHandler = OpenPipeEffectHandler.REGISTRY.get(fluid);
                if (effectHandler != null) {
                    effectHandler.apply(OpenEndedPipe.this.world, OpenEndedPipe.this.aoe, this.stack);
                }
                if ((this.stack.getAmount() == 81000 || !FluidHelper.hasBlockState(fluid)) && OpenEndedPipe.this.provideFluidToSpace(this.stack, false)) {
                    this.stack = FluidStack.EMPTY;
                }
                OpenEndedPipe.this.wasPulling = false;
            } else if (amount < this.previousAmount) {
                OpenEndedPipe.this.wasPulling = true;
            }
            this.previousAmount = this.stack.getAmount();
        }
    }
}

