/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_2189;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public abstract class BlockBreakingKineticBlockEntity
extends KineticBlockEntity {
    public static final AtomicInteger NEXT_BREAKER_ID = new AtomicInteger();
    protected int ticksUntilNextProgress;
    protected int destroyProgress;
    protected int breakerId = -NEXT_BREAKER_ID.incrementAndGet();
    protected class_2338 breakingPos;

    public BlockBreakingKineticBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.destroyProgress == -1) {
            this.destroyNextTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.ticksUntilNextProgress == -1) {
            this.destroyNextTick();
        }
    }

    public void destroyNextTick() {
        this.ticksUntilNextProgress = 1;
    }

    protected abstract class_2338 getBreakingPos();

    protected boolean shouldRun() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("Progress", this.destroyProgress);
        view.method_71465("NextTick", this.ticksUntilNextProgress);
        if (this.breakingPos != null) {
            view.method_71468("Breaking", class_2338.field_25064, (Object)this.breakingPos);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.destroyProgress = view.method_71424("Progress", 0);
        this.ticksUntilNextProgress = view.method_71424("NextTick", 0);
        this.breakingPos = view.method_71426("Breaking", class_2338.field_25064).orElse(null);
        super.read(view, clientPacket);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (!this.field_11863.method_8608() && this.destroyProgress != 0) {
            this.field_11863.method_8517(this.breakerId, this.breakingPos, -1);
        }
    }

    @Override
    public void tick() {
        float blockHardness;
        super.tick();
        if (this.field_11863.method_8608()) {
            return;
        }
        if (!this.shouldRun()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.breakingPos = this.getBreakingPos();
        if (this.ticksUntilNextProgress < 0) {
            return;
        }
        if (this.ticksUntilNextProgress-- > 0) {
            return;
        }
        class_2680 stateToBreak = this.field_11863.method_8320(this.breakingPos);
        if (!this.canBreak(stateToBreak, blockHardness = stateToBreak.method_26214((class_1922)this.field_11863, this.breakingPos))) {
            if (this.destroyProgress != 0) {
                this.destroyProgress = 0;
                this.field_11863.method_8517(this.breakerId, this.breakingPos, -1);
            }
            return;
        }
        float breakSpeed = this.getBreakSpeed();
        this.destroyProgress += class_3532.method_15340((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - this.destroyProgress));
        this.field_11863.method_8396(null, this.field_11867, stateToBreak.method_26231().method_10596(), class_3419.field_15245, 0.25f, 1.0f);
        if (this.destroyProgress >= 10) {
            this.onBlockBroken(stateToBreak);
            this.destroyProgress = 0;
            this.ticksUntilNextProgress = -1;
            this.field_11863.method_8517(this.breakerId, this.breakingPos, -1);
            return;
        }
        this.ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        this.field_11863.method_8517(this.breakerId, this.breakingPos, this.destroyProgress);
    }

    public boolean canBreak(class_2680 stateToBreak, float blockHardness) {
        return BlockBreakingKineticBlockEntity.isBreakable(stateToBreak, blockHardness);
    }

    public static boolean isBreakable(class_2680 stateToBreak, float blockHardness) {
        return !stateToBreak.method_51176() && !(stateToBreak.method_26204() instanceof class_2189) && blockHardness != -1.0f && !stateToBreak.method_26164(AllBlockTags.NON_BREAKABLE);
    }

    public void onBlockBroken(class_2680 stateToBreak) {
        class_243 vec = VecHelper.offsetRandomly(VecHelper.getCenterOf((class_2382)this.breakingPos), this.field_11863.field_9229, 0.125f);
        BlockHelper.destroyBlock(this.field_11863, this.breakingPos, 1.0f, stack -> {
            if (stack.method_7960()) {
                return;
            }
            if (!((Boolean)((class_3218)this.field_11863).method_64395().method_76185(class_1928.field_19392)).booleanValue()) {
                return;
            }
            class_1542 itementity = new class_1542(this.field_11863, vec.field_1352, vec.field_1351, vec.field_1350, stack);
            itementity.method_6988();
            itementity.method_18799(class_243.field_1353);
            this.field_11863.method_8649((class_1297)itementity);
        });
    }

    protected float getBreakSpeed() {
        return Math.abs(this.getSpeed() / 100.0f);
    }
}

