/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.belt;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.BeltInventory;
import com.zurrtum.create.content.kinetics.belt.transport.BeltMovementHandler;
import com.zurrtum.create.content.kinetics.belt.transport.BeltTunnelInteractionHandler;
import com.zurrtum.create.content.kinetics.belt.transport.ItemHandlerBeltSegment;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_4538;

public class BeltBlockEntity
extends KineticBlockEntity {
    public Map<class_1297, BeltMovementHandler.TransportedEntityInfo> passengers;
    public Optional<class_1767> color;
    public int beltLength;
    public int index;
    public CasingType casing;
    public boolean covered;
    protected class_2338 controller = class_2338.field_10980;
    protected BeltInventory inventory;
    public ItemHandlerBeltSegment itemHandler = null;
    public VersionedInventoryTrackerBehaviour invVersionTracker;
    public class_2487 trackerUpdateTag;

    public BeltBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.BELT, pos, state);
        this.casing = CasingType.NONE;
        this.color = Optional.empty();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::canInsertFrom).setInsertionHandler(this::tryInsertingFromSide).considerOccupiedWhen(this::isOccupied));
        behaviours.add(new TransportedItemStackHandlerBehaviour(this, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf));
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
    }

    @Override
    public void tick() {
        if (this.beltLength == 0) {
            BeltBlock.initBelt(this.field_11863, this.field_11867);
        }
        super.tick();
        if (!this.field_11863.method_8320(this.field_11867).method_27852((class_2248)AllBlocks.BELT)) {
            return;
        }
        this.initializeItemHandler();
        if (!this.isController()) {
            return;
        }
        this.invalidateRenderBoundingBox();
        this.getInventory().tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.passengers == null) {
            this.passengers = new HashMap<class_1297, BeltMovementHandler.TransportedEntityInfo>();
        }
        ArrayList toRemove = new ArrayList();
        this.passengers.forEach((entity, info) -> {
            boolean leftTheBelt;
            boolean canBeTransported = BeltMovementHandler.canBeTransported(entity);
            boolean bl = leftTheBelt = info.getTicksSinceLastCollision() > (this.method_11010().method_11654(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL ? 3 : 1);
            if (!canBeTransported || leftTheBelt) {
                toRemove.add(entity);
                return;
            }
            info.tick();
            BeltMovementHandler.transportEntity(this, entity, info);
        });
        toRemove.forEach(this.passengers::remove);
    }

    @Override
    public float calculateStressApplied() {
        if (!this.isController()) {
            return 0.0f;
        }
        return super.calculateStressApplied();
    }

    @Override
    public class_238 createRenderBoundingBox() {
        if (!this.isController()) {
            return super.createRenderBoundingBox();
        }
        return super.createRenderBoundingBox().method_1014((double)(this.beltLength + 1));
    }

    public void initializeItemHandler() {
        if (this.field_11863.method_8608() || this.itemHandler != null) {
            return;
        }
        if (this.beltLength == 0 || this.controller == null) {
            return;
        }
        if (!this.field_11863.method_8477(this.controller)) {
            return;
        }
        class_2586 be = this.field_11863.method_8321(this.controller);
        if (be == null || !(be instanceof BeltBlockEntity)) {
            return;
        }
        BeltInventory inventory = ((BeltBlockEntity)be).getInventory();
        if (inventory == null) {
            return;
        }
        this.itemHandler = new ItemHandlerBeltSegment(inventory, this.index);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.isController()) {
            this.getInventory().ejectAll();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (this.controller != null) {
            view.method_71468("Controller", class_2338.field_25064, (Object)this.controller);
        }
        view.method_71472("IsController", this.isController());
        view.method_71465("Length", this.beltLength);
        view.method_71465("Index", this.index);
        view.method_71468("Casing", CasingType.CODEC, (Object)this.casing);
        view.method_71472("Covered", this.covered);
        this.color.ifPresent(dyeColor -> view.method_71468("Dye", (Codec)class_1767.field_41600, dyeColor));
        if (this.isController()) {
            this.getInventory().write(view.method_71461("Inventory"));
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (view.method_71433("IsController", false)) {
            this.controller = this.field_11867;
        }
        this.color = view.method_71426("Dye", (Codec)class_1767.field_41600);
        if (!this.wasMoved) {
            if (!this.isController()) {
                this.controller = view.method_71426("Controller", class_2338.field_25064).orElse(null);
            }
            this.index = view.method_71424("Index", 0);
            this.beltLength = view.method_71424("Length", 0);
        }
        if (this.isController()) {
            this.getInventory().read(view.method_71434("Inventory"));
        }
        CasingType casingBefore = this.casing;
        boolean coverBefore = this.covered;
        this.casing = view.method_71426("Casing", CasingType.CODEC).orElse(CasingType.NONE);
        this.covered = view.method_71433("Covered", false);
        if (!clientPacket) {
            return;
        }
        if (casingBefore == this.casing && coverBefore == this.covered) {
            return;
        }
        if (this.method_11002()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
        }
    }

    @Override
    public void clearKineticInformation() {
        super.clearKineticInformation();
        this.beltLength = 0;
        this.index = 0;
        this.controller = null;
        this.trackerUpdateTag = new class_2487();
    }

    public boolean applyColor(class_1767 colorIn) {
        if (colorIn == null ? !this.color.isPresent() : this.color.isPresent() && this.color.get() == colorIn) {
            return false;
        }
        if (this.field_11863.method_8608()) {
            return true;
        }
        for (class_2338 blockPos : BeltBlock.getBeltChain((class_4538)this.field_11863, this.getController())) {
            BeltBlockEntity belt = BeltHelper.getSegmentBE((class_1936)this.field_11863, blockPos);
            if (belt == null) continue;
            belt.color = Optional.ofNullable(colorIn);
            belt.method_5431();
            belt.sendData();
        }
        return true;
    }

    public BeltBlockEntity getControllerBE() {
        if (this.controller == null) {
            return null;
        }
        if (!this.field_11863.method_8477(this.controller)) {
            return null;
        }
        class_2586 be = this.field_11863.method_8321(this.controller);
        if (be == null || !(be instanceof BeltBlockEntity)) {
            return null;
        }
        return (BeltBlockEntity)be;
    }

    public void setController(class_2338 controller) {
        this.controller = controller;
    }

    public class_2338 getController() {
        return this.controller == null ? this.field_11867 : this.controller;
    }

    public boolean isController() {
        return this.controller != null && this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    public float getBeltMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getDirectionAwareBeltMovementSpeed() {
        int offset = this.getBeltFacing().method_10171().method_10181();
        if (this.getBeltFacing().method_10166() == class_2350.class_2351.field_11048) {
            offset *= -1;
        }
        return this.getBeltMovementSpeed() * (float)offset;
    }

    public boolean hasPulley() {
        if (!this.method_11010().method_27852((class_2248)AllBlocks.BELT)) {
            return false;
        }
        return this.method_11010().method_11654(BeltBlock.PART) != BeltPart.MIDDLE;
    }

    protected boolean isLastBelt() {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        class_2350 direction = this.getBeltFacing();
        if (this.method_11010().method_11654(BeltBlock.SLOPE) == BeltSlope.VERTICAL) {
            return false;
        }
        BeltPart part = (BeltPart)((Object)this.method_11010().method_11654(BeltBlock.PART));
        if (part == BeltPart.MIDDLE) {
            return false;
        }
        boolean movingPositively = this.getSpeed() > 0.0f == (direction.method_10171().method_10181() == 1) ^ direction.method_10166() == class_2350.class_2351.field_11048;
        return part == BeltPart.START ^ movingPositively;
    }

    public class_2382 getMovementDirection(boolean firstHalf) {
        return this.getMovementDirection(firstHalf, false);
    }

    public class_2382 getBeltChainDirection() {
        return this.getMovementDirection(true, true);
    }

    protected class_2382 getMovementDirection(boolean firstHalf, boolean ignoreHalves) {
        boolean movingUp;
        boolean onSlope;
        boolean notHorizontal;
        if (this.getSpeed() == 0.0f) {
            return class_2338.field_10980;
        }
        class_2680 blockState = this.method_11010();
        class_2350 beltFacing = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
        BeltSlope slope = (BeltSlope)((Object)blockState.method_11654(BeltBlock.SLOPE));
        BeltPart part = (BeltPart)((Object)blockState.method_11654(BeltBlock.PART));
        class_2350.class_2351 axis = beltFacing.method_10166();
        class_2350 movementFacing = class_2350.method_10156((class_2350.class_2352)(axis == class_2350.class_2351.field_11048 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056), (class_2350.class_2351)axis);
        boolean bl = notHorizontal = blockState.method_11654(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL;
        if (this.getSpeed() < 0.0f) {
            movementFacing = movementFacing.method_10153();
        }
        class_2382 movement = movementFacing.method_62675();
        boolean slopeBeforeHalf = part == BeltPart.END == (beltFacing.method_10171() == class_2350.class_2352.field_11056);
        boolean bl2 = onSlope = notHorizontal && (part == BeltPart.MIDDLE || slopeBeforeHalf == firstHalf || ignoreHalves);
        boolean bl3 = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.UPWARD : BeltSlope.DOWNWARD) ? true : (movingUp = false);
        if (!onSlope) {
            return movement;
        }
        return new class_2382(movement.method_10263(), movingUp ? 1 : -1, movement.method_10260());
    }

    public class_2350 getMovementFacing() {
        class_2350.class_2351 axis = this.getBeltFacing().method_10166();
        return class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)(this.getBeltMovementSpeed() < 0.0f ^ axis == class_2350.class_2351.field_11048 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
    }

    public class_2350 getBeltFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
    }

    public BeltInventory getInventory() {
        if (!this.isController()) {
            BeltBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE != null) {
                return controllerBE.getInventory();
            }
            return null;
        }
        if (this.inventory == null) {
            this.inventory = new BeltInventory(this);
        }
        return this.inventory;
    }

    private void applyToAllItems(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        BeltBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return;
        }
        BeltInventory inventory = controller.getInventory();
        if (inventory != null) {
            inventory.applyToEachWithin((float)this.index + 0.5f, maxDistanceFromCenter, processFunction);
        }
    }

    private class_243 getWorldPositionOf(TransportedItemStack transported) {
        BeltBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return class_243.field_1353;
        }
        return BeltHelper.getVectorForOffset(controllerBE, transported.beltPosition);
    }

    public void setCasingType(CasingType type) {
        boolean shouldBlockHaveCasing;
        if (this.casing == type) {
            return;
        }
        class_2680 blockState = this.method_11010();
        boolean bl = shouldBlockHaveCasing = type != CasingType.NONE;
        if (this.field_11863.method_8608()) {
            this.casing = type;
            this.field_11863.method_8652(this.field_11867, (class_2680)blockState.method_11657((class_2769)BeltBlock.CASING, (Comparable)Boolean.valueOf(shouldBlockHaveCasing)), 0);
            AllClientHandle.INSTANCE.queueUpdate(this);
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 16);
            return;
        }
        if (this.casing != CasingType.NONE) {
            this.field_11863.method_20290(2001, this.field_11867, class_2248.method_9507((class_2680)(this.casing == CasingType.ANDESITE ? AllBlocks.ANDESITE_CASING.method_9564() : AllBlocks.BRASS_CASING.method_9564())));
        }
        if ((Boolean)blockState.method_11654((class_2769)BeltBlock.CASING) != shouldBlockHaveCasing) {
            KineticBlockEntity.switchToBlockState(this.field_11863, this.field_11867, (class_2680)blockState.method_11657((class_2769)BeltBlock.CASING, (Comparable)Boolean.valueOf(shouldBlockHaveCasing)));
        }
        this.casing = type;
        this.method_5431();
        this.sendData();
    }

    private boolean canInsertFrom(class_2350 side) {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        class_2680 state = this.method_11010();
        if (state.method_28498(BeltBlock.SLOPE) && (state.method_11654(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS || state.method_11654(BeltBlock.SLOPE) == BeltSlope.VERTICAL)) {
            return false;
        }
        return this.getMovementFacing() != side.method_10153();
    }

    private boolean isOccupied(class_2350 side) {
        BeltBlockEntity nextBeltController = this.getControllerBE();
        if (nextBeltController == null) {
            return true;
        }
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (nextInventory == null) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.getMovementFacing() == side.method_10153()) {
            return true;
        }
        return !nextInventory.canInsertAtFromSide(this.index, side);
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        BrassTunnelBlockEntity tunnelBE;
        BeltBlockEntity nextBeltController = this.getControllerBE();
        class_1799 inserted = transportedStack.stack;
        class_1799 empty = class_1799.field_8037;
        if (!BeltBlock.canTransportObjects(this.method_11010())) {
            return inserted;
        }
        if (nextBeltController == null) {
            return inserted;
        }
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (nextInventory == null) {
            return inserted;
        }
        class_2586 teAbove = this.field_11863.method_8321(this.field_11867.method_10084());
        if (teAbove instanceof BrassTunnelBlockEntity && (tunnelBE = (BrassTunnelBlockEntity)teAbove).hasDistributionBehaviour()) {
            if (!tunnelBE.getStackToDistribute().method_7960()) {
                return inserted;
            }
            if (!tunnelBE.testFlapFilter(side.method_10153(), inserted)) {
                return inserted;
            }
            if (!simulate) {
                BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.method_10153(), true);
                tunnelBE.setStackToDistribute(inserted, side.method_10153());
            }
            return empty;
        }
        if (this.isOccupied(side)) {
            return inserted;
        }
        if (simulate) {
            return empty;
        }
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = (float)this.index + 0.5f - Math.signum(this.getDirectionAwareBeltMovementSpeed()) / 16.0f;
        class_2350 movementFacing = this.getMovementFacing();
        if (!side.method_10166().method_10178()) {
            if (movementFacing != side) {
                transportedStack.sideOffset = (float)side.method_10171().method_10181() * 0.675f;
                if (side.method_10166() == class_2350.class_2351.field_11048) {
                    transportedStack.sideOffset *= -1.0f;
                }
            } else {
                float extraOffset = transportedStack.prevBeltPosition != 0.0f && BeltHelper.getSegmentBE((class_1936)this.field_11863, this.field_11867.method_10093(movementFacing.method_10153())) != null ? 0.26f : 0.0f;
                transportedStack.beltPosition = this.getDirectionAwareBeltMovementSpeed() > 0.0f ? (float)this.index - extraOffset : (float)(this.index + 1) + extraOffset;
            }
        }
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.insertedAt = this.index;
        transportedStack.insertedFrom = side;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.method_10153(), true);
        nextInventory.addItem(transportedStack);
        nextBeltController.method_5431();
        nextBeltController.sendData();
        return empty;
    }

    @Override
    protected boolean canPropagateDiagonally(IRotate block, class_2680 state) {
        return state.method_28498(BeltBlock.SLOPE) && (state.method_11654(BeltBlock.SLOPE) == BeltSlope.UPWARD || state.method_11654(BeltBlock.SLOPE) == BeltSlope.DOWNWARD);
    }

    @Override
    public float propagateRotationTo(KineticBlockEntity target, class_2680 stateFrom, class_2680 stateTo, class_2338 diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof BeltBlockEntity && !connectedViaAxes) {
            return this.getController().equals((Object)((BeltBlockEntity)target).getController()) ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public void invalidateItemHandler() {
        this.itemHandler = null;
    }

    public boolean shouldSkipVanillaRender() {
        if (this.field_11863 == null) {
            return !this.isController();
        }
        class_2680 state = this.method_11010();
        return state == null || !state.method_28498(BeltBlock.PART) || state.method_11654(BeltBlock.PART) != BeltPart.START;
    }

    public void setCovered(boolean blockCoveringBelt) {
        if (blockCoveringBelt == this.covered) {
            return;
        }
        this.covered = blockCoveringBelt;
        this.notifyUpdate();
    }

    public static enum CasingType implements class_3542
    {
        NONE,
        ANDESITE,
        BRASS;

        public static final Codec<CasingType> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(CasingType::values);
        }
    }
}

