/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.factoryBoard;

import com.mojang.serialization.Codec;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1920;
import org.jetbrains.annotations.Nullable;

public class FactoryPanelSupportBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    private static final Codec<List<FactoryPanelPosition>> LINKED_CODEC = Codec.list(FactoryPanelPosition.CODEC);
    public static final BehaviourType<FactoryPanelSupportBehaviour> TYPE = new BehaviourType();
    private List<FactoryPanelPosition> linkedPanels;
    private boolean changed;
    private Supplier<Boolean> outputPower;
    private Supplier<Boolean> isOutput;
    private Runnable onNotify;

    public FactoryPanelSupportBehaviour(SmartBlockEntity be, Supplier<Boolean> isOutput, Supplier<Boolean> outputPower, Runnable onNotify) {
        super(be);
        this.isOutput = isOutput;
        this.outputPower = outputPower;
        this.onNotify = onNotify;
        this.linkedPanels = new ArrayList<FactoryPanelPosition>();
    }

    public boolean shouldPanelBePowered() {
        return this.isOutput() && this.outputPower.get() != false;
    }

    public boolean isOutput() {
        return this.isOutput.get();
    }

    public void notifyLink() {
        this.onNotify.run();
    }

    @Override
    public void destroy() {
        for (FactoryPanelPosition panelPos : this.linkedPanels) {
            if (!this.getLevel().method_8477(panelPos.pos())) continue;
            ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at((class_1920)this.getLevel(), panelPos);
            behaviour.targetedByLinks.remove(this.getPos());
            behaviour.blockEntity.notifyUpdate();
        }
        super.destroy();
    }

    public void notifyPanels() {
        if (this.getLevel().method_8608()) {
            return;
        }
        Iterator<FactoryPanelPosition> iterator = this.linkedPanels.iterator();
        while (iterator.hasNext()) {
            FactoryPanelPosition panelPos = iterator.next();
            if (!this.getLevel().method_8477(panelPos.pos())) continue;
            ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at((class_1920)this.getLevel(), panelPos);
            if (behaviour == null) {
                iterator.remove();
                this.changed = true;
                continue;
            }
            behaviour.checkForRedstoneInput();
        }
    }

    @Nullable
    public Boolean shouldBePoweredTristate() {
        Iterator<FactoryPanelPosition> iterator = this.linkedPanels.iterator();
        while (iterator.hasNext()) {
            FactoryPanelPosition panelPos = iterator.next();
            if (!this.getLevel().method_8477(panelPos.pos())) {
                return null;
            }
            ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at((class_1920)this.getLevel(), panelPos);
            if (behaviour == null) {
                iterator.remove();
                this.changed = true;
                continue;
            }
            if (!behaviour.isActive() || !behaviour.satisfied || behaviour.count == 0) continue;
            return true;
        }
        return false;
    }

    public List<FactoryPanelPosition> getLinkedPanels() {
        return this.linkedPanels;
    }

    public void connect(ServerFactoryPanelBehaviour panel) {
        FactoryPanelPosition panelPosition = panel.getPanelPosition();
        if (this.linkedPanels.contains(panelPosition)) {
            return;
        }
        this.linkedPanels.add(panelPosition);
        this.changed = true;
    }

    public void disconnect(ServerFactoryPanelBehaviour panel) {
        this.linkedPanels.remove(panel.getPanelPosition());
        this.changed = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.changed) {
            this.changed = false;
            if (!this.isOutput()) {
                this.notifyLink();
            }
            this.blockEntity.method_5431();
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71468("LinkedGauges", LINKED_CODEC, this.linkedPanels);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        this.linkedPanels.clear();
        view.method_71426("LinkedGauges", LINKED_CODEC).ifPresent(this.linkedPanels::addAll);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }
}

