/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.tableCloth;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.logistics.tableCloth.ServerTableClothFilteringBehaviour;
import com.zurrtum.create.content.logistics.tableCloth.ShoppingListItem;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.component.AutoRequestData;
import com.zurrtum.create.infrastructure.component.ShoppingList;
import com.zurrtum.create.infrastructure.packet.c2s.LogisticalStockRequestPacket;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveBlockEntityPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ShopUpdatePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

public class TableClothBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public AutoRequestData requestData;
    public List<class_1799> manuallyAddedItems = new ArrayList<class_1799>();
    public UUID owner = null;
    public class_2350 facing;
    public boolean sideOccluded;
    public ServerFilteringBehaviour priceTag;
    private List<class_1799> renderedItemsForShop;

    public TableClothBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TABLE_CLOTH, pos, state);
        this.requestData = new AutoRequestData();
        this.facing = class_2350.field_11035;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.priceTag = new ServerTableClothFilteringBehaviour(this);
        behaviours.add(this.priceTag);
    }

    public List<class_1799> getItemsForRender() {
        if (this.isShop()) {
            if (this.renderedItemsForShop == null) {
                this.renderedItemsForShop = this.requestData.encodedRequest().stacks().stream().map(b -> b.stack).limit(4L).toList();
            }
            return this.renderedItemsForShop;
        }
        return this.manuallyAddedItems;
    }

    public void invalidateItemsForRender() {
        this.renderedItemsForShop = null;
    }

    public void notifyShopUpdate() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ShopUpdatePacket packet = new ShopUpdatePacket(this.field_11867);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(this.field_11867), false)) {
                player.field_13987.method_14364((class_2596)packet);
            }
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        class_2338 relativePos = this.field_11867.method_10093(this.facing);
        this.sideOccluded = this.field_11863.method_8320(relativePos).method_26164(AllBlockTags.TABLE_CLOTHS) || class_2248.method_9501((class_265)this.field_11863.method_8320(relativePos.method_10074()).method_26201(), (class_2350)this.facing.method_10153());
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(1.0);
    }

    public boolean isShop() {
        return !this.requestData.encodedRequest().isEmpty();
    }

    public class_1269 use(class_1657 player, class_3965 ray) {
        if (this.isShop()) {
            return this.useShop(player);
        }
        class_1799 heldItem = player.method_5998(class_1268.field_5808);
        if (heldItem.method_7960()) {
            if (this.manuallyAddedItems.isEmpty()) {
                return class_1269.field_5812;
            }
            player.method_6122(class_1268.field_5808, this.manuallyAddedItems.remove(this.manuallyAddedItems.size() - 1));
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14770, class_3419.field_15245, 0.5f, 1.0f);
            if (this.manuallyAddedItems.isEmpty()) {
                this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)TableClothBlock.HAS_BE, (Comparable)Boolean.valueOf(false)), 3);
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    RemoveBlockEntityPacket packet = new RemoveBlockEntityPacket(this.field_11867);
                    for (class_3222 serverPlayer : serverLevel.method_14178().field_17254.method_17210(new class_1923(this.field_11867), false)) {
                        serverPlayer.field_13987.method_14364((class_2596)packet);
                    }
                }
            } else {
                this.notifyUpdate();
            }
            return class_1269.field_5812;
        }
        if (this.manuallyAddedItems.size() >= 4) {
            return class_1269.field_5812;
        }
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14667, class_3419.field_15245, 0.5f, 1.0f);
        this.manuallyAddedItems.add(heldItem.method_46651(1));
        this.facing = player.method_5735().method_10153();
        heldItem.method_7934(1);
        if (heldItem.method_7960()) {
            player.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        this.notifyUpdate();
        return class_1269.field_5812;
    }

    public class_1269 useShop(class_1657 player) {
        StockTickerBlockEntity stbe;
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        class_1799 prevListItem = class_1799.field_8037;
        boolean addOntoList = false;
        for (int i = 0; i < 9; ++i) {
            class_1799 item = player.method_31548().method_5438(i);
            if (!item.method_31574((class_1792)AllItems.SHOPPING_LIST)) continue;
            prevListItem = item;
            addOntoList = true;
            player.method_31548().method_5447(i, class_1799.field_8037);
        }
        if (itemInHand.method_31574((class_1792)AllItems.SHOPPING_LIST)) {
            prevListItem = itemInHand;
            addOntoList = true;
        }
        if (!itemInHand.method_7960() && !addOntoList) {
            player.method_7353((class_2561)class_2561.method_43471((String)"create.stock_keeper.shopping_list_empty_hand"), true);
            AllSoundEvents.DENY.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            return class_1269.field_5812;
        }
        if (this.getPaymentItem().method_7960()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"create.stock_keeper.no_price_set"), true);
            AllSoundEvents.DENY.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            return class_1269.field_5812;
        }
        UUID tickerID = null;
        class_2338 tickerPos = this.requestData.targetOffset().method_10081((class_2382)this.field_11867);
        class_2586 class_25862 = this.field_11863.method_8321(tickerPos);
        if (class_25862 instanceof StockTickerBlockEntity && (stbe = (StockTickerBlockEntity)class_25862).isKeeperPresent()) {
            tickerID = stbe.behaviour.freqId;
        }
        int stockLevel = this.getStockLevelForTrade(ShoppingListItem.getList(prevListItem));
        if (tickerID == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"create.stock_keeper.keeper_missing").method_27692(class_124.field_1061), true);
            AllSoundEvents.DENY.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            return class_1269.field_5812;
        }
        if (stockLevel == 0) {
            player.method_7353((class_2561)class_2561.method_43471((String)"create.stock_keeper.out_of_stock").method_27692(class_124.field_1061), true);
            AllSoundEvents.DENY.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            if (!prevListItem.method_7960()) {
                if (player.method_5998(class_1268.field_5808).method_7960()) {
                    player.method_6122(class_1268.field_5808, prevListItem);
                } else {
                    player.method_31548().method_7398(prevListItem);
                }
            }
            return class_1269.field_5812;
        }
        Object list = new ShoppingList(new ArrayList<IntAttached<class_2338>>(), this.owner, tickerID);
        if (addOntoList) {
            ShoppingList prevList = ShoppingListItem.getList(prevListItem).duplicate();
            if (this.owner.equals(prevList.shopOwner()) && tickerID.equals(prevList.shopNetwork())) {
                list = prevList;
            } else {
                addOntoList = false;
            }
        }
        if (((ShoppingList)list).getPurchases(this.field_11867) >= stockLevel) {
            for (IntAttached intAttached : ((ShoppingList)list).purchases()) {
                if (!this.field_11867.equals(intAttached.getValue())) continue;
                intAttached.setFirst(Math.min(stockLevel, (Integer)intAttached.getFirst()));
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"create.stock_keeper.limited_stock").method_27692(class_124.field_1061), true);
        } else {
            AllSoundEvents.CONFIRM_2.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            ShoppingList.Mutable mutable = new ShoppingList.Mutable((ShoppingList)list);
            mutable.addPurchases(this.field_11867, 1);
            list = mutable.toImmutable();
            if (!addOntoList) {
                player.method_7353((class_2561)class_2561.method_43471((String)"create.stock_keeper.use_list_to_add_purchases").method_54663(0xEEEEEE), true);
            }
            if (!addOntoList) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_17481, class_3419.field_15245, 1.0f, 1.5f);
            }
        }
        class_1799 newListItem = ShoppingListItem.saveList(AllItems.SHOPPING_LIST.method_7854(), (ShoppingList)list, this.requestData.encodedTargetAddress());
        if (player.method_5998(class_1268.field_5808).method_7960()) {
            player.method_6122(class_1268.field_5808, newListItem);
        } else {
            player.method_31548().method_7398(newListItem);
        }
        return class_1269.field_5812;
    }

    public int getStockLevelForTrade(@Nullable ShoppingList otherPurchases) {
        InventorySummary recentSummary;
        class_2338 tickerPos = this.requestData.targetOffset().method_10081((class_2382)this.field_11867);
        class_2586 class_25862 = this.field_11863.method_8321(tickerPos);
        if (!(class_25862 instanceof StockTickerBlockEntity)) {
            return 0;
        }
        StockTickerBlockEntity stbe = (StockTickerBlockEntity)class_25862;
        if (this.field_11863.method_8608()) {
            if (stbe.getTicksSinceLastUpdate() > 15) {
                stbe.resetTicksSinceLastUpdate();
                AllClientHandle.INSTANCE.sendPacket(new LogisticalStockRequestPacket(stbe.method_11016()));
            }
            recentSummary = stbe.getLastClientsideStockSnapshotAsSummary();
        } else {
            recentSummary = stbe.getRecentSummary();
        }
        if (recentSummary == null) {
            return 0;
        }
        InventorySummary modifierSummary = new InventorySummary();
        if (otherPurchases != null) {
            modifierSummary = (InventorySummary)otherPurchases.bakeEntries((class_1936)this.field_11863, this.field_11867).getFirst();
        }
        int smallestQuotient = Integer.MAX_VALUE;
        for (BigItemStack entry : this.requestData.encodedRequest().stacks()) {
            if (entry.count <= 0) continue;
            smallestQuotient = Math.min(smallestQuotient, (recentSummary.getCountOf(entry.stack) - modifierSummary.getCountOf(entry.stack)) / entry.count);
        }
        return smallestQuotient;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71468("Items", CreateCodecs.ITEM_LIST_CODEC, this.manuallyAddedItems);
        view.method_71468("Facing", (Codec)class_2350.field_29502, (Object)this.facing);
        view.method_71468("RequestData", AutoRequestData.CODEC, (Object)this.requestData);
        if (this.owner != null) {
            view.method_71468("OwnerUUID", class_4844.field_25122, (Object)this.owner);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.manuallyAddedItems.clear();
        view.method_71426("Items", CreateCodecs.ITEM_LIST_CODEC).ifPresent(list -> this.manuallyAddedItems.addAll((Collection<class_1799>)list));
        this.requestData = view.method_71426("RequestData", AutoRequestData.CODEC).orElseGet(AutoRequestData::new);
        this.owner = view.method_71426("OwnerUUID", class_4844.field_25122).orElse(null);
        this.facing = view.method_71426("Facing", (Codec)class_2350.field_29502).orElse(class_2350.field_11033);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.manuallyAddedItems.forEach(stack -> class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)stack));
        this.manuallyAddedItems.clear();
    }

    public class_1799 getPaymentItem() {
        return this.priceTag.getFilter();
    }

    public int getPaymentAmount() {
        return this.priceTag.getFilter().method_7960() ? 1 : this.priceTag.count;
    }

    @Override
    public void transform(class_2586 blockEntity, StructureTransform transform) {
        this.facing = transform.mirrorFacing(this.facing);
        if (transform.rotationAxis == class_2350.class_2351.field_11052) {
            this.facing = transform.rotateFacing(this.facing);
        }
        this.notifyUpdate();
    }
}

