/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour;

import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.ConcurrentModificationException;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public abstract class BlockEntityBehaviour<T extends SmartBlockEntity> {
    public T blockEntity;
    private int lazyTickRate;
    private int lazyTickCounter;

    public BlockEntityBehaviour(T be) {
        this.blockEntity = be;
        this.setLazyTickRate(10);
    }

    public static <T extends BlockEntityBehaviour<?>> T get(class_1922 reader, class_2338 pos, BehaviourType<T> type) {
        class_2586 be;
        try {
            be = reader.method_8321(pos);
        }
        catch (ConcurrentModificationException e) {
            be = null;
        }
        return BlockEntityBehaviour.get(be, type);
    }

    public static <T extends BlockEntityBehaviour<?>> T get(class_2586 be, BehaviourType<T> type) {
        if (be == null) {
            return null;
        }
        if (!(be instanceof SmartBlockEntity)) {
            return null;
        }
        SmartBlockEntity ste = (SmartBlockEntity)be;
        return ste.getBehaviour(type);
    }

    public abstract BehaviourType<?> getType();

    public void initialize() {
    }

    public void tick() {
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
    }

    public void read(class_11368 view, boolean clientPacket) {
    }

    public void write(class_11372 view, boolean clientPacket) {
    }

    public void writeSafe(class_11372 view) {
        this.write(view, false);
    }

    public boolean isSafeNBT() {
        return false;
    }

    public ItemRequirement getRequiredItems() {
        return ItemRequirement.NONE;
    }

    public void onBlockChanged(class_2680 oldState) {
    }

    public void onNeighborChanged(class_2338 neighborPos) {
    }

    public void unload() {
    }

    public void destroy() {
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void lazyTick() {
    }

    public void onBehaviourAdded(BehaviourType<?> type, BlockEntityBehaviour<?> behaviour) {
    }

    public class_2338 getPos() {
        return this.blockEntity.method_11016();
    }

    public class_1937 getLevel() {
        return this.blockEntity.method_10997();
    }
}

