/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionWorld;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
public class ContraptionRenderInfo {
    public static final SuperByteBufferCache.Compartment<Pair<Contraption, class_11515>> CONTRAPTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final VirtualRenderWorld renderWorld;
    private final ContraptionMatrices matrices = new ContraptionMatrices();

    ContraptionRenderInfo(class_1937 level, Contraption contraption) {
        this.renderWorld = ContraptionRenderInfo.setupRenderWorld(level, contraption);
    }

    public static ContraptionRenderInfo get(Contraption contraption) {
        AtomicReference<?> renderInfo = contraption.renderInfo;
        ContraptionRenderInfo out = (ContraptionRenderInfo)renderInfo.getAcquire();
        if (out == null) {
            renderInfo.compareAndExchangeRelease(null, new ContraptionRenderInfo(contraption.entity.method_37908(), contraption));
            out = (ContraptionRenderInfo)renderInfo.getAcquire();
        }
        return out;
    }

    public VirtualRenderWorld getRenderWorld() {
        return this.renderWorld;
    }

    public ContraptionMatrices getMatrices() {
        return this.matrices;
    }

    public static SuperByteBuffer getBuffer(Contraption contraption, VirtualRenderWorld renderWorld, class_11515 renderType) {
        return SuperByteBufferCache.getInstance().get(CONTRAPTION, Pair.of((Object)contraption, (Object)renderType), () -> ContraptionRenderInfo.buildStructureBuffer(contraption, renderWorld, renderType));
    }

    public static void invalidate(Contraption contraption) {
        for (class_11515 renderType : class_11515.values()) {
            SuperByteBufferCache.getInstance().invalidate(CONTRAPTION, Pair.of((Object)contraption, (Object)renderType));
        }
    }

    public static VirtualRenderWorld setupRenderWorld(class_1937 level, Contraption c) {
        ContraptionWorld contraptionWorld = c.getContraptionWorld();
        class_2338 origin = c.anchor;
        int minBuildHeight = contraptionWorld.method_31607();
        int height = contraptionWorld.method_31605();
        VirtualRenderWorld renderWorld = new VirtualRenderWorld(level, minBuildHeight, height, (class_2382)origin){

            @Override
            public boolean supportsVisualization() {
                return VisualizationManager.supportsVisualization((class_1936)this.level);
            }
        };
        renderWorld.setBlockEntities(c.presentBlockEntities.values());
        for (class_3499.class_3501 info : c.getBlocks().values()) {
            renderWorld.method_8652(info.comp_1341(), info.comp_1342(), 0);
        }
        renderWorld.runLightEngine();
        return renderWorld;
    }

    private static SuperByteBuffer buildStructureBuffer(Contraption contraption, VirtualRenderWorld renderWorld, class_11515 layer) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.poseStack;
        class_5819 random = objects.random;
        Contraption.RenderedBlocks blocks = contraption.getRenderedBlocks();
        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();
        class_778.method_20544();
        for (class_2338 pos : blocks.positions()) {
            class_2680 state = blocks.lookup().apply(pos);
            if (state.method_26217() != class_2464.field_11458) continue;
            class_1087 model = dispatcher.method_3349(state);
            long randomSeed = state.method_26190(pos);
            random.method_43052(randomSeed);
            if (class_4696.method_23679((class_2680)state) != layer) continue;
            poseStack.method_22903();
            poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            ObjectArrayList parts = new ObjectArrayList();
            class_1087 class_10872 = WrapperBlockStateModel.unwrapCompat(model);
            if (class_10872 instanceof WrapperBlockStateModel) {
                WrapperBlockStateModel wrapper = (WrapperBlockStateModel)class_10872;
                wrapper.addPartsWithInfo((class_1920)renderWorld, pos, state, random, (List<class_10889>)parts);
            } else {
                model.method_68513(random, (List)parts);
            }
            renderer.method_3374((class_1920)renderWorld, (List)parts, state, pos, poseStack, (class_4588)sbbBuilder, true, class_4608.field_21444);
            poseStack.method_22909();
        }
        class_778.method_20545();
        return sbbBuilder.end();
    }

    @Environment(value=EnvType.CLIENT)
    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();

        private ThreadLocalObjects() {
        }
    }
}

