/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorClientBehaviour;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorPackagePhysicsData;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7923;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ChainConveyorRenderer
extends KineticBlockEntityRenderer<ChainConveyorBlockEntity> {
    public static final class_2960 CHAIN_LOCATION = class_2960.method_60656((String)"textures/block/chain.png");
    public static final int MIP_DISTANCE = 48;

    public ChainConveyorRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(ChainConveyorBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        class_2338 pos = be.method_11016();
        this.renderChains(be, ms, buffer, light, overlay);
        if (VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            return;
        }
        CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_WHEEL, be.method_11010()).light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
        for (ChainConveyorPackage chainConveyorPackage : be.getLoopingPackages()) {
            this.renderBox(be, ms, buffer, overlay, pos, chainConveyorPackage, partialTicks);
        }
        for (Map.Entry entry : be.getTravellingPackages().entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.renderBox(be, ms, buffer, overlay, pos, box, partialTicks);
            }
        }
    }

    private void renderBox(ChainConveyorBlockEntity be, class_4587 ms, class_4597 buffer, int overlay, class_2338 pos, ChainConveyorPackage box, float partialTicks) {
        if (box.worldPosition == null) {
            return;
        }
        if (box.item == null || box.item.method_7960()) {
            return;
        }
        ChainConveyorPackagePhysicsData physicsData = ChainConveyorClientBehaviour.physicsData(box, (class_1936)be.method_10997());
        if (physicsData.prevPos == null) {
            return;
        }
        class_243 position = physicsData.prevPos.method_35590(physicsData.pos, (double)partialTicks);
        class_243 targetPosition = physicsData.prevTargetPos.method_35590(physicsData.targetPos, (double)partialTicks);
        float yaw = AngleHelper.angleLerp(partialTicks, physicsData.prevYaw, physicsData.yaw);
        class_243 offset = new class_243(targetPosition.field_1352 - (double)pos.method_10263(), targetPosition.field_1351 - (double)pos.method_10264(), targetPosition.field_1350 - (double)pos.method_10260());
        class_2338 containingPos = class_2338.method_49638((class_2374)position);
        class_1937 level = be.method_10997();
        class_2680 blockState = be.method_11010();
        int light = class_765.method_23687((int)level.method_8314(class_1944.field_9282, containingPos), (int)level.method_8314(class_1944.field_9284, containingPos));
        if (physicsData.modelKey == null) {
            class_2960 key = class_7923.field_41178.method_10221((Object)box.item.method_7909());
            if (key == class_7923.field_41178.method_10137()) {
                return;
            }
            physicsData.modelKey = key;
        }
        SuperByteBuffer rigBuffer = CachedBuffers.partial(AllPartialModels.PACKAGE_RIGGING.get(physicsData.modelKey), blockState);
        SuperByteBuffer boxBuffer = CachedBuffers.partial(AllPartialModels.PACKAGES.get(physicsData.modelKey), blockState);
        class_243 dangleDiff = VecHelper.rotate(targetPosition.method_1031(0.0, 0.5, 0.0).method_1020(position), -yaw, class_2350.class_2351.field_11052);
        float zRot = class_3532.method_15393((float)((float)class_3532.method_15349((double)(-dangleDiff.field_1352), (double)dangleDiff.field_1351) * 57.295776f)) / 2.0f;
        float xRot = class_3532.method_15393((float)((float)class_3532.method_15349((double)dangleDiff.field_1350, (double)dangleDiff.field_1351) * 57.295776f)) / 2.0f;
        zRot = class_3532.method_15363((float)zRot, (float)-25.0f, (float)25.0f);
        xRot = class_3532.method_15363((float)xRot, (float)-25.0f, (float)25.0f);
        for (SuperByteBuffer buf : new SuperByteBuffer[]{rigBuffer, boxBuffer}) {
            buf.translate(offset);
            buf.translate(0.0f, 0.625f, 0.0f);
            buf.rotateYDegrees(yaw);
            buf.rotateZDegrees(zRot);
            buf.rotateXDegrees(xRot);
            if (physicsData.flipped && buf == rigBuffer) {
                buf.rotateYDegrees(180.0f);
            }
            buf.uncenter();
            buf.translate(0.0f, -PackageItem.getHookDistance(box.item) + 0.4375f, 0.0f);
            buf.light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
        }
    }

    private void renderChains(ChainConveyorBlockEntity be, class_4587 ms, class_4597 buffer, int light, int overlay) {
        float time = AnimationTickHolder.getRenderTime((class_1936)be.method_10997()) / (360.0f / Math.abs(be.getSpeed()));
        if ((time %= 1.0f) < 0.0f) {
            time += 1.0f;
        }
        float animation = time - 0.5f;
        for (class_2338 blockPos : be.connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = be.connectionStats.get(blockPos);
            if (stats == null) continue;
            class_243 diff = stats.end().method_1020(stats.start());
            double yaw = 57.2957763671875 * class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350);
            double pitch = 57.2957763671875 * class_3532.method_15349((double)diff.field_1351, (double)diff.method_18805(1.0, 0.0, 1.0).method_1033());
            class_1937 level = be.method_10997();
            class_2338 tilePos = be.method_11016();
            class_243 startOffset = stats.start().method_1020(class_243.method_24953((class_2382)tilePos));
            if (!VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
                SuperByteBuffer guard = CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_GUARD, be.method_11010());
                guard.center();
                guard.rotateYDegrees((float)yaw);
                guard.uncenter();
                guard.light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
            }
            ms.method_22903();
            PoseTransformStack chain = TransformStack.of(ms);
            chain.center();
            chain.translate(startOffset);
            chain.rotateYDegrees((float)yaw);
            chain.rotateXDegrees(90.0f - (float)pitch);
            chain.rotateYDegrees(45.0f);
            chain.translate(0.0f, 0.5f, 0.0f);
            chain.uncenter();
            int light1 = class_765.method_23687((int)level.method_8314(class_1944.field_9282, tilePos), (int)level.method_8314(class_1944.field_9284, tilePos));
            int light2 = class_765.method_23687((int)level.method_8314(class_1944.field_9282, tilePos.method_10081((class_2382)blockPos)), (int)level.method_8314(class_1944.field_9284, tilePos.method_10081((class_2382)blockPos)));
            boolean far = class_310.method_1551().field_1687 == be.method_10997() && !class_310.method_1551().method_31975().field_4344.method_19326().method_24802((class_2374)class_243.method_24953((class_2382)tilePos).method_1031((double)((float)blockPos.method_10263() / 2.0f), (double)((float)blockPos.method_10264() / 2.0f), (double)((float)blockPos.method_10260() / 2.0f)), 48.0);
            ChainConveyorRenderer.renderChain(ms, buffer, animation, stats.chainLength(), light1, light2, far);
            ms.method_22909();
        }
    }

    public static void renderChain(class_4587 ms, class_4597 buffer, float animation, float length, int light1, int light2, boolean far) {
        float radius = far ? 0.0625f : 0.09375f;
        float minV = far ? 0.0f : animation;
        float maxV = far ? 0.0625f : length + minV;
        float minU = far ? 0.1875f : 0.0f;
        float maxU = far ? 0.25f : 0.1875f;
        ms.method_22903();
        ms.method_22904(0.5, 0.0, 0.5);
        class_4588 vc = buffer.getBuffer(RenderTypes.chain(CHAIN_LOCATION));
        ChainConveyorRenderer.renderPart(ms, vc, length, 0.0f, radius, radius, 0.0f, -radius, 0.0f, 0.0f, -radius, minU, maxU, minV, maxV, light1, light2, far);
        ms.method_22909();
    }

    private static void renderPart(class_4587 pPoseStack, class_4588 pConsumer, float pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2, boolean far) {
        class_4587.class_4665 posestack$pose = pPoseStack.method_23760();
        Matrix4f matrix4f = posestack$pose.method_23761();
        float uO = far ? 0.0f : 0.1875f;
        ChainConveyorRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX0, pZ0, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX3, pZ3, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX1, pZ1, pX2, pZ2, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX2, pZ2, pX1, pZ1, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
    }

    private static void renderQuad(Matrix4f pPose, class_4587.class_4665 pNormal, class_4588 pConsumer, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2) {
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMinX, pMinZ, pMaxU, pMinV, light2);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMinX, pMinZ, pMaxU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMaxX, pMaxZ, pMinU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMaxX, pMaxZ, pMinU, pMinV, light2);
    }

    private static void addVertex(Matrix4f pPose, class_4587.class_4665 pNormal, class_4588 pConsumer, float pY, float pX, float pZ, float pU, float pV, int light) {
        pConsumer.method_22918(pPose, pX, pY, pZ).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(pU, pV).method_22922(class_4608.field_21444).method_60803(light).method_60831(pNormal, 0.0f, 1.0f, 0.0f);
    }

    public int method_33893() {
        return 256;
    }

    public boolean method_3563() {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ChainConveyorBlockEntity be, class_2680 state) {
        return CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_SHAFT, state);
    }

    @Override
    protected class_1921 getRenderType(ChainConveyorBlockEntity be, class_2680 state) {
        return class_1921.method_23579();
    }
}

