/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.client.content.contraptions.render.OrientedContraptionVisual;
import com.zurrtum.create.client.content.trains.bogey.BogeyVisual;
import com.zurrtum.create.client.content.trains.entity.CarriageContraptionEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.entity.behaviour.PortalCutoffBehaviour;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class CarriageContraptionVisual
extends OrientedContraptionVisual<CarriageContraptionEntity> {
    private final class_4587 poseStack = new class_4587();
    @Nullable
    private @Nullable Couple<@Nullable VisualizedBogey> bogeys;
    private final Couple<Boolean> bogeyHidden = Couple.create(() -> false);

    public CarriageContraptionVisual(VisualizationContext context, CarriageContraptionEntity entity, float partialTick) {
        super(context, entity, partialTick);
        PortalCutoffBehaviour behaviour = entity.getBehaviour(PortalCutoffBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.setVisual(this);
            behaviour.updateRenderedPortalCutoff();
        }
        this.animate(partialTick);
    }

    public void setBogeyVisibility(boolean first, boolean visible) {
        this.bogeyHidden.set(first, !visible);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        super.beginFrame(ctx);
        this.animate(ctx.partialTick());
    }

    private boolean checkCarriage(float pt) {
        if (this.bogeys != null) {
            return true;
        }
        Carriage carriage = ((CarriageContraptionEntity)this.entity).getCarriage();
        if (((CarriageContraptionEntity)this.entity).validForRender && carriage != null) {
            this.bogeys = carriage.bogeys.mapNotNull(bogey -> VisualizedBogey.of(this.visualizationContext, bogey, pt));
            this.updateLight(pt);
            return true;
        }
        return false;
    }

    private void animate(float partialTick) {
        if (!this.checkCarriage(partialTick)) {
            return;
        }
        float viewYRot = ((CarriageContraptionEntity)this.entity).getViewYRot(partialTick);
        float viewXRot = ((CarriageContraptionEntity)this.entity).getViewXRot(partialTick);
        int bogeySpacing = ((CarriageContraptionEntity)this.entity).getCarriage().bogeySpacing;
        this.poseStack.method_22903();
        Vector3f visualPosition = this.getVisualPosition(partialTick);
        TransformStack.of(this.poseStack).translate((Vector3fc)visualPosition);
        for (boolean current : Iterate.trueAndFalse) {
            VisualizedBogey visualizedBogey = this.bogeys.get(current);
            if (visualizedBogey == null) continue;
            if (this.bogeyHidden.get(current).booleanValue()) {
                visualizedBogey.visual.hide();
                continue;
            }
            this.poseStack.method_22903();
            CarriageBogey bogey = visualizedBogey.bogey;
            CarriageContraptionEntityRenderer.translateBogey(this.poseStack, bogey, bogeySpacing, viewYRot, viewXRot, bogey.yaw.getValue(partialTick), bogey.pitch.getValue(partialTick));
            this.poseStack.method_22904(0.0, -1.5078125, 0.0);
            class_2487 bogeyData = bogey.bogeyData;
            if (bogeyData == null) {
                bogeyData = new class_2487();
            }
            visualizedBogey.visual.update(bogeyData, bogey.wheelAngle.getValue(partialTick), this.poseStack);
            this.poseStack.method_22909();
        }
        this.poseStack.method_22909();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        if (this.bogeys == null) {
            return;
        }
        this.bogeys.forEach(bogey -> {
            if (bogey != null) {
                int packedLight = CarriageContraptionEntityRenderer.getBogeyLightCoords(((CarriageContraptionEntity)this.entity).method_37908(), bogey.bogey, () -> ((CarriageContraptionEntity)this.entity).method_31166(partialTick));
                bogey.visual.updateLight(packedLight);
            }
        });
    }

    @Override
    public void _delete() {
        super._delete();
        if (this.bogeys == null) {
            return;
        }
        this.bogeys.forEach(bogey -> {
            if (bogey != null) {
                bogey.visual.delete();
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private record VisualizedBogey(CarriageBogey bogey, BogeyVisual visual) {
        @Nullable
        static VisualizedBogey of(VisualizationContext ctx, CarriageBogey bogey, float partialTick) {
            BogeyVisual visual = AllBogeyStyleRenders.createVisual(bogey.getStyle(), bogey.getSize(), ctx, partialTick, true);
            if (visual == null) {
                return null;
            }
            return new VisualizedBogey(bogey, visual);
        }
    }
}

