/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.gl;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBufferType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class GlStateTracker {
    private static final int[] BUFFERS = new int[GlBufferType.values().length];
    private static int vao;
    private static int program;

    public static int getBuffer(GlBufferType type) {
        return BUFFERS[type.ordinal()];
    }

    public static int getVertexArray() {
        return vao;
    }

    public static int getProgram() {
        return program;
    }

    public static void _setBuffer(GlBufferType type, int id) {
        GlStateTracker.BUFFERS[type.ordinal()] = id;
    }

    public static void _setVertexArray(int id) {
        vao = id;
    }

    public static void _setProgram(int id) {
        program = id;
    }

    public static State getRestoreState() {
        return new State((int[])BUFFERS.clone(), vao, program, GlStateManager._getActiveTexture());
    }

    public static void bindVao(int vao) {
        if (vao != GlStateTracker.vao) {
            GlStateManager._glBindVertexArray((int)vao);
        }
    }

    public static void bindBuffer(GlBufferType type, int buffer) {
        if (BUFFERS[type.ordinal()] != buffer || type == GlBufferType.ELEMENT_ARRAY_BUFFER) {
            GlStateManager._glBindBuffer((int)type.glEnum, (int)buffer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record State(int[] buffers, int vao, int program, int activeTexture) implements AutoCloseable
    {
        public void restore() {
            if (this.vao != vao) {
                GlStateManager._glBindVertexArray((int)this.vao);
            }
            GlBufferType[] values = GlBufferType.values();
            for (int i = 0; i < values.length; ++i) {
                if (this.buffers[i] == BUFFERS[i] || values[i] == GlBufferType.ELEMENT_ARRAY_BUFFER) continue;
                GlStateManager._glBindBuffer((int)values[i].glEnum, (int)this.buffers[i]);
            }
            if (this.program != program) {
                GlStateManager._glUseProgram((int)this.program);
            }
            GlStateManager._activeTexture((int)this.activeTexture);
        }

        @Override
        public void close() {
            this.restore();
        }
    }
}

