/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueHandler;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.infrastructure.packet.c2s.ValueSettingsPacket;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class ValueSettingsScreen
extends AbstractSimiScreen {
    private int ticksOpen;
    private ValueSettingsBoard board;
    private int maxLabelWidth;
    private int valueBarWidth;
    private class_2338 pos;
    private ValueSettings initialSettings;
    private ValueSettings lastHovered = new ValueSettings(-1, -1);
    private Consumer<ValueSettings> onHover;
    private boolean iconMode;
    private int milestoneSize;
    private int soundCoolDown;
    private int netId;

    public ValueSettingsScreen(class_2338 pos, ValueSettingsBoard board, ValueSettings valueSettings, Consumer<ValueSettings> onHover, int netId) {
        this.pos = pos;
        this.board = board;
        this.initialSettings = valueSettings;
        this.onHover = onHover;
        this.netId = netId;
        this.iconMode = board.formatter() instanceof ValueSettingsFormatter.ScrollOptionSettingsFormatter;
        this.milestoneSize = this.iconMode ? 8 : 4;
    }

    @Override
    protected void method_25426() {
        int maxValue = this.board.maxValue();
        this.maxLabelWidth = 0;
        int milestoneCount = maxValue / this.board.milestoneInterval() + 1;
        int scale = maxValue > 128 ? 1 : 2;
        for (class_2561 component : this.board.rows()) {
            this.maxLabelWidth = Math.max(this.maxLabelWidth, this.field_22793.method_27525((class_5348)component));
        }
        if (this.iconMode) {
            this.maxLabelWidth = -18;
        }
        this.valueBarWidth = (maxValue + 1) * scale + 1 + milestoneCount * this.milestoneSize;
        int width = this.maxLabelWidth + 14 + (this.valueBarWidth + 10);
        int height = this.board.rows().size() * 11;
        this.setWindowSize(width, height);
        super.method_25426();
        class_241 coordinateOfValue = this.getCoordinateOfValue(this.initialSettings.row(), this.initialSettings.value());
        this.setCursor(coordinateOfValue);
    }

    private void setCursor(class_241 coordinateOfValue) {
        double guiScale = this.field_22787.method_22683().method_4495();
        GLFW.glfwSetCursorPos((long)this.field_22787.method_22683().method_4490(), (double)((double)coordinateOfValue.field_1343 * guiScale), (double)((double)coordinateOfValue.field_1342 * guiScale));
    }

    public ValueSettings getClosestCoordinate(int mouseX, int mouseY) {
        double diff;
        class_241 coord;
        int row;
        int column = 0;
        boolean milestonesOnly = ValueSettingsScreen.method_25442();
        double bestDiff = Double.MAX_VALUE;
        for (row = 0; row < this.board.rows().size(); ++row) {
            coord = this.getCoordinateOfValue(row, 0);
            diff = Math.abs(coord.field_1342 - (float)mouseY);
            if (bestDiff < diff) break;
            bestDiff = diff;
        }
        --row;
        bestDiff = Double.MAX_VALUE;
        while (column <= this.board.maxValue()) {
            coord = this.getCoordinateOfValue(row, milestonesOnly ? column * this.board.milestoneInterval() : column);
            diff = Math.abs(coord.field_1343 - (float)mouseX);
            if (bestDiff < diff) break;
            bestDiff = diff;
            ++column;
        }
        return new ValueSettings(row, milestonesOnly ? Math.min(column * this.board.milestoneInterval(), this.board.maxValue()) : --column);
    }

    public class_241 getCoordinateOfValue(int row, int column) {
        int scale = this.board.maxValue() > 128 ? 1 : 2;
        float xOut = (float)(this.guiLeft + (Math.max(1, column) - 1) / this.board.milestoneInterval() * this.milestoneSize + column * scale) + 1.5f;
        xOut += (float)(this.maxLabelWidth + 14 + 4);
        if (column % this.board.milestoneInterval() == 0) {
            xOut += (float)(this.milestoneSize / 2);
        }
        if (column > 0) {
            xOut += (float)this.milestoneSize;
        }
        float yOut = (float)this.guiTop + ((float)row + 0.5f) * 11.0f - 0.5f;
        return new class_241(xOut, yOut);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        int milestoneCount = this.board.maxValue() / this.board.milestoneInterval() + 1;
        int scale = this.board.maxValue() > 128 ? 1 : 2;
        class_2561 title = this.board.title();
        class_5250 tip = CreateLang.translateDirect("gui.value_settings.release_to_confirm", class_2561.method_43472((String)"key.use"));
        double fadeIn = Math.pow(class_3532.method_15350((double)((double)((float)this.ticksOpen + partialTicks) / 4.0), (double)0.0, (double)1.0), 1.0);
        int fattestLabel = Math.max(this.field_22793.method_27525((class_5348)tip), this.field_22793.method_27525((class_5348)title));
        if (this.iconMode) {
            for (int i = 0; i <= this.board.maxValue(); ++i) {
                fattestLabel = Math.max(fattestLabel, this.field_22793.method_27525((class_5348)this.board.formatter().format(new ValueSettings(0, i))));
            }
        }
        int fatTipOffset = Math.max(0, fattestLabel + 10 - (this.windowWidth + 13)) / 2;
        int bgWidth = Math.max(this.windowWidth + 13, fattestLabel + 10);
        int fadeInWidth = (int)((double)bgWidth * fadeIn);
        int fadeInStart = (bgWidth - fadeInWidth) / 2 - fatTipOffset;
        int additionalHeight = this.iconMode ? 46 : 33;
        UIRenderHelper.drawStretched(graphics, x - 11 + fadeInStart, y - 17, fadeInWidth, this.windowHeight + additionalHeight, AllGuiTextures.VALUE_SETTINGS_OUTER_BG);
        UIRenderHelper.drawStretched(graphics, x - 10 + fadeInStart, y - 18, fadeInWidth - 2, 1, AllGuiTextures.VALUE_SETTINGS_OUTER_BG);
        UIRenderHelper.drawStretched(graphics, x - 10 + fadeInStart, y - 17 + this.windowHeight + additionalHeight, fadeInWidth - 2, 1, AllGuiTextures.VALUE_SETTINGS_OUTER_BG);
        if (fadeInWidth > fattestLabel) {
            int textX = x - 11 - fatTipOffset + bgWidth / 2;
            graphics.method_51439(this.field_22793, title, textX - this.field_22793.method_27525((class_5348)title) / 2, y - 14, -2236963, false);
            graphics.method_51439(this.field_22793, (class_2561)tip, textX - this.field_22793.method_27525((class_5348)tip) / 2, y + this.windowHeight + additionalHeight - 27, -2236963, false);
        }
        this.renderBrassFrame(graphics, x + this.maxLabelWidth + 14, y - 3, this.valueBarWidth + 8, this.board.rows().size() * 11 + 5);
        UIRenderHelper.drawStretched(graphics, x + this.maxLabelWidth + 17, y, this.valueBarWidth + 2, this.board.rows().size() * 11 - 1, AllGuiTextures.VALUE_SETTINGS_BAR_BG);
        int originalY = y;
        for (class_2561 component : this.board.rows()) {
            int valueBarX = x + this.maxLabelWidth + 14 + 4;
            if (!this.iconMode) {
                UIRenderHelper.drawCropped(graphics, x - 4, y, this.maxLabelWidth + 8, 11, AllGuiTextures.VALUE_SETTINGS_LABEL_BG);
                for (int w = 0; w < this.valueBarWidth; w += AllGuiTextures.VALUE_SETTINGS_BAR.getWidth() - 1) {
                    UIRenderHelper.drawCropped(graphics, valueBarX + w, y + 1, Math.min(AllGuiTextures.VALUE_SETTINGS_BAR.getWidth() - 1, this.valueBarWidth - w), 8, AllGuiTextures.VALUE_SETTINGS_BAR);
                }
                graphics.method_51439(this.field_22793, component, x, y + 1, -12312576, false);
            }
            int milestoneX = valueBarX;
            for (int milestone = 0; milestone < milestoneCount; ++milestone) {
                if (this.iconMode) {
                    AllGuiTextures.VALUE_SETTINGS_WIDE_MILESTONE.render(graphics, milestoneX, y + 1);
                } else {
                    AllGuiTextures.VALUE_SETTINGS_MILESTONE.render(graphics, milestoneX, y + 1);
                }
                milestoneX += this.milestoneSize + this.board.milestoneInterval() * scale;
            }
            y += 11;
        }
        if (!this.iconMode) {
            this.renderBrassFrame(graphics, x - 7, originalY - 3, this.maxLabelWidth + 14, this.board.rows().size() * 11 + 5);
        }
        if (this.ticksOpen < 1) {
            return;
        }
        ValueSettings closest = this.getClosestCoordinate(mouseX, mouseY);
        if (!closest.equals(this.lastHovered)) {
            this.onHover.accept(closest);
            if (this.soundCoolDown == 0) {
                float pitch = (float)closest.value() / (float)this.board.maxValue();
                pitch = class_3532.method_16439((float)pitch, (float)1.15f, (float)1.5f);
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)pitch, (float)0.25f));
                ScrollValueHandler.wrenchCog.bump(3, -(closest.value() - this.lastHovered.value()) * 10);
                this.soundCoolDown = 1;
            }
        }
        this.lastHovered = closest;
        class_241 coordinate = this.getCoordinateOfValue(closest.row(), closest.value());
        class_5250 cursorText = this.board.formatter().format(closest);
        AllIcons cursorIcon = null;
        ValueSettingsFormatter valueSettingsFormatter = this.board.formatter();
        if (valueSettingsFormatter instanceof ValueSettingsFormatter.ScrollOptionSettingsFormatter) {
            ValueSettingsFormatter.ScrollOptionSettingsFormatter sosf = (ValueSettingsFormatter.ScrollOptionSettingsFormatter)valueSettingsFormatter;
            cursorIcon = sosf.getIcon(closest);
        }
        int cursorWidth = (cursorIcon != null ? 16 : this.field_22793.method_27525((class_5348)cursorText)) / 2 * 2 + 3;
        int cursorX = (int)coordinate.field_1343 - cursorWidth / 2;
        int cursorY = (int)coordinate.field_1342 - 7;
        if (cursorIcon != null) {
            AllGuiTextures.VALUE_SETTINGS_CURSOR_ICON.render(graphics, cursorX - 2, cursorY - 3);
            cursorIcon.render(graphics, cursorX + 1, cursorY - 1, -12378368);
            if (fadeInWidth > fattestLabel) {
                graphics.method_51439(this.field_22793, (class_2561)cursorText, x - 11 - fatTipOffset + (bgWidth - this.field_22793.method_27525((class_5348)cursorText)) / 2, originalY + this.windowHeight + additionalHeight - 40, -271235, false);
            }
            return;
        }
        AllGuiTextures.VALUE_SETTINGS_CURSOR_LEFT.render(graphics, cursorX - 3, cursorY);
        UIRenderHelper.drawCropped(graphics, cursorX, cursorY, cursorWidth, 14, AllGuiTextures.VALUE_SETTINGS_CURSOR);
        AllGuiTextures.VALUE_SETTINGS_CURSOR_RIGHT.render(graphics, cursorX + cursorWidth, cursorY);
        graphics.method_51439(this.field_22793, (class_2561)cursorText, cursorX + 2, cursorY + 3, -12312576, false);
    }

    protected void renderBrassFrame(class_332 graphics, int x, int y, int w, int h) {
        AllGuiTextures.BRASS_FRAME_TL.render(graphics, x, y);
        AllGuiTextures.BRASS_FRAME_TR.render(graphics, x + w - 4, y);
        AllGuiTextures.BRASS_FRAME_BL.render(graphics, x, y + h - 4);
        AllGuiTextures.BRASS_FRAME_BR.render(graphics, x + w - 4, y + h - 4);
        if (h > 8) {
            UIRenderHelper.drawStretched(graphics, x, y + 4, 3, h - 8, AllGuiTextures.BRASS_FRAME_LEFT);
            UIRenderHelper.drawStretched(graphics, x + w - 3, y + 4, 3, h - 8, AllGuiTextures.BRASS_FRAME_RIGHT);
        }
        if (w > 8) {
            UIRenderHelper.drawCropped(graphics, x + 4, y, w - 8, 3, AllGuiTextures.BRASS_FRAME_TOP);
            UIRenderHelper.drawCropped(graphics, x + 4, y + h - 3, w - 8, 3, AllGuiTextures.BRASS_FRAME_BOTTOM);
        }
    }

    public void method_25420(@NotNull class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int a = (int)(80.0f * Math.min(1.0f, ((float)this.ticksOpen + pPartialTick) / 20.0f)) << 24;
        graphics.method_25296(0, 0, this.field_22789, this.field_22790, 0x101010 | a, 0x101010 | a);
    }

    @Override
    public void method_25393() {
        ++this.ticksOpen;
        if (this.soundCoolDown > 0) {
            --this.soundCoolDown;
        }
        super.method_25393();
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        ValueSettings closest = this.getClosestCoordinate((int)pMouseX, (int)pMouseY);
        int column = closest.value() + (int)Math.signum(pScrollY) * (ValueSettingsScreen.method_25442() ? this.board.milestoneInterval() : 1);
        if ((column = class_3532.method_15340((int)column, (int)0, (int)this.board.maxValue())) == closest.value()) {
            return false;
        }
        this.setCursor(this.getCoordinateOfValue(closest.row(), column));
        return true;
    }

    public boolean method_16803(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.field_22787.field_1690.field_1904.method_1417(pKeyCode, pScanCode)) {
            class_1041 window = this.field_22787.method_22683();
            double x = this.field_22787.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
            double y = this.field_22787.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507();
            this.saveAndClose(x, y);
            return true;
        }
        return super.method_16803(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
        if (this.field_22787.field_1690.field_1904.method_1433(pButton)) {
            this.saveAndClose(pMouseX, pMouseY);
            return true;
        }
        return super.method_25406(pMouseX, pMouseY, pButton);
    }

    protected void saveAndClose(double pMouseX, double pMouseY) {
        ValueSettings closest = this.getClosestCoordinate((int)pMouseX, (int)pMouseY);
        this.field_22787.field_1724.field_3944.method_52787((class_2596)new ValueSettingsPacket(this.pos, closest.row(), closest.value(), null, null, class_2350.field_11036, ValueSettingsScreen.method_25441(), this.netId));
        this.method_25419();
    }

    public void method_25419() {
        super.method_25419();
    }
}

