/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10419;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_10526;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_796;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class SymmetryWandModel
implements class_10439,
class_10515<Object> {
    public static final class_2960 ID = class_2960.method_60655((String)"create", (String)"model/wand_of_symmetry");
    public static final class_2960 ITEM_ID = class_2960.method_60655((String)"create", (String)"item/wand_of_symmetry/item");
    public static final class_2960 CORE_ID = class_2960.method_60655((String)"create", (String)"item/wand_of_symmetry/core");
    public static final class_2960 CORE_GLOW_ID = class_2960.method_60655((String)"create", (String)"item/wand_of_symmetry/core_glow");
    public static final class_2960 BITS_ID = class_2960.method_60655((String)"create", (String)"item/wand_of_symmetry/bits");
    private static final int[] TINTS = new int[0];
    private final class_10809 settings;
    private final List<class_777> item;
    private final List<class_777> core;
    private final List<class_777> coreGlow;
    private final List<class_777> bits;
    private final Supplier<Vector3f[]> vector;

    public SymmetryWandModel(class_10809 settings, List<class_777> item, List<class_777> core, List<class_777> coreGlow, List<class_777> bits) {
        this.settings = settings;
        this.item = item;
        this.core = core;
        this.coreGlow = coreGlow;
        this.bits = bits;
        this.vector = Suppliers.memoize(() -> {
            HashSet set = new HashSet();
            SymmetryWandModel.calculatePosition(item, set::add);
            SymmetryWandModel.calculatePosition(core, set::add);
            SymmetryWandModel.calculatePosition(coreGlow, set::add);
            SymmetryWandModel.calculatePosition(bits, set::add);
            return (Vector3f[])set.toArray(Vector3f[]::new);
        });
    }

    private static void calculatePosition(List<class_777> quads, Consumer<Vector3f> consumer) {
        for (class_777 bakedQuad : quads) {
            class_796.method_67923((int[])bakedQuad.comp_3721(), consumer);
        }
    }

    public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_1309 user, int seed) {
        state.method_70946((Object)this);
        state.method_70947();
        class_10444.class_10446 renderState = state.method_65601();
        renderState.method_67995(this.vector);
        renderState.method_65617((class_10515)this, null);
        this.settings.method_68000(renderState, displayContext);
    }

    public void method_65694(@Nullable Object data, class_811 displayContext, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, boolean glint) {
        int maxLight = 0xF000F0;
        class_1921 translucent = RenderTypes.itemGlowingTranslucent();
        SymmetryWandModel.renderItem(matrices, vertexConsumers, light, overlay, this.item, class_4722.method_29382());
        SymmetryWandModel.renderItem(matrices, vertexConsumers, maxLight, overlay, this.core, RenderTypes.itemGlowingSolid());
        SymmetryWandModel.renderItem(matrices, vertexConsumers, maxLight, overlay, this.coreGlow, translucent);
        matrices.method_22903();
        float worldTime = AnimationTickHolder.getRenderTime() / 20.0f;
        float floating = class_3532.method_15374((float)worldTime) * 0.05f;
        float angle = worldTime * -10.0f % 360.0f;
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(angle));
        matrices.method_46416(-0.5f, floating - 0.5f, -0.5f);
        SymmetryWandModel.renderItem(matrices, vertexConsumers, maxLight, overlay, this.bits, translucent);
        matrices.method_22909();
    }

    private static void renderItem(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, List<class_777> item, class_1921 layer) {
        class_918.method_62476(null, (class_4587)matrices, (class_4597)vertexConsumers, (int)light, (int)overlay, (int[])TINTS, item, (class_1921)layer, (class_10444.class_10445)class_10444.class_10445.field_55341);
    }

    public void method_72175(Set<Vector3f> vertices) {
        throw new UnsupportedOperationException();
    }

    public Object method_65695(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Unbaked
    implements class_10439.class_10441 {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<? extends class_10439.class_10441> method_65585() {
            return CODEC;
        }

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(CORE_ID);
            resolver.markDependency(CORE_GLOW_ID);
            resolver.markDependency(BITS_ID);
        }

        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 model = baker.method_45872(ITEM_ID);
            class_10419 textures = model.method_68045();
            List quads = model.method_68034(textures, baker, (class_3665)class_1086.field_5350).method_68048();
            class_10809 settings = class_10809.method_68001((class_7775)baker, (class_10819)model, (class_10419)textures);
            return new SymmetryWandModel(settings, quads, Unbaked.bake(baker, CORE_ID), Unbaked.bake(baker, CORE_GLOW_ID), Unbaked.bake(baker, BITS_ID));
        }

        private static List<class_777> bake(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            return model.method_68034(model.method_68045(), baker, (class_3665)class_1086.field_5350).method_68048();
        }
    }
}

