/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.chassis.StickerBlockEntity;
import com.zurrtum.create.content.equipment.clipboard.ClipboardOverrides;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import com.zurrtum.create.content.redstone.diodes.BrassDiodeBlock;
import com.zurrtum.create.content.redstone.diodes.PoweredLatchBlock;
import com.zurrtum.create.content.redstone.diodes.PulseExtenderBlockEntity;
import com.zurrtum.create.content.redstone.diodes.PulseRepeaterBlockEntity;
import com.zurrtum.create.content.redstone.diodes.ToggleLatchBlock;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlock;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlockEntity;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import net.minecraft.class_6903;
import net.minecraft.class_8824;

@Environment(value=EnvType.CLIENT)
public class RedstoneScenes {
    public static void sticker(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("sticker", "Attaching blocks using the Sticker");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        Selection redstone = util.select().fromTo(0, 2, 2, 2, 2, 2);
        class_2338 stickerPos = util.grid().at(2, 2, 2);
        Selection stickerSelect = util.select().position(stickerPos);
        class_2338 buttonPos = util.grid().at(0, 2, 2);
        class_2338 bearingPos = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().fromTo(2, 1, 2, 0, 2, 2).substract(stickerSelect), class_2350.field_11033);
        scene.idle(10);
        ElementLink<WorldSectionElement> sticker = scene.world().showIndependentSection(stickerSelect, class_2350.field_11033);
        scene.idle(10);
        ElementLink<WorldSectionElement> plank = scene.world().showIndependentSection(util.select().position(2, 2, 1), class_2350.field_11035);
        scene.world().configureCenterOfRotation(sticker, util.vector().centerOf(stickerPos));
        scene.world().configureCenterOfRotation(plank, util.vector().centerOf(stickerPos));
        scene.overlay().showText(60).text("Stickers are ideal for Redstone-controlled block attachment").attachKeyFrame().pointAt(util.vector().blockSurface(stickerPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        scene.world().toggleRedstonePower(redstone);
        scene.world().modifyBlock(stickerPos, s -> (class_2680)s.method_11657((class_2769)StickerBlock.EXTENDED, (Comparable)Boolean.valueOf(true)), false);
        scene.effects().indicateRedstone(buttonPos);
        scene.world().modifyBlockEntity(stickerPos, StickerBlockEntity.class, be -> {
            be.update = true;
        });
        scene.idle(20);
        scene.world().toggleRedstonePower(redstone);
        scene.idle(20);
        scene.overlay().showText(60).text("Upon receiving a signal, it will toggle its state").pointAt(util.vector().blockSurface(stickerPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        scene.world().rotateBearing(bearingPos, 540.0f, 80);
        scene.world().rotateSection(sticker, 0.0, 540.0, 0.0, 80);
        scene.world().rotateSection(plank, 0.0, 540.0, 0.0, 80);
        scene.overlay().showText(70).text("If it is now moved in a contraption, the block will move with it").pointAt(util.vector().topOf(stickerPos)).placeNearTarget();
        scene.idle(90);
        scene.addKeyframe();
        scene.world().toggleRedstonePower(redstone);
        scene.world().modifyBlock(stickerPos, s -> (class_2680)s.method_11657((class_2769)StickerBlock.EXTENDED, (Comparable)Boolean.valueOf(false)), false);
        scene.effects().indicateRedstone(buttonPos);
        scene.world().modifyBlockEntity(stickerPos, StickerBlockEntity.class, be -> {
            be.update = true;
        });
        scene.idle(20);
        scene.world().toggleRedstonePower(redstone);
        scene.idle(20);
        scene.overlay().showText(60).text("Toggled once again, the block is no longer attached").pointAt(util.vector().blockSurface(stickerPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        scene.world().rotateBearing(bearingPos, 540.0f, 80);
        scene.world().rotateSection(sticker, 0.0, 540.0, 0.0, 80);
    }

    public static void contact(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("redstone_contact", "Redstone Contacts");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        Selection contactAndRedstone = util.select().fromTo(1, 1, 0, 1, 1, 2);
        Selection topContact = util.select().position(1, 2, 2);
        scene.world().toggleRedstonePower(contactAndRedstone);
        scene.world().toggleRedstonePower(topContact);
        scene.world().showSection(contactAndRedstone, class_2350.field_11033);
        class_2338 bearingPos = util.grid().at(3, 1, 2);
        scene.idle(25);
        ElementLink<WorldSectionElement> contact = scene.world().showIndependentSection(topContact, class_2350.field_11033);
        scene.idle(10);
        scene.world().toggleRedstonePower(topContact);
        scene.world().toggleRedstonePower(contactAndRedstone);
        scene.effects().indicateRedstone(util.grid().at(1, 1, 2));
        scene.idle(10);
        scene.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector().of(1.0, 2.0, 2.5)).text("Redstone Contacts facing each other will emit a redstone signal");
        scene.idle(70);
        scene.world().showSection(util.select().position(bearingPos), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSectionAndMerge(util.select().fromTo(2, 2, 2, 4, 2, 2), class_2350.field_11033, contact);
        scene.idle(10);
        scene.effects().superGlue(util.grid().at(1, 2, 2), class_2350.field_11034, true);
        scene.world().configureCenterOfRotation(contact, util.vector().centerOf(bearingPos));
        int speed = 2;
        scene.idle(10);
        scene.world().rotateBearing(bearingPos, 10.0f, speed);
        scene.world().rotateSection(contact, 0.0, 10.0, 0.0, speed);
        scene.idle(speed);
        scene.world().toggleRedstonePower(topContact);
        scene.world().toggleRedstonePower(contactAndRedstone);
        scene.effects().indicateRedstone(util.grid().at(1, 1, 2));
        scene.world().rotateBearing(bearingPos, 340.0f, 34 * speed);
        scene.world().rotateSection(contact, 0.0, 340.0, 0.0, 34 * speed);
        scene.addKeyframe();
        scene.idle(34 * speed);
        scene.overlay().showText(100).placeNearTarget().pointAt(util.vector().of(1.0, 1.5, 2.5)).text("This still applies when one of them is part of a moving Contraption");
        for (int i = 0; i < 5; ++i) {
            scene.world().toggleRedstonePower(topContact);
            scene.world().toggleRedstonePower(contactAndRedstone);
            scene.effects().indicateRedstone(util.grid().at(1, 1, 2));
            scene.world().rotateBearing(bearingPos, 20.0f, 2 * speed);
            scene.world().rotateSection(contact, 0.0, 20.0, 0.0, 2 * speed);
            scene.idle(2 * speed);
            scene.world().toggleRedstonePower(topContact);
            scene.world().toggleRedstonePower(contactAndRedstone);
            scene.world().rotateBearing(bearingPos, 340.0f, 34 * speed);
            scene.world().rotateSection(contact, 0.0, 340.0, 0.0, 34 * speed);
            scene.idle(34 * speed);
            if (i != 0) continue;
            scene.markAsFinished();
        }
        scene.world().toggleRedstonePower(topContact);
        scene.world().toggleRedstonePower(contactAndRedstone);
        scene.world().rotateBearing(bearingPos, 10.0f, speed);
        scene.world().rotateSection(contact, 0.0, 10.0, 0.0, speed);
    }

    public static void pulseExtender(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("pulse_extender", "Controlling signals using Pulse Extenders");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 circuitPos = util.grid().at(2, 1, 2);
        class_2338 leverPos = util.grid().at(4, 1, 2);
        scene.world().modifyBlockEntityNBT(util.select().position(circuitPos), PulseExtenderBlockEntity.class, nbt -> nbt.method_10569("ScrollValue", 30));
        scene.world().showSection(util.select().layersFrom(1).substract(util.select().position(circuitPos)), class_2350.field_11036);
        scene.idle(10);
        scene.world().showSection(util.select().position(circuitPos), class_2350.field_11033);
        scene.idle(20);
        class_243 circuitTop = util.vector().blockSurface(circuitPos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        scene.overlay().showText(70).text("Pulse Extenders can lengthen a signal passing through").attachKeyFrame().placeNearTarget().pointAt(circuitTop);
        scene.idle(60);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(2);
        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 2, 0, 1, 2));
        scene.idle(15);
        scene.overlay().showText(60).text("They activate after a short delay...").placeNearTarget().pointAt(util.vector().topOf(util.grid().at(0, 1, 2)));
        scene.idle(50);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(30);
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world().toggleRedstonePower(util.select().position(1, 1, 2));
        scene.idle(1);
        scene.world().toggleRedstonePower(util.select().position(0, 1, 2));
        scene.idle(15);
        scene.overlay().showText(40).text("...and cool down for the configured duration").placeNearTarget().pointAt(util.vector().topOf(util.grid().at(0, 1, 2)));
        scene.idle(50);
        scene.overlay().showRepeaterScrollInput(circuitPos, 60);
        scene.overlay().showControls(circuitTop, Pointing.DOWN, 60).rightClick();
        scene.idle(10);
        scene.overlay().showText(60).text("Using the value panel, the discharge time can be configured").attachKeyFrame().placeNearTarget().pointAt(circuitTop);
        scene.world().modifyBlockEntityNBT(util.select().position(circuitPos), PulseExtenderBlockEntity.class, nbt -> nbt.method_10569("ScrollValue", 120));
        scene.idle(70);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(2);
        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 2, 0, 1, 2));
        scene.idle(20);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(15);
        scene.overlay().showText(50).text("The configured duration can range up to an hour").placeNearTarget().pointAt(circuitTop);
        scene.idle(70);
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world().toggleRedstonePower(util.select().position(1, 1, 2));
        scene.idle(1);
        scene.world().toggleRedstonePower(util.select().position(0, 1, 2));
        scene.idle(15);
    }

    public static void pulseRepeater(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("pulse_repeater", "Controlling signals using Pulse Repeaters");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 circuitPos = util.grid().at(2, 1, 2);
        class_2338 leverPos = util.grid().at(4, 1, 2);
        scene.world().modifyBlockEntityNBT(util.select().position(circuitPos), PulseRepeaterBlockEntity.class, nbt -> nbt.method_10569("ScrollValue", 30));
        scene.world().showSection(util.select().layersFrom(1).substract(util.select().position(circuitPos)), class_2350.field_11036);
        scene.idle(10);
        scene.world().showSection(util.select().position(circuitPos), class_2350.field_11033);
        scene.idle(20);
        class_243 circuitTop = util.vector().blockSurface(circuitPos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(30);
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 2, 0, 1, 2));
        scene.idle(2);
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world().toggleRedstonePower(util.select().position(1, 1, 2));
        scene.idle(1);
        scene.world().toggleRedstonePower(util.select().position(0, 1, 2));
        scene.idle(15);
        scene.overlay().showText(60).text("Pulse Repeaters emit a short pulse after a delay").attachKeyFrame().placeNearTarget().pointAt(circuitTop);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(70);
        scene.overlay().showRepeaterScrollInput(circuitPos, 60);
        scene.overlay().showControls(circuitTop, Pointing.DOWN, 60).rightClick();
        scene.idle(10);
        scene.overlay().showText(60).text("Using the value panel, the charge time can be configured").attachKeyFrame().placeNearTarget().pointAt(circuitTop);
        scene.world().modifyBlockEntityNBT(util.select().position(circuitPos), PulseRepeaterBlockEntity.class, nbt -> nbt.method_10569("ScrollValue", 120));
        scene.idle(70);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(60);
        scene.overlay().showText(50).text("Configured delays can range up to an hour").placeNearTarget().pointAt(circuitTop);
        scene.idle(60);
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 2, 0, 1, 2));
        scene.idle(2);
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world().toggleRedstonePower(util.select().position(1, 1, 2));
        scene.idle(1);
        scene.world().toggleRedstonePower(util.select().position(0, 1, 2));
    }

    public static void poweredLatch(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("powered_latch", "Controlling signals using the Powered Latch");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 circuitPos = util.grid().at(2, 1, 2);
        class_2338 buttonPos = util.grid().at(4, 1, 2);
        class_243 circuitTop = util.vector().blockSurface(circuitPos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        scene.world().showSection(util.select().layersFrom(1).substract(util.select().position(circuitPos)), class_2350.field_11036);
        scene.idle(10);
        scene.world().showSection(util.select().position(circuitPos), class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showText(40).attachKeyFrame().text("Powered Latches are redstone controllable Levers").placeNearTarget().pointAt(circuitTop);
        scene.idle(50);
        scene.effects().indicateRedstone(buttonPos);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 0, 1, 2));
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)PoweredLatchBlock.POWERING);
        scene.idle(30);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 3, 1, 2));
        class_238 bb = new class_238(circuitPos).method_1009((double)-0.48f, (double)-0.45f, (double)-0.05f).method_989(0.575, -0.45, 0.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, bb, bb, 40);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).text("Signals at the back switch it on").placeNearTarget().pointAt(bb.method_1005());
        scene.idle(60);
        scene.effects().indicateRedstone(util.grid().at(2, 1, 0));
        scene.world().toggleRedstonePower(util.select().fromTo(2, 1, 0, 2, 1, 1));
        scene.world().toggleRedstonePower(util.select().fromTo(2, 1, 2, 0, 1, 2));
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)PoweredLatchBlock.POWERING);
        scene.idle(30);
        scene.world().toggleRedstonePower(util.select().fromTo(2, 1, 0, 2, 1, 1));
        bb = new class_238(circuitPos).method_1009((double)-0.05f, (double)-0.45f, (double)-0.48f).method_989(0.0, -0.45, 0.575);
        class_238 bb2 = new class_238(circuitPos).method_1009((double)-0.05f, (double)-0.45f, (double)-0.48f).method_989(0.0, -0.45, -0.575);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, bb, bb, 40);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, bb2, bb2, 40);
        scene.overlay().showText(40).colored(PonderPalette.RED).text("Signals from the side switch it back off").placeNearTarget().pointAt(bb2.method_1005());
        scene.idle(50);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay().showControls(circuitTop, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        scene.world().toggleRedstonePower(util.select().fromTo(2, 1, 2, 0, 1, 2));
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)PoweredLatchBlock.POWERING);
        scene.idle(10);
        scene.overlay().showText(50).text("Powered latches can also be toggled manually").placeNearTarget().pointAt(circuitTop);
        scene.idle(60);
        scene.overlay().showControls(circuitTop, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        scene.world().toggleRedstonePower(util.select().fromTo(2, 1, 2, 0, 1, 2));
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)PoweredLatchBlock.POWERING);
        scene.idle(10);
    }

    public static void poweredToggleLatch(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("powered_toggle_latch", "Controlling signals using the Powered Toggle Latch");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 circuitPos = util.grid().at(2, 1, 2);
        class_2338 buttonPos = util.grid().at(4, 1, 2);
        class_243 circuitTop = util.vector().blockSurface(circuitPos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        scene.world().showSection(util.select().layersFrom(1).substract(util.select().position(circuitPos)), class_2350.field_11036);
        scene.idle(10);
        scene.world().showSection(util.select().position(circuitPos), class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showText(40).attachKeyFrame().text("Powered Toggle Latches are redstone controllable Levers").placeNearTarget().pointAt(circuitTop);
        scene.idle(50);
        scene.effects().indicateRedstone(buttonPos);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 0, 1, 2));
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)ToggleLatchBlock.POWERING);
        scene.idle(30);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 3, 1, 2));
        class_238 bb = new class_238(circuitPos).method_1009((double)-0.48f, (double)-0.45f, (double)-0.05f).method_989(0.575, -0.45, 0.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, bb, bb, 40);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).text("Signals at the back will toggle its state").placeNearTarget().pointAt(bb.method_1005());
        scene.idle(60);
        scene.effects().indicateRedstone(buttonPos);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 0, 1, 2));
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)ToggleLatchBlock.POWERING);
        scene.idle(30);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 1, 2, 3, 1, 2));
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, bb, bb, 40);
        scene.overlay().showText(30).colored(PonderPalette.RED).text("...on and back off").placeNearTarget().pointAt(bb.method_1005());
        scene.idle(50);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay().showControls(circuitTop, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        scene.world().toggleRedstonePower(util.select().fromTo(2, 1, 2, 0, 1, 2));
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)ToggleLatchBlock.POWERING);
        scene.idle(10);
        scene.overlay().showText(50).text("Powered toggle latches can also be toggled manually").placeNearTarget().pointAt(circuitTop);
        scene.idle(60);
        scene.overlay().showControls(circuitTop, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        scene.world().toggleRedstonePower(util.select().fromTo(2, 1, 2, 0, 1, 2));
        scene.world().cycleBlockProperty(circuitPos, (class_2769<?>)ToggleLatchBlock.POWERING);
        scene.idle(10);
    }

    public static void analogLever(SceneBuilder scene, SceneBuildingUtil util) {
        int state;
        int i;
        scene.title("analog_lever", "Controlling signals using the Analog Lever");
        scene.configureBasePlate(0, 0, 5);
        class_2338[] wireLocations = new class_2338[]{util.grid().at(2, 1, 1), util.grid().at(2, 1, 0), util.grid().at(1, 1, 0), util.grid().at(0, 1, 0), util.grid().at(0, 1, 1), util.grid().at(0, 1, 2), util.grid().at(0, 1, 3), util.grid().at(0, 1, 4), util.grid().at(1, 1, 4), util.grid().at(2, 1, 4), util.grid().at(3, 1, 4), util.grid().at(4, 1, 4), util.grid().at(4, 1, 3), util.grid().at(4, 1, 2), util.grid().at(4, 1, 1)};
        Selection leverSelection = util.select().fromTo(2, 1, 2, 2, 2, 2);
        Selection lamp = util.select().position(4, 1, 0);
        class_2338 leverPos = util.grid().at(2, 2, 2);
        class_243 leverVec = util.vector().centerOf(leverPos).method_1031(0.0, -0.25, 0.0);
        scene.world().showSection(util.select().layersFrom(0).substract(lamp).substract(leverSelection), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(lamp, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(leverSelection, class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showText(60).text("Analog Levers make for a compact and precise source of redstone power").placeNearTarget().attachKeyFrame().pointAt(leverVec);
        scene.idle(70);
        class_2758 power = class_2457.field_11432;
        scene.overlay().showControls(leverVec, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        for (i = 0; i < 7; ++i) {
            scene.idle(2);
            state = i + 1;
            scene.world().modifyBlockEntityNBT(leverSelection, AnalogLeverBlockEntity.class, nbt -> nbt.method_10569("State", state));
            scene.world().modifyBlock(wireLocations[i], s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(8 - state)), false);
            scene.effects().indicateRedstone(wireLocations[i]);
        }
        scene.idle(20);
        scene.overlay().showText(60).attachKeyFrame().text("Right-click to increase its analog power output").placeNearTarget().pointAt(leverVec);
        scene.idle(70);
        scene.overlay().showControls(leverVec, Pointing.DOWN, 40).rightClick().whileSneaking();
        scene.idle(7);
        for (i = 7; i > 0; --i) {
            scene.idle(2);
            state = i - 1;
            if (i > 4) {
                scene.world().modifyBlockEntityNBT(leverSelection, AnalogLeverBlockEntity.class, nbt -> nbt.method_10569("State", state));
                scene.effects().indicateRedstone(wireLocations[state]);
            }
            scene.world().modifyBlock(wireLocations[i], s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(state > 2 ? 0 : 3 - state)), false);
        }
        scene.world().modifyBlock(wireLocations[0], s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(4)), false);
        scene.idle(20);
        scene.overlay().showText(60).attachKeyFrame().text("Right-click while Sneaking to decrease the power output again").placeNearTarget().pointAt(leverVec);
        scene.idle(70);
        scene.overlay().showControls(leverVec, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        for (i = 0; i < 15; ++i) {
            scene.idle(2);
            state = i + 1;
            if (i >= 4) {
                scene.world().modifyBlockEntityNBT(leverSelection, AnalogLeverBlockEntity.class, nbt -> nbt.method_10569("State", state));
                scene.effects().indicateRedstone(wireLocations[i]);
            }
            scene.world().modifyBlock(wireLocations[i], s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(16 - state)), false);
        }
        scene.world().toggleRedstonePower(lamp);
        scene.effects().indicateRedstone(leverPos);
        scene.effects().indicateRedstone(util.grid().at(4, 1, 1));
        scene.idle(20);
    }

    public static void nixieTube(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("nixie_tube", "Using Nixie Tubes");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0).add(util.select().fromTo(2, 1, 1, 2, 1, 2)), class_2350.field_11036);
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 1, 3), class_2350.field_11033);
        scene.idle(20);
        Selection tubes = util.select().fromTo(3, 1, 3, 1, 1, 3);
        scene.effects().indicateRedstone(util.grid().at(2, 1, 1));
        scene.world().modifyBlockEntityNBT(util.select().position(2, 1, 1), AnalogLeverBlockEntity.class, nbt -> nbt.method_10569("State", 11));
        scene.world().modifyBlock(util.grid().at(2, 1, 2), s -> (class_2680)s.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(11)), false);
        scene.world().modifyBlockEntityNBT(tubes, NixieTubeBlockEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 11));
        scene.idle(20);
        class_243 centerTube = util.vector().centerOf(2, 1, 3);
        scene.overlay().showText(60).attachKeyFrame().text("When powered by Redstone, Nixie Tubes will display the signal strength").placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(2, 1, 3), class_2350.field_11039));
        scene.idle(70);
        scene.world().hideSection(util.select().position(2, 1, 3), class_2350.field_11036);
        scene.idle(5);
        scene.world().hideSection(util.select().fromTo(2, 1, 1, 2, 1, 2), class_2350.field_11043);
        scene.idle(10);
        scene.world().modifyBlockEntityNBT(tubes, NixieTubeBlockEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 0));
        scene.world().showSection(tubes, class_2350.field_11033);
        scene.idle(20);
        class_1799 clipboard = AllItems.CLIPBOARD.method_7854();
        ClipboardOverrides.switchTo(ClipboardType.WRITTEN, clipboard);
        scene.overlay().showControls(centerTube.method_1031(1.0, 0.35, 0.0), Pointing.DOWN, 40).rightClick().withItem(clipboard);
        scene.idle(7);
        class_5250 component = class_2561.method_43470((String)"CREATE");
        for (int i = 0; i < 3; ++i) {
            int index = i;
            scene.world().modifyBlockEntityNBT(util.select().position(3 - i, 1, 3), NixieTubeBlockEntity.class, arg_0 -> RedstoneScenes.lambda$nixieTube$19(scene, (class_2561)component, index, arg_0));
        }
        scene.idle(10);
        scene.world().showSection(util.select().position(4, 1, 3), class_2350.field_11033);
        scene.idle(10);
        scene.special().createBirb(util.vector().topOf(util.grid().at(0, 0, 3)), ParrotPose.DancePose::new);
        scene.idle(20);
        scene.overlay().showText(80).attachKeyFrame().placeNearTarget().text("Using written Clipboards, custom text can be displayed").pointAt(util.vector().topOf(util.grid().at(3, 1, 3)).method_1031(-0.75, (double)-0.05f, 0.0));
        scene.idle(90);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(3, 1, 3), class_2350.field_11036), Pointing.DOWN, 30).withItem(new class_1799((class_1935)class_1802.field_8345));
        scene.idle(7);
        scene.world().setBlocks(util.select().fromTo(1, 1, 3, 3, 1, 3), (class_2680)AllBlocks.BLUE_NIXIE_TUBE.method_9564().method_11657((class_2769)NixieTubeBlock.field_11177, (Comparable)class_2350.field_11039), false);
        scene.idle(10);
        scene.overlay().showText(80).colored(PonderPalette.BLUE).text("Right-Click with Dye to change their display colour").attachKeyFrame().pointAt(util.vector().topOf(util.grid().at(3, 1, 3)).method_1031(-0.75, (double)-0.05f, 0.0)).placeNearTarget();
        scene.idle(60);
    }

    public static void redstoneLink(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("redstone_link", "Using Redstone Links");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0).add(util.select().fromTo(3, 1, 1, 2, 1, 1)), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 3, 0, 2, 3), class_2350.field_11033);
        scene.idle(10);
        Selection redstone = util.select().fromTo(3, 1, 1, 1, 1, 1);
        class_2338 leverPos = util.grid().at(3, 1, 1);
        class_2338 link1Pos = util.grid().at(1, 1, 1);
        class_2338 link2Pos = util.grid().at(1, 2, 2);
        class_2338 link3Pos = util.grid().at(3, 2, 2);
        Selection link1Select = util.select().position(link1Pos);
        Selection link2Select = util.select().position(link2Pos);
        Selection link3Select = util.select().position(link3Pos);
        class_243 link1Vec = util.vector().blockSurface(link1Pos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        class_243 link2Vec = util.vector().blockSurface(link2Pos, class_2350.field_11035).method_1031(0.0, 0.0, -0.1875);
        class_243 link3Vec = util.vector().blockSurface(link3Pos, class_2350.field_11035).method_1031(0.0, 0.0, -0.1875);
        scene.world().showSection(link1Select, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(link2Select, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(link3Select, class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(50).attachKeyFrame().text("Redstone Links can transmit redstone signals wirelessly").placeNearTarget().pointAt(link1Vec);
        scene.idle(60);
        scene.overlay().showControls(link2Vec, Pointing.UP, 40).rightClick().whileSneaking();
        scene.idle(7);
        scene.world().modifyBlock(link2Pos, s -> (class_2680)s.method_28493((class_2769)RedstoneLinkBlock.RECEIVER), true);
        scene.idle(10);
        scene.overlay().showText(50).text("Right-click while Sneaking to toggle receive mode").placeNearTarget().pointAt(link2Vec);
        scene.idle(60);
        scene.overlay().showControls(link3Vec, Pointing.UP, 40).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().modifyBlock(link3Pos, s -> (class_2680)s.method_28493((class_2769)RedstoneLinkBlock.RECEIVER), true);
        scene.idle(10);
        scene.overlay().showText(50).text("A simple Right-click with a Wrench can do the same").placeNearTarget().pointAt(link3Vec);
        scene.idle(70);
        scene.addKeyframe();
        scene.idle(10);
        scene.world().toggleRedstonePower(redstone);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(5);
        scene.world().toggleRedstonePower(util.select().fromTo(3, 2, 3, 1, 2, 2));
        scene.effects().indicateRedstone(link2Pos);
        scene.effects().indicateRedstone(link3Pos);
        scene.idle(10);
        scene.overlay().showText(70).colored(PonderPalette.GREEN).text("Receivers emit the redstone power of transmitters within 256 blocks").placeNearTarget().pointAt(link2Vec);
        scene.idle(80);
        scene.world().toggleRedstonePower(redstone);
        scene.idle(5);
        scene.world().toggleRedstonePower(util.select().fromTo(3, 2, 3, 1, 2, 2));
        scene.idle(20);
        class_243 frontSlot = link1Vec.method_1031(0.0, 0.025, -0.15);
        class_243 backSlot = link1Vec.method_1031(0.0, 0.025, 0.15);
        class_243 top2Slot = link2Vec.method_1031(0.0, 0.15, 0.0);
        class_243 bottom2Slot = link2Vec.method_1031(0.0, -0.2, 0.0);
        class_243 top3Slot = link3Vec.method_1031(0.0, 0.15, 0.0);
        class_243 bottom3Slot = link3Vec.method_1031(0.0, -0.2, 0.0);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay().showFilterSlotInput(frontSlot, class_2350.field_11036, 100);
        scene.overlay().showFilterSlotInput(backSlot, class_2350.field_11036, 100);
        scene.idle(10);
        scene.overlay().showText(50).text("Placing items in the two slots can specify a Frequency").placeNearTarget().pointAt(backSlot);
        scene.idle(60);
        class_1799 iron = new class_1799((class_1935)class_1802.field_8620);
        class_1799 gold = new class_1799((class_1935)class_1802.field_8695);
        class_1799 sapling = new class_1799((class_1935)class_1802.field_17535);
        scene.overlay().showControls(frontSlot, Pointing.UP, 30).withItem(iron);
        scene.idle(7);
        scene.overlay().showControls(backSlot, Pointing.DOWN, 30).withItem(sapling);
        scene.world().modifyBlockEntityNBT(link1Select, RedstoneLinkBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            nbt.method_67493("FrequencyLast", class_1799.field_24671, (DynamicOps)ops, (Object)iron);
        });
        scene.idle(7);
        scene.world().modifyBlockEntityNBT(link1Select, RedstoneLinkBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            nbt.method_67493("FrequencyFirst", class_1799.field_24671, (DynamicOps)ops, (Object)sapling);
        });
        scene.idle(20);
        scene.overlay().showControls(bottom2Slot, Pointing.UP, 30).withItem(iron);
        scene.idle(7);
        scene.overlay().showControls(top2Slot, Pointing.DOWN, 30).withItem(sapling);
        scene.world().modifyBlockEntityNBT(link2Select, RedstoneLinkBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            nbt.method_67493("FrequencyLast", class_1799.field_24671, (DynamicOps)ops, (Object)iron);
        });
        scene.idle(7);
        scene.world().modifyBlockEntityNBT(link2Select, RedstoneLinkBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            nbt.method_67493("FrequencyFirst", class_1799.field_24671, (DynamicOps)ops, (Object)sapling);
        });
        scene.idle(20);
        scene.overlay().showControls(bottom3Slot, Pointing.UP, 30).withItem(gold);
        scene.idle(7);
        scene.overlay().showControls(top3Slot, Pointing.DOWN, 30).withItem(sapling);
        scene.world().modifyBlockEntityNBT(link3Select, RedstoneLinkBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            nbt.method_67493("FrequencyLast", class_1799.field_24671, (DynamicOps)ops, (Object)gold);
        });
        scene.idle(7);
        scene.world().modifyBlockEntityNBT(link3Select, RedstoneLinkBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            nbt.method_67493("FrequencyFirst", class_1799.field_24671, (DynamicOps)ops, (Object)sapling);
        });
        scene.idle(20);
        scene.world().toggleRedstonePower(redstone);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(2);
        scene.world().toggleRedstonePower(util.select().fromTo(1, 2, 2, 1, 2, 3));
        scene.overlay().showText(90).attachKeyFrame().text("Only the links with matching Frequencies will communicate").placeNearTarget().pointAt(link2Vec);
        scene.idle(30);
        for (int i = 0; i < 4; ++i) {
            if (i % 2 == 1) {
                scene.effects().indicateRedstone(leverPos);
            }
            scene.world().toggleRedstonePower(redstone);
            scene.idle(2);
            scene.world().toggleRedstonePower(util.select().fromTo(1, 2, 2, 1, 2, 3));
            scene.idle(20);
        }
    }

    private static /* synthetic */ void lambda$nixieTube$19(SceneBuilder scene, class_2561 component, int index, class_2487 nbt) {
        class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
        nbt.method_67493("CustomText", class_8824.field_46597, (DynamicOps)ops, (Object)component);
        nbt.method_10569("CustomTextIndex", index);
    }
}

